#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)genftoca.fc	16.1.1.1 (ES0-DMD) 06/19/01 15:16:29 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++  GENFTOCA.FC  +++++++++++++++++++++++++++++++++++
.LANGUAGE C
.IDENTIFICATION Module GENFTOCA.FC
.COMMENTS
Contains GENCNV, GENNUM, GENLGN, GENTIM
.AUTHOR         K. Banse  	ESO - Garching
.KEYWORDS       tools
.ENVIRONMENT    FORTRAN and C standards
.VERSION  [1.00] 880414:  created 
.VERSION  [3.00] 901213:  Master file. CG.
.VERSION  [3.10] 920507:  Extracted from genftoc.fc, KB
-----------------------------------------------------------------------------*/

#include <ftoc.h>
#include <midas_def.h>


#if 0     /* ==== Original Code ==== */
SUBROUTINE GENCNV(text,type,maxval,ibuf,rbuf,dbuf,mm)
CHARACTER   text;	/* IN: input line (terminated by \0 )  */
fint2c	*type;		/* IN: = 1, for integer; = 2, for real; = 4, doubl pre*/
fint2c	*maxval;	/* IN: maximal no. of output values */
fint2c	*ibuf;		/* OUT: integer output buffer */
float   *rbuf;		/* OUT: real output buffer */
double  *dbuf;		/* OUT: double precision output buffer */
fint2c	*mm;
#else     /* ==== Generated Code === */
#define GENCNV	gencnv_
GENCNV(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */


*PARAM(7,7,1,fint2c *) = CGN_CNVT(STRIPPED_STRING(1,7,0),(int)*PARAM(2,7,1,fint2c *),(int)*PARAM(3,7,1,fint2c *),PARAM(4,7,1,fint2c *),PARAM(5,7,1,float *),PARAM(6,7,1,double *));
  ftoc_free(FORmark);    /* <forif> */

}

#if 0     /* ==== Original Code ==== */
SUBROUTINE GENNUM(text)
CHARACTER   text;	/* IN:  input string */
#else     /* ==== Generated Code === */
#define GENNUM	gennum_
GENNUM(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */

int ret;  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

ret = CGN_NUMBER(STRIPPED_STRING(1,1,0));
ftoc_free(FORmark); /* <forif> */return(ret);
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE GENLGN(infile,outfile,maxout)
CHARACTER   infile;	/* IN: input file name                  */
CHARACTER   outfile;	/* OUT: result file name                */
fint2c	*maxout;	/* IN: max length of outfile            */
#else     /* ==== Generated Code === */
#define GENLGN	genlgn_
GENLGN(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */

char *tmpfil;  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

	
tmpfil = C_STRING(2,3,1);

CGN_LOGNAM(STRIPPED_STRING(1,3,0),tmpfil,(int)*PARAM(3,3,2,fint2c *));

STRFCOPY(2,3,1,tmpfil);
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE GENTIM(time)
CHARACTER   time;	/* OUT: pointer to string of char containing the time */
#else     /* ==== Generated Code === */
#define GENTIM	gentim_
GENTIM(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */

char *mytime;  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

mytime = C_STRING(1,1,0);
OSY_ASCTIM(mytime);
STRFCOPY(1,1,0,mytime);
  ftoc_free(FORmark);    /* <forif> */
}


