#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)fintf.fc	16.1.1.1 (ES0-DMD) 06/19/01 15:15:57 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/* @(#)fintf.fc	16.1.1.1  (OAA-ASTRONET) 06/19/01 15:15:57   */
/*
 * HEADER : fintf.fc    - Vers 3.6.001  - Sep 1993 -  L. Fini, M. Pucillo
 *                      - Vers 3.6.000  - Oct 1991 -  L. Fini, M. Pucillo
 *
 *
 * AGL FORTRAN to C interface -- 	Generic version to be filtered 
 *					in order to generate the machine 
 *					dependent code.
 *
 *
 * This module is a C layer needed to interface the AGL FORTRAN interface
 * Layer to the AGL standard C interface
 *
 * Entry points correspond one-to-one to standard C interface (except for
 * AGIDN routine which is directly implemented in FORTRAN in file agidn.for
 *
 * The two routines: AG_SCAN, AG_DMSG are available in the C interface only
 *
 * Modified: 910617. CG: Master Fortran to C file. 
 * Modified: 910825. CG: This code only compiled for Unix systems.
 * Modified: 920115. CG: For both VMS and UNIX.
 *
 *
 * ===============================
 *  AGL FORTRAN STANDARD INTERFACE
 *
 *
 *
 *
 *
 *  The following entry points define the AGL standard FORTRAN interface
 *
 *
 * I   - Status operations
 *
 * AGCLS
 *
 * AGCDEF ( XCLIP0, XCLIP1, YCLIP0, YCLIP1 ) 
 * 
 * AGSSET (STRING)
 *
 * AGVDEF ( DEVICE, IDENT, XA, XB, YA, YB, XLIM, YLIM )
 *
 * AGVKIL
 * 
 * AGVSEL ( IDENT )
 *
 * AGWDEF ( X0, X1, Y0, Y1 )
 *
 * 
 * II  - Graphic primitives
 *
 * AGGPLG ( X, Y, N )
 *
 * AGGPLL ( X, Y, N )
 * 
 * AGGPLM ( X, Y, N, MARK )
 *
 * AGGINT ( X, Y, N )
 *
 * AGGTXT ( XT, YT, STRING, CENTRE )
 *
 * AGVERS
 * 
 *
 * III - Get information
 *
 * AGIGET (STRING,IVECT)
 * 
 * AGRGET (STRING,RVECT)
 * 
 * AGTGET ( STRING, XL, YL )
 * 
 * AGVLOC ( X, Y, CHAR, PIXVAL )
 *
 * AGVLOS ( X, Y, MAXLEN, STR, PIXVAL )
 *
 *
 * IV  - Metafile manipulation
 *
 * AGMCLS
 * 
 * AGMOPN ( NAME )
 * 
 * AGMRDW ( MFILE )
 *
 * AGMRES
 * 
 * AGMSUS
 *
 *
 * V   - Miscellaneous
 *
 * AGESC ( CMD, CMDLEN )
 *
 * AGDRIV 
 *
 * AGIDN ( IDENT )
 * 
 * AGMAGN ( XFACT, YFACT, X, Y, N )
 *
 * AGTROT ( X, Y, N )
 *
 * AGTSET ( XFACT, YFACT, ANGLE, ITEM )
 *
 * AGVN2U ( XN, YN, XV, YV )
 * 
 * AGVU2N ( XU, YU, XN, YN )
 *
 * AGVUPD 
 *
 * VI   - High level routines
 *
 * AGAXES ( X0, X1, Y0, Y1, CMDSTR )
 *
 * AGAXIS ( TYPE, DATA, LSPACE, FORM, LABEL )
 *
 * AGORAX ( TYPE, ENDS, DATA, FORM, LABEL )
 *
 * AGHIST ( X, Y, N, MODE, JOIN )
 *
 * AGNLIN ( X0, X1, Y0, Y1, CMDSTR )
 *
 */

#include <ftoc.h>

#ifndef MIN
#define MIN(x,y)        ((x) <= (y) ? (x):(y) )    /* Minimum */
#endif /* MIN */

/* I   - Status operations */

#define AGCDEF	agcdef_
ROUTINE AGCDEF (x1,x2,y1,y2)
float *x1;
float *x2;
float *y1;
float *y2; 
{ 
	AG_CDEF ( *x1, *x2, *y1, *y2 ); 
}

#define AGCLS	agcls_
ROUTINE AGCLS () { AG_CLS (); }

#if 0     /* ==== Original Code ==== */
SUBROUTINE AGSSET (command)
CHARACTER command;
#else     /* ==== Generated Code === */
#define AGSSET	agsset_
AGSSET(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
 
	AG_SSET ( STRIPPED_STRING(1,1,0) );
  ftoc_free(FORmark);    /* <forif> */ 
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE AGVDEF ( device, xa,xb,ya,yb,xlim,ylim)
CHARACTER device;
float *xa;
float *xb;
float *ya;
float *yb;
float *xlim;
float *ylim;
#else     /* ==== Generated Code === */
#define AGVDEF	agvdef_
AGVDEF(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */

  int ret;  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

  ret = AG_VDEF(STRIPPED_STRING(1,7,0), *PARAM(2,7,1,float *), *PARAM(3,7,1,float *), *PARAM(4,7,1,float *), *PARAM(5,7,1,float *), *PARAM(6,7,1,float *), *PARAM(7,7,1,float *));
  ftoc_free(FORmark); /* <forif> */return(ret);
}

#define AGVKIL	agvkil_
ROUTINE AGVKIL () { AG_VKIL (); }

#define AGVSEL	agvsel_
ROUTINE AGVSEL (id)
fint2c *id;        
{ 
	AG_VSEL ( *id ); 
}

#define AGWDEF	agwdef_
ROUTINE AGWDEF (x1,x2,y1,y2)
float *x1;
float *x2;
float *y1;
float *y2; 
{ 
	AG_WDEF ( *x1, *x2, *y1, *y2 ); 
}

/* II  - Graphic primitives */

#define AGGPLG	aggplg_
ROUTINE AGGPLG (xv,yv,np)
float xv[];
float yv[];
fint2c *np;
{ 
	AG_GPLG ( xv, yv, *np ); 
}

#define AGGPLL	aggpll_
ROUTINE AGGPLL (xv,yv,np)
float xv[];
float yv[];
fint2c *np;
{ 
	AG_GPLL ( xv, yv, *np ); 
}

#define AGGPLM	aggplm_
ROUTINE AGGPLM (xv,yv,np,mark)
float xv[];
float yv[];
fint2c  *np;
fint2c  *mark;
{ 
	AG_GPLM ( xv, yv, *np, *mark ); 
}

#define AGGINT	aggint_
ROUTINE AGGINT (xv,yv,np)
float xv[];
float yv[];
fint2c *np;
{ 
	AG_GINT ( xv, yv, *np ); 
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE AGGTXT (xc,yc,str,cntr)
float *xc;
float *yc;
CHARACTER str;
fint2c  *cntr;
#else     /* ==== Generated Code === */
#define AGGTXT	aggtxt_
AGGTXT(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
 
	AG_GTXT ( *PARAM(1,4,0,float *), *PARAM(2,4,0,float *), STRIPPED_STRING(3,4,0), *PARAM(4,4,1,fint2c *) );
  ftoc_free(FORmark);    /* <forif> */ 
}

#define AGVERS	agvers_
ROUTINE AGVERS () { AG_VERS (); }

#if 0     /* ==== Original Code ==== */
SUBROUTINE AGGERR (code,mesg)
fint2c *code;
CHARACTER mesg;
#else     /* ==== Generated Code === */
#define AGGERR	aggerr_
AGGERR(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
 
	AG_GERR( *PARAM(1,2,0,fint2c *), STRIPPED_STRING(2,2,0) );
  ftoc_free(FORmark);    /* <forif> */ 
}

#define AGISET	agiset_
ROUTINE AGISET (ints,numb) 
fint2c ints[],numb;  
{ 
	AG_ISET ( ints, numb ); 
}

#define AGRSET	agrset_
ROUTINE AGRSET (floats,numb) 
float floats[]; int numb; 
{ 
	AG_RSET(floats,numb); 
}

/* III - Get information */

#if 0     /* ==== Original Code ==== */
SUBROUTINE AGIGET (item,ival) 
CHARACTER item;
fint2c *ival;
#else     /* ==== Generated Code === */
#define AGIGET	agiget_
AGIGET(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

	AG_IGET (  STRIPPED_STRING(1,2,0),PARAM(2,2,1,fint2c *) );
  ftoc_free(FORmark);    /* <forif> */ 
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE AGRGET (item,fval) 
CHARACTER item;
float *fval;
#else     /* ==== Generated Code === */
#define AGRGET	agrget_
AGRGET(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
 
	AG_RGET ( STRIPPED_STRING(1,2,0),PARAM(2,2,1,float *) );
  ftoc_free(FORmark);    /* <forif> */ 
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE AGTGET ( chstrg, xd, yd )
CHARACTER chstrg;
float  *xd;
float  *yd;
#else     /* ==== Generated Code === */
#define AGTGET	agtget_
AGTGET(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

	AG_TGET ( STRIPPED_STRING(1,3,0),PARAM(2,3,1,float *),PARAM(3,3,1,float *) );
  ftoc_free(FORmark);    /* <forif> */ 
}

#define AGVLOC	agvloc_
ROUTINE AGVLOC (xv,yv,key,pixval)
float *xv;
float *yv;
fint2c *key;
fint2c *pixval;
{
	AG_VLOC ( xv, yv, key, pixval ); 
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE AGVLOS (xv,yv,maxlen,chstrg,pixval)
float *xv;
float *yv;
fint2c  *maxlen;
CHARACTER chstrg;
fint2c  *pixval;
#else     /* ==== Generated Code === */
#define AGVLOS	agvlos_
AGVLOS(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */

	int lng;
	char tmpstrg[512];  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */


	lng = MIN(*PARAM(3,5,0,fint2c *),512);
	lng = MIN(lng,sizeof(STRIPPED_STRING(4,5,0)));
	AG_VLOS (PARAM(1,5,0,float *),PARAM(2,5,0,float *), lng, tmpstrg,PARAM(5,5,1,fint2c *) ); 
	STRFCOPY(4,5,0,tmpstrg);
  ftoc_free(FORmark);    /* <forif> */
}

/* IV  - Metafile manipulation */

#define AGMCLS	agmcls_
ROUTINE AGMCLS () { AG_MCLS (); }

#if 0     /* ==== Original Code ==== */
SUBROUTINE AGMOPN ( fname )
CHARACTER fname;
#else     /* ==== Generated Code === */
#define AGMOPN	agmopn_
AGMOPN(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

	AG_MOPN ( STRIPPED_STRING(1,1,0) );
  ftoc_free(FORmark);    /* <forif> */ 
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE AGMRDW ( metafile )
CHARACTER metafile;
#else     /* ==== Generated Code === */
#define AGMRDW	agmrdw_
AGMRDW(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

	AG_MRDW ( STRIPPED_STRING(1,1,0) );
  ftoc_free(FORmark);    /* <forif> */ 
}

#define AGMRES	agmres_
ROUTINE AGMRES () { AG_MRES (); }

#define AGMSUS	agmsus_
ROUTINE AGMSUS () { AG_MSUS (); }

/* V  - Miscellaneus */

#if 0     /* ==== Original Code ==== */
SUBROUTINE AGESC (cmd,cmdlen)
CHARACTER cmd;
fint2c *cmdlen;
#else     /* ==== Generated Code === */
#define AGESC	agesc_
AGESC(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

	AG_ESC ( STRIPPED_STRING(1,2,0), *PARAM(2,2,1,fint2c *) );
  ftoc_free(FORmark);    /* <forif> */ 
}

#define AGDRIV	agdriv_
ROUTINE AGDRIV () { AG_DRIV (); }

#define AGMAGN	agmagn_
ROUTINE AGMAGN (xfact,yfact,xv,yv,np)
float *xfact;
float *yfact;
float xv[];
float yv[];
fint2c *np;
{
	AG_MAGN( *xfact, *yfact, xv, yv, *np ); 
}

#define AGTROT	agtrot_
ROUTINE AGTROT (xv,yv,np)
float xv[];
float yv[];
fint2c *np;
{
	AG_TROT ( xv, yv, *np ); 
}

#define AGTSET	agtset_
ROUTINE AGTSET (xoff,yoff,angle,item)
float *xoff;
float *yoff;
float *angle;
fint2c   *item;
{
	AG_TSET ( *xoff, *yoff, *angle, *item ); 
}

#define AGVN2U	agvn2u_
ROUTINE AGVN2U (xn,yn,xu,yu)
float *xn;
float *yn;
float *xu;
float *yu;
{
	AG_VN2U ( *xn, *yn, xu, yu ); 
}

#define AGVU2N	agvu2n_
ROUTINE AGVU2N (xu,yu,xn,yn)
float *xu;
float *yu;
float *xn;
float *yn;
{
	AG_VU2N ( *xu, *yu, xn, yn ); 
}

#define AGVUPD	agvupd_
ROUTINE AGVUPD () { AG_VUPD (); }

/* VI - High level routines */

#if 0     /* ==== Original Code ==== */
SUBROUTINE AGAXES (x1,x2,y1,y2,string)
float *x1;
float *x2;
float *y1;
float *y2; 
CHARACTER string;
#else     /* ==== Generated Code === */
#define AGAXES	agaxes_
AGAXES(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
 
	AG_AXES ( *PARAM(1,5,0,float *), *PARAM(2,5,0,float *), *PARAM(3,5,0,float *), *PARAM(4,5,0,float *), STRIPPED_STRING(5,5,0) );
  ftoc_free(FORmark);    /* <forif> */ 
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE AGAXIS ( type, data, lspace, form, label )
fint2c *type;
float *data;
float *lspace;
CHARACTER form;
CHARACTER label;
#else     /* ==== Generated Code === */
#define AGAXIS	agaxis_
AGAXIS(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
 
	AG_AXIS( *PARAM(1,5,0,fint2c *),PARAM(2,5,0,float *), *PARAM(3,5,0,float *), STRIPPED_STRING(4,5,0), STRIPPED_STRING(5,5,1) );
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE AGORAX ( type, ends, data, form, label )
fint2c *type;
float *ends;
float *data;
CHARACTER form;
CHARACTER label;
#else     /* ==== Generated Code === */
#define AGORAX	agorax_
AGORAX(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
 
	AG_ORAX( *PARAM(1,5,0,fint2c *),PARAM(2,5,0,float *),PARAM(3,5,0,float *), STRIPPED_STRING(4,5,0), STRIPPED_STRING(5,5,1) );
  ftoc_free(FORmark);    /* <forif> */
}

#define AGHIST	aghist_
ROUTINE AGHIST (xv,yv,np,mode,join)
float *xv;
float *yv; 
fint2c *np;
fint2c *mode;
fint2c *join;
{ 
	AG_HIST ( xv, yv, *np, *mode, *join ); 
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE AGNLIN (x1,x2,y1,y2,string)
float *x1;
float *x2;
float *y1;
float *y2; 
CHARACTER string;
#else     /* ==== Generated Code === */
#define AGNLIN	agnlin_
AGNLIN(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
 
	AG_NLIN ( *PARAM(1,5,0,float *), *PARAM(2,5,0,float *), *PARAM(3,5,0,float *), *PARAM(4,5,0,float *), STRIPPED_STRING(5,5,0) );
  ftoc_free(FORmark);    /* <forif> */ 
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE AGFILL(x,y,n,space,angle,sset)
float *x;
float *y;
fint2c   *n;
float *space;
float *angle;
CHARACTER sset;
#else     /* ==== Generated Code === */
#define AGFILL	agfill_
AGFILL(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

       AG_FILL(PARAM(1,6,0,float *),PARAM(2,6,0,float *), *PARAM(3,6,0,fint2c *), *PARAM(4,6,0,float *), *PARAM(5,6,0,float *), STRIPPED_STRING(6,6,0) );
  ftoc_free(FORmark);    /* <forif> */
}

