/* @(#)proto_idi.h	16.1.1.1 (ESO-IPG) 06/19/01 15:14:09 */
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.COPYRIGHT   (c) 1993 European Southern Observatory
.IDENTifer   proto_idi.h
.AUTHOR      C. Guirao IPG-ESO Garching
.KEYWORDS    prototypes
.LANGUAGE    C & ANSI-C
.PURPOSE     prototypes for IDI interface.
.VERSION     1.0     23-Feb-1994   Creation by CG.
------------------------------------------------------------*/

#ifndef PROTO_IDI
#define PROTO_IDI

# include <xsysinclude.h>

#ifdef __STDC__
#include <idistruct.h>


/* module idilocal1.c */

extern int Xwstinit(int flg, char * screen, int no, int * fono, int minlut);

extern void wr_lut(int dspno, struct lut_data *lut, int flag);

extern void rd_lut(int dspno, struct lut_data *lut);

extern int allo_mem(int dspno, struct mem_data *mem, int memid);

extern int allo_zmem(int dspno, struct mem_data *mem, int memid);

extern int get_hcopy(int dspno, struct mem_data *mem, int memid);

extern void smv(int flag, int dspno, struct mem_data *mem, int memid,
               int srcx, int srcy, unsigned int xdim, unsigned int ydim,
               int dstx, int dsty);

extern void int_enable(int dspno);

extern void int_disable(int dspno);

extern void exit_trg_enable(int dspno);

extern void wait_int(int dspno, int *type, int *data, char *cdata, 
                    int *position);

extern int trigsta(int dspno, int trgno, int event, int data, char *cbuf);

extern int buildRGBLUT(int num, int lutlen, XColor xcolo[],
                       unsigned long int *pxls);

extern void LUTinstall(int dspno);


/* module idilocal2.c */

extern int crea_win(int dspno, int xoff, int yoff, unsigned int xdim,
                    unsigned int ydim, char dspchar);

extern void cl_win(int dspno , int colval);

extern void set_wcur(int dspno , int nz);

extern void sendX(int dspno);

extern int crealph(int dspno , int dysize);

extern void clalph(int dspno , int flag , int x , int y , int dim);

extern void alprfr(int dspno, struct alph_data *alph);

extern void alptext(int flag, int dspno, struct alph_data *alph,
		    char *txt, int x0, int y0);

extern int crelutbar(int dspno, struct lut_bar *bar);

extern void vislutbar(int dspno, struct lut_bar *bar, int vis);

extern void updalutbar(int dspno, struct lut_bar *bar);

extern void get_string(int dspno, char *outbuf, int *lout);

extern void get_char(int dspno, char *outbuf);

extern void initgra(int dspno);

extern void polyline(int dspno, int dysize, struct mem_data *mem, 
                    int col, int style, int *xs, int *ys, int np);

extern void polyrefr(int dspno, struct mem_data *mem, int flag, int memid);

extern void txtline(int dspno, int dysize, struct mem_data *mem, char txt[],
                   int x0, int y0, int path, int orient, int col, int size);

extern void txtrefr(int dspno, struct mem_data *mem, int flag, int memid);

extern void rd_pllut(int dspno, struct lut_data *plut);

extern void do_misc(int dspno,int flag,int auxid, char *cbuf, int *ibuf,
		    float *rbuf);


/* module idilocal3.c */

extern void draw_curs(int dspno, int flag, int dysize, 
                      int curno, int xcur, int ycur, int cursh, int curcol);

extern void draw_rroi(int dspno, int flag, int dysize, 
                      int x0, int y0, int  x1, int y1, int roicol);

extern void draw_croi(int dspno, int flag, int dysize, 
                      int x0, int y0, int  r1, int r2, int r3, int roicol);

extern int font_load(int flag,int no,int *fontno);

extern void destroy(int dspno, char *stri);

extern int exposed(int wstno, int dispno);

extern int stopped(int dspno);

extern void iconify(int dspno, int flag);

extern void send_event(int dspno);



/* module idilocal4.c */

extern int get_plane_offset(unsigned int mask, unsigned int wordsize);

extern unsigned char * idi_conv24_32(XImage *image, unsigned char *src);

extern unsigned char *idi_conv32_16(XImage *image, unsigned char *src,
 		                    unsigned int wordsize);

extern unsigned char *idi_conv16_32(XImage *image, unsigned char *src,
 		                    unsigned int wordsize);

extern void idi_putimage(Display *display, Drawable draw, GC gc, XImage *image,
                         int sx, int sy, int dx, int dy, 
		         unsigned int width, unsigned int height);

extern XImage *idi_getsubimage(Display *display, Drawable draw, int x, int y,
                               unsigned int width, unsigned int height,
                               unsigned long int plane_mask,int format,
                               XImage *dimage, int dx, int dy);




/* module idiutil1.c */

extern void wr_mem(int dspno, int RGBflag, struct mem_data *mem,
		   int x0, int y0, int ix, int iy, int const_flag,
                   unsigned char *data);

extern void rd_mem(int dspno, int RGBflag, struct mem_data *mem, int hcopflag,
                  char *inpntr, int xoff, int yoff, int xsize, int ix, int iy, 
                  int ittf, unsigned char *data);

extern void show_pix8(int dspno, int cursno, int x0, int y0, int x1, int y1,
                     unsigned char *data);

extern void copy_mem(int dspno, struct mem_data *mema, int *offseta,
		     struct mem_data *memb, int *offsetb, int *xysize,
		     int zoomf);

extern void copy_zmem(int dspno , struct mem_data *mema);

extern void cp_zmem8(struct mem_data *mema, int offa, int xsiza,
		     int offb, int *xysize);

extern void cp_mem8(struct mem_data *mema, int offa, int xsiza,
		    struct mem_data *memb, int offb, int xsizb,
		    int *xysize, int zoomf);

extern void cp_mem16(struct mem_data *mema, int offa, int xsiz,
		     struct mem_data *memb, int offb, int xsizb,
		     int *xysize, int zoomf);

extern void cp_mem32(struct mem_data *mema, int offa, int xsiza,
                     struct mem_data *memb, int offb, int xsizb,
                     int *xysize, int zoomf);

extern void zero_mem(int dspno, struct mem_data *mem, int zflag, int bck);

extern void clmem(struct mem_data *mem);


/* module idiutil2.c */

extern void clgraph(struct mem_data * mem);

extern void loc_zero(int dspno);

extern void loc_mod(int dspno, int locno, int lkey);

extern void curmove(int dspno, int curno, int locno, int ldat, int *lpos);

extern void roimove(int dspno, int locno, int *lpos);

extern void roimodify(int dspno, int locno);

extern void polyclear(int dspno, struct mem_data *mem, 
	              int *xs, int *ys, int np);

extern void txtclear(int dspno, struct mem_data *mem, int xs, int ys, int np);

extern void allrefr(int dspno, struct mem_data *mem, int memid, int flag);

extern void rectrefr(int dspno, struct mem_data *mem, int memid);

extern void copy_over(int dspno, int memid, int append);


/* module iic.c */

extern int IICSCV_C(int display, int curn, int vis);

extern int IICRCP_C(int display, int inmemid, int curn, int *xcur, int *ycur,
                    int *outmemid);

extern int IICWCP_C(int display, int memid, int curn, int xcur, int ycur);

extern int IICINC_C(int display, int memid, int curn, int cursh, 
                    int curcol, int xcur, int ycur);


/* module iid1.c */

extern void IIDINIT(void);

extern int IIDOPN_C(char display[], int *displayid);


/* module iid2.c */

extern int IIDCLO_C(int display);

extern int IIDRST_C(int display);

extern void waste_disp(int dspno);

extern int IIDQDV_C(int display, int *nconf, int *xdev, int *ydev, 
                    int *depthdev, int *maxlutn, int *maxittn, int *maxcurn);

extern int IIDQCI_C(int display, int devcap, int size, int capdata[],
                    int *ncap);

extern int IIDQCR_C(int display, int devcap, int size, float capdata[],
	            int *ncap);

extern int IIDQDC_C(int display, int confn, int memtyp, int maxmem, 
                    int *confmode, int mlist[], int mxsize[], int mysize[],
                    int mdepth[], int ittlen[], int *nmem);

extern int IIDSDP_C(int display, int memlist[], int nmem, int lutflag[],
                    int ittflag[]);

extern int IIDSSS_C(int display, int memid[], int xoff[], int yoff[], 
                    int splitf, int splitx, int splity);

extern int IIDSNP_C(int display, int colmode, int npixel, int xoff, int yoff,
                    int depth, int packf, unsigned char *cdata);

extern int IIDICO_C (int display,int flag);

extern int IIDDEL_C(char display[], int *nodels, int *imindx, int *grindx);


/* module iie.c */

extern int IIEGDB_C(int display, int flag, int auxid, 
		    char *cbuf, int *ibuf, float*rbuf);

extern int IIESDB_C(int display, int flag, int auxid, 
		    char *cbuf, int *ibuf, float*rbuf);


/* module iig.c */

extern int IIGTXT_C(int display, int memid, char txt[], int x0, int y0,
                    int path, int orient, int color, int txtsize);

extern int IIGPLY_C(int display, int memid, int *x, int *y, int np,
                    int color, int style);

extern int IIGCPY_C (int display, int memid, int append);



/* module iii.c */

extern int IIISTI_C(int display);

extern int IIIEIW_C(int display , int trgstatus[10]);

extern int IIIGLE_C(int display , int evalno , int * cbuf);

extern int IIIGCE_C(int display , int evalno , char * cbuf);

extern int IIIGSE_C(int display , int evalno , char * cbuf , int * lcbuf);

extern int IIIGLD_C(int display , int locn , int * xdis , int * ydis);

extern int IIIENI_C(int display , int intype , int intid , int objtype , int objid , int oper , int trigger);


/* module iil.c */

extern int IILRIT_C(int display , int memid , int ittn , int ittstart , int ittlen , float ittdata[]);

extern int IILWLT_C(int display , int lutn , int lutstart , int lutlen , float lutdata[]);

extern int IILRLT_C(int display , int lutn , int lutstart , int lutlen , float lutdata[]);

extern int IILSBV_C(int display , int memid , int vis);

extern int IILWIT_C(int display , int memid , int ittn , int ittstart , int ittlen , float ittdata[]);


/*
 * module iim.c
 */

extern int IIMWMY_C(int display , int memid , unsigned char * data , int npixel , int depth , int packf , int x0 , int y0);

extern int IIMRMY_C(int display , int memid , int npixel , int x0 , int y0 , int depth , int packf , int ittf , unsigned char * data);

extern int IIMSMV_C(int display , int memlist[] , int nmem , int vis);

extern int IIMCMY_C(int display , int memlist[] , int nmem , int bck);

extern int IIMSLT_C(int display , int memid , int lutn , int ittn);

extern int IIMBLM_C(int display , int memlst[] , int nmem , float period[]);

extern int IIMCPY_C(int displaya , int memida , int * offseta , int displayb , int memidb , int * offsetb , int * xysize , int zoom);

extern int IIMCPV_C(int displaya , int memida , int * offseta , int displayb , int memidb , int * offsetb , int * xysize , int zoom);

extern int IIMSTW_C(int display , int memid , int loaddir , int xwdim , int ywdim , int depth , int xwoff , int ywoff);


/*
 * module iir.c
 */

extern int IIRSRV_C(int display , int roiid , int vis);

extern int IIRRRI_C(int display , int inmemid , int roiid , int * roixmin , int * roiymin , int * roixmax , int * roiymax , int * outmemid);

extern int IIRWRI_C(int display , int memid , int roiid , int roixmin , int roiymin , int roixmax , int roiymax);

extern int IICINR_C(int display , int memid , int roicol , int roixcen , int roiycen , int radiusi , int radiusm , int radiuso , int * roiid);

extern int IICRRI_C(int display , int inmemid , int roiid , int * roixcen , int * roiycen , int * radiusi , int * radiusm , int * radiuso , int * outmemid);

extern int IICWRI_C(int display , int memid , int roiid , int roixcen , int roiycen , int radiusi , int radiusm , int radiuso);

extern int IIRINR_C(int display , int memid , int roicol , int roixmin , int roiymin , int roixmax , int roiymax , int * roiid);


/* module iiz.c */

extern int IIZWZM_C(int display, int memlist[], int nmem, int zoom);

extern int IIZRSZ_C(int display, int memid, int *xscr, int *yscr, int *zoom);

extern int IIZWZP_C(int display, int xscr, int yscr, int zoom);

extern int IIZRZP_C(int display, int *xscr, int *yscr, int *zoom);

extern int IIZWSC_C(int display, int memlist[], int nmem, int xscr, int yscr);

extern int IIZWSZ_C (int display, int memid, int xscr, int yscr, int zoom);




/* module xwimg.c */

extern int XWIMG(int ldspno, int limch, char *frame, int *khelp, int loaddir,
		 int *npix, int *icen, float *cuts, int *scale);


/* main module idiserv.c */

extern void SetAutoCursor(char *cc, char *midw);

extern void iismrmy ();

extern void iisdsnp ();


#endif

#endif
