/* @(#)ldbext.h	16.1.1.1 (ESO-IPG) 06/19/01 15:14:05 */
/* ----------------------- LDBEXT ------------------------- 
 
               definition of local descriptor block
-----------------------------------------------------------  */

#define LDB_ELEMS 510
#define LDB_NDSCRB (LDB_ELEMS*4)
#define LDB_NDSCRW (LDB_NDSCRB/II_SIZE)
#define LDB_NDSCRW1 (LDB_NDSCRW-1)

/*        size in bytes of different data types */


#define II_SIZE  sizeof(int)
#define JJ_SIZE  sizeof(short int)
#define RR_SIZE  sizeof(float)
#define DD_SIZE  sizeof(double)


struct	LDB_STRUCT
	{
	int	BLKNUM;
	union
		{
		int      IWORD[LDB_NDSCRW];
		float	 RWORD[LDB_NDSCRW];
		char	 CWORD[LDB_NDSCRB];
		} 	LDBWORDS;

	int	NEXT;
	};


/*

     NDSCRW  ...  Number of descriptor 4-byte words in block.
     NDSCRW1 ...  Last index in LDB (remember that we start from 0 ...)
     NDSCRB  ...  Number of descriptor bytes (characters) in block.
     BLKNUM  ...  Block Number of this LDB.
     IWORD   ...  I-Descriptors. (addressed as 4-byte words)
     RWORD   ...  R-Descriptors. (addressed as 4-byte words)
     CWORD   ...  C-Descriptors. (addressed as characters)
     NEXT    ...  Next Local Descriptor Block.


  K. Banse   880323, 930907, 990304

*/
