/* @(#)fcbext.h	16.1.1.1 (ESO-IPG) 06/19/01 15:14:00 */
/*

--------------------- FCB - Frame Control Block --------------------- 
	
on file MID_INCLUDE:fcbext.h
K. Banse	921113, 930907, 950711, 990223, 010307
	
*/
	
#define ENTRY_SIZE 30
#define YENTRY_SIZE 100


struct FCB_STRUCT
	{
	float		OLDVERS;
	char		BDTYPE[8];
	int		NDVAL;
	char		RESERV0[20];	/* reserved for later use */
	char 		SWPSHORT;
	char 		SWPINT;
	char 		FLOTFMT;
	char 		DSCFLAG;	/* flag for descr. updates */
	char		VERSION[8];	/* SCFINF has to be in sync! */
	int		PROT;
	int		DATAINFO[6];	/* basic data information as integer */
	int		INCARN;
	int		PTRLDB;
	int		LEXBDF;
	int		PEXBDF;
	int		ENDLDB[2];
	char 		LEXJMP;		/* jump_data_blocks flag */
	char		RESERV1[15];	/* spare */
	short int	DIRUSE;		/* increases in chunks of 30 */
	short int	DIRBYTELEM;	/*  = 1 byte  */
	short int	DIRNOELEM;	/* increases in chunks of 1500 */
	short int	DIREXT;		/*  = 1500 bytes */
	int		DIRENTRY;	/*  = 30 bytes per entry */
	int		INLDB[2];	/* inital no. of LDBs  */
	char		RESERV2[24];	/* reserved for later use */
	int		DBEGIN;		/* initial size of dscdir */

	int		DFILLED;	/* old DIRUSE ... */
	int		DSIZE;		/* old DIRNOELEM ... */

	int		MAINSEG[5];
	char		CREATE[28];
	int		CRETIM[2];	/* creation time in secs. */
	char		RESERV3[272];	/* reserved for later use */
	int		FITSINFO[2];	/* Info for FITS files    */
	int		NEXT;
	};
	

/*

OLDVERS ...  Old Version number (only 3.0 + 4.0 supported)	R*4     4
             now set to 0.0
BDTYPE  ...  frame type: IMAGE, TABLE, FITFILE, ...		C*8     8
NDVAL   ...  Number of data values.				I*4     4
RESERV0 ...  FCB space reserved for future use.		        C*20   20
SWPSHORT     set according to <computer.h>                      C*1     1
             '=' for SWAPSHORT = 12, 's' for SWAPSHORT = 21
SWPINT       set according to <computer.h>                      C*1     1
             '=' for SWAPINT = 1234, 's' for SWAPINT = 4321
             'h' for SWAPINT = 2143, 'w' for SWAPINT = 3412
FLOTFMT      set according to <computer.h>                      C*1     1
             '=' for FLOATFMT = IEEEFLOAT
             'V' for FLOATFMT = VAXFLOAT
             'G' for FLOATFMT = VAXGFLOAT
             'H' for FLOATFMT = HPFLOAT
DSCFLAG ...  flag to indicate which version of the descriptor stuff 
	     is used 
	     'N' old format, 'Z' large f., 'Y' new name+help f. C*1	1
VERSION ...  Version in ASCII					C*8     8
             currently:  VERS_011 (since 01SEP)
PROT    ...  protection flag                			I*4     4
DATAINFO ..  basic data info available outside Midas	    (6) I*4    24
[0] 	     Naxis
[1] 	     Npix[0]
[2] 	     Npix[1]
[3] 	     Npix[2]
[4] 	     data format, D_R4_FORMAT, etc.
[5] 	     first byte where pixel values are stored
	     (counting begins at 0, like in C)
INCARN  ...  Number of incarnations in frame - initialized to 1	I*4     4
             currently not used
PTRLDB  ...  Pointer to 1. Local Descriptor Block.		I*4     4
LEXBDF  ...  Logical Extension of BDF (last block)		I*4     4
PEXBDF  ...  Physical Extension of BDF (last block)		I*4     4
ENDLDB  ...  Last used LDB # and first free word in block   (2) I*4     8
LEXJMP  ...  jump data blocks: 'Y' yes, do jump, else no 	C*1	1
RESERV1 ...  spare 						C*15   15
DIRUSE  ...  length of descriptor directory currently in use 	I*2     2
DIRBYTELEM   no. of bytes per element				I*2     2
DIRNOELEM    no. of allocated elements in descr. directory,  
	     initialized to 1500 (= 50 entries of 30 bytes)	I*2     2
DIREXT  ...  length of each extension of descriptor directory 
             currently = 1500 (in chars.)	                I*2     2
DIRENTRY     length of single entry in descr. directory 
             (in chars.)	                                I*4     4
INLDB   ...  Initial no. of LDBs for dscdir + descr data    (2) I*4     8
RESERV2 ...  FCB space reserved for future use.		        C*24   24
DBEGIN  ...  inital size of dsc_directory 		 	I*4     4
DFILLED ...  length of descriptor directory currently in use 	I*4     4
	     increases in chunks of 100 bytes
DSIZE   ...  no. of allocated elements in descr. directory,  
	     initialized to 1500 (= 15 entries of 100 bytes)	I*4     4
MAINSEG ...  Main Control Segment			    (5)	I*4    20
[0]          NOBYTE, no. of bytes per data value
[1]          FORMAT, format of data values:
	     see the different D_xx_FORMAT in midas_def.h
[2]          PIXPBL, no. of data values per page/block
[3]          STBLOK, no. of first block of data
[4]          LASTBLK, no. of last block of data
CREATE  ...  Creation time in ASCII				C*28   28
CRETIM  ...  Creation time in seconds (as long int)	    (2) I*4     8
RESERV3 ...  FCB space reserved for future use.		        C*272 272
FITSINFO ... FITS information  				    (2)	I*4     8
[0]          REFVAL, no. of pixels in original FITS file
[1]          OFFSET, offset of data in FITS file
NEXT    ...  Next Frame Control Block.				I*4     4
                                                                     -----
                                                                      512
*/
