/* @(#)file.c	16.1.1.1 (ES0-DMD) 06/19/01 15:12:19 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/* @(#)file.c	16.1.1.1 (ESO-ASD) 06/19/01 15:12:19 */
/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/* .COPYRIGHT   (C) 1993 European Southern Observatory     */
/* .IDENT       file.c                                     */
/* .AUTHORS     Cristian Levin   (ESO/La Silla)            */
/* .KEYWORDS    XIrspec                                    */
/* .PURPOSE                                                */
/* .VERSION     1.0  Package Creation  27-OCT-1993         */
/* ------------------------------------------------------- */

#include <stdio.h>
#include <gl_defs.h>
#include <irspec_defs.h>

void IrspecSave( file, obj, sky, ststar, stsky, dark, flat )
char *file;
char *obj, *sky, *ststar, *stsky, *dark, *flat;
{
    FILE *fp;
    int i;

    for ( i = 0; file[i] != '\0'; i++ )
	if ( file[i] == '.' ) {
	    file[i] = '\0';
	    break;
	}

    strcat(file, ".irs");

    if ( (fp = fopen(file, "w")) == NULL ) {
	SCTPUT("*** Error: file could not be opened ***");
	return;
    }
    fprintf(fp, "#\n# File generated by the Irspec graphical interface\n#\n");
    fprintf(fp, "object = %s\n", obj);
    fprintf(fp, "sky    = %s\n", sky);
    fprintf(fp, "ststar = %s\n", ststar);
    fprintf(fp, "stsky  = %s\n", stsky);
    fprintf(fp, "dark   = %s\n", dark);
    fprintf(fp, "flat   = %s\n", flat);

    fclose(fp);
}

void IrspecOpen( file )
char *file;
{
    FILE *fp;
    int i, j;
    char s[MAXLINE], str[MAXLINE], line[MAXLINE];
    char type[MAXLINE], name[MAXLINE];

    if ( (fp = fopen(file, "r")) == NULL ) {
	SCTPUT("*** Error: file could not be opened ***");
	return;
    }

    while ( fgets(s, MAXLINE, fp) != NULL ) {
	if ( s[0] == '#' )
	    continue;
	for ( i = 0, j = 0; s[i] != '\0'; i++ )
	    if ( s[i] == '=' ) {
	        line[j++] = ' ';
	        line[j++] = '=';
	        line[j++] = ' ';
	    }
	    else
	        line[j++] = s[i];
	line[j] = '\0';
	
	sscanf(line, "%s = %s", type, name);
	if ( ! strcmp(type, "object") )
	    strcpy(InObj, name);
	else if ( ! strcmp(type, "sky") )
	    strcpy(InSky, name);
	else if ( ! strcmp(type, "ststar") )
	    strcpy(InStstar, name);
	else if ( ! strcmp(type, "stsky") )
	    strcpy(InStsky, name);
	else if ( ! strcmp(type, "dark") )
	    strcpy(Dark, name);
	else if ( ! strcmp(type, "flat") )
	    strcpy(Flat, name);
	else {
	    sprintf(str, "*** line [%s] discarded ***", s);
	    SCTPUT(str);
	}
    }
    fclose(fp);
}
