/* @(#)t_error.c	16.1.1.1 (ESO-IPG) 06/19/01 15:08:30 */
/*---------------------------------------------------------------------
 * $Date: 93/07/12 18:31:36 $             $Revision: 2.2.6.1 $
 *---------------------------------------------------------------------
 * 
 *
 *             Copyright (c) 1992, Visual Edge Software Ltd.
 *
 * ALL  RIGHTS  RESERVED.  Permission  to  use,  copy,  modify,  and
 * distribute  this  software  and its documentation for any purpose
 * and  without  fee  is  hereby  granted,  provided  that the above
 * copyright  notice  appear  in  all  copies  and  that  both  that
 * copyright  notice and this permission notice appear in supporting
 * documentation,  and that  the name of Visual Edge Software not be
 * used  in advertising  or publicity  pertaining to distribution of
 * the software without specific, written prior permission. The year
 * included in the notice is the year of the creation of the work.
 *-------------------------------------------------------------------*/

#include "t_error.h"
#include "uimx_cat.h"
#include "lib_ds.h"
#define	CGETS(x,y)	UxCatGets(MC_LIBUIMX,(x),(y))
extern	char	*UxCopyString();

static	char	*Instances,*MallocFailed,*ReallocFailed,*Undefined;

void    UxErrorHandler(error,type,where)
int     error,type;
char    *where;
{
	switch(error){
	    case INSTANCES_EXCEEDED:
		 printf(Instances,where);
		 break;
	    case MALLOC_FAILED:
		 printf(MallocFailed,where);
		 break;
	    case REALLOC_FAILED:
		 printf(ReallocFailed,where);
		 break;
	    default:
		 printf(Undefined,where);
		 break;
	}
	if(type == FATAL)
	   exit(error);
}


UxInitErrorHandler()
{
	Instances = UxCopyString(CGETS(MS_LU_INSTEXCEEDED,DS_MS_LU_INSTEXCEEDED));
	MallocFailed = UxCopyString(CGETS(MS_LU_MALLOCFAILED,DS_MS_LU_MALLOCFAILED));
	ReallocFailed = UxCopyString(CGETS(MS_LU_REALLOCFAILED,DS_MS_LU_REALLOCFAILED));
	Undefined = UxCopyString(CGETS(MS_LU_UNDEFERROR,DS_MS_LU_UNDEFERROR));
}





