/**********************************************************************/
/*
/* $Date: 91/10/26 00:27:58 $
/* $Revision: 1.4.33.1 $
/*
/**********************************************************************/

/*****************************************************************************/
/***									   ***/
/***		 Copyright (c) 1988, Visual Edge Software Ltd.		   ***/
/***									   ***/
/***   All rights reserved.  This notice is  intended  as  a  precaution   ***/
/***   against	inadvertent publication, and shall not be deemed to con-   ***/
/***   stitute an acknowledgment that publication has  occurred	 nor  to   ***/
/***   imply  any  waiver  of confidentiality.	The year included in the   ***/
/***   notice is the year of the creation of the work.			   ***/
/***									   ***/
/*****************************************************************************/
#include <malloc.h>
#include <string.h>
#include <xtool.h>
#include <type_us.h>
#include <lista.h>
#include <widlist.h>
#include <midget.h>
#include <uimx_cat.h>
#include <lib_ds.h>
#define	CGETS(x,y)	UxCatGets(MC_LIBUIMX,(x),(y))

OHANDLE T_wid_list;

static OHANDLE InitWidList();


/*--------------------------------------------------------------------------
NAME:		OHANDLE UxWidListMake()
INPUT:		
RETURN:		OHANDLE 
DESCRIPTION:	Make an instance of the widget table
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/

OHANDLE UxWidListMake()
{
	OHANDLE oh;

	if(!is_type_defined(T_wid_list))
	   T_wid_list = type_register(sizeof(WID_LIST));
	oh = UxTypeAllocInstance(T_wid_list);
	return InitWidList(oh);
}
/*--------------------------------------------------------------------------
NAME:		OHANDLE InitWidList(oh)
INPUT:		OHANDLE
RETURN:		OHANDLE
DESCRIPTION:	given OHANDLE oh initialize it to widlist
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/

static OHANDLE InitWidList(oh)
OHANDLE oh;
{
	WID_LIST *l;
	OHANDLE   list;

	if(l = wid_list_lookup(oh)){
	   list = UxListaMake(sizeof(Wid));
	   wid_list_put_list(l,list);
	   wid_list_put_free(l,-1);
	}
	return oh;
}
/*--------------------------------------------------------------------------
NAME:		OHANDLE UxWidListPutEntry(wList, wid, mid)
INPUT:		OHANDLE wList, char *wid, OHANDLE mid
RETURN:		OHANDLE
DESCRIPTION:	Record the widget-swidget pointers pair in the widget table
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/

OHANDLE  UxWidListPutEntry(wList,wid,mid)
OHANDLE  wList;
char     *wid;
OHANDLE  mid;
{
	WidList  ent,new;
	Wid      p;
	OHANDLE  list;
	OHANDLE   *oh;

	if(!is_instance(wList))
	   wList = UxWidListMake();
	if(ent = UxWidListEntry(wList,wid)){
	   wid_put_mid(ent,(char *)type_lookup(mid,OHANDLE));
	   return wList;
	}
	else if(new = (WidList)UxWidGetEntry(wList)){
	   p.wid = wid;
	   p.mid = (char *)type_lookup(mid,OHANDLE);
	   *new = p;
	   return wList;
	}
	return UxNULL_OHANDLE;
}
/*--------------------------------------------------------------------------
NAME:		WidLlist UxWidGetEntry(wList)
INPUT:		OHANDLE wList
RETURN:		WidList
DESCRIPTION:	Get a pointer to an empty space in the widget table where
		to record a new widget-swidget pair
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/

WidList UxWidGetEntry(wList)
OHANDLE wList;
{
	OHANDLE   lista;
	WidList   list,rtrn = (WidList)0;
	WID_LIST *wl;
	int       free;

	if(wl = wid_list_lookup(wList)){
           lista = wid_list_list(wl);
	   if(wid_list_free(wl) < 0)
	     return (WidList)UxListaMakeEntry(lista);
	   else {
	      if(list = (WidList)UxListaList(lista)){
		rtrn = &list[wid_list_free(wl)];
		free = (int)list[wid_list_free(wl)].mid;
		wid_list_put_free(wl,free);
	      }
	   }
	}
	return rtrn;
}
/*--------------------------------------------------------------------------
NAME:		char *UxWidListGetMid(pList, wid)
INPUT:		OHANDLE pList, char *wid
RETURN:		pointer of swidget
DESCRIPTION:	Given a widget pointer get the swidget pointer
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/

char     *UxWidListGetMid(pList,wid)
OHANDLE  pList;
char     *wid;
{
	WidList        le;

	if(le = UxWidListEntry(pList,wid))
	   return (char *)wid_mid(le);
	return (char *)0;
}
/*--------------------------------------------------------------------------
NAME:		WidList UxWidListEntry(pList, wid)
INPUT:		OHANDLE pList, char *wid
RETURN:		WidList
DESCRIPTION:	Create an empty space in the widget table where to record
		a new widget-swidget pair
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/

WidList UxWidListEntry(pList,wid)
OHANDLE pList;
char    *wid;
{
	int     i;
	WidList list;
	OHANDLE  ohList;
	WID_LIST   *pl;

	if((i = UxWidListIndex(pList,wid)) >= 0)
	  if(pl = wid_list_lookup(pList)){
	     ohList = wid_list_list(pl);
	     if(list = (WidList)UxListaList(ohList))
		return &list[i];
	  }
	return (WidList)0;
}
/*--------------------------------------------------------------------------
NAME:		int UxWidListIndex(pList, wid)
INPUT:		OHANDLE pList, char *wid
RETURN:		integer index
DESCRIPTION:    Get the widget list index where the specified widget is 
		recorded
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/

int     UxWidListIndex(pList,wid)
OHANDLE pList;
char    *wid;
{
	int     i,end;
	WidList list;
	OHANDLE  ohList;
	WID_LIST   *pl;

	if(pl = wid_list_lookup(pList)){
	   ohList = wid_list_list(pl);
	   if(list = (WidList)UxListaList(ohList)){
	      end = UxListaEnd(ohList);
	      for(i = 0; i < end; i++)
		 if((long)list[i].wid == (long)wid)
		   return i;
	   }
	}
	return -1;
}
/*--------------------------------------------------------------------------
NAME:		inr UxWidListSize(pList)
INPUT:		OHANDLE pList
RETURN:		integer of widget list size
DESCRIPTION:	Get the size of the widget list
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/

int     UxWidListSize(pList)
OHANDLE pList;
{
	WID_LIST *pl;

	if(pl = wid_list_lookup(pList))
	   return UxListaEnd(wid_list_list(pl));
	return 0;
}
void    UxWidListDump(oh)
OHANDLE oh;
{
	WidList  list;
	int      i,end;
	WID_LIST   *o;
	char	*fmt;

	fmt = CGETS(MS_LU_WIDGETMIDGETFMT,DS_MS_LU_WIDGETMIDGETFMT);
	if(o = wid_list_lookup(oh))
	  if(list = (WidList)UxListaList(wid_list_list(o))){
	    end = UxListaEnd(wid_list_list(o));
	    for(i = 0; i < end; i++)
	       printf(fmt,(long)list[i].wid,(long)list[i].mid);
	  }
}
/*--------------------------------------------------------------------------
NAME:		Widlist UxWidListLookup(wList)
INPUT:		OHANDLE wList
RETURN:		WidList
DESCRIPTION:	Get the pointer to the beginning of the widget table
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/

WidList UxWidListLookup(wList)
OHANDLE wList;
{
	WID_LIST *wl;

	if(wl = wid_list_lookup(wList))
	   return (WidList)UxListaList(wid_list_list(wl));
	return (WidList)0;
}
/*--------------------------------------------------------------------------
NAME:		void UxWidListFree(oL)
INPUT:		OHANDLE oL
RETURN:		
DESCRIPTION:	free the spce occupied by the widget table
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/

void    UxWidListFree(oL)
OHANDLE oL;
{
	WID_LIST *wl;
	WidList   list;

	if(wl = wid_list_lookup(oL))
	   UxListaFree(wid_list_list(wl));
}
/*--------------------------------------------------------------------------
NAME:		void UxWidListFreeEntry(oL, wid)
INPUT:		OHANDLE oL, char *wid
RETURN:
DESCRIPTION:	Remove an entry from the widget table
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/

void    UxWidListFreeEntry(oL,wid)
OHANDLE oL;
char    *wid;
{
	int      free,i;
	WID_LIST *la;
	WidList  wl;
	OHANDLE  oh;

	if((i = UxWidListIndex(oL,wid)) >= 0 )
	  if(la = wid_list_lookup(oL)){
	     oh = wid_list_list(la);
	     if(wl = (WidList)UxListaList(oh)){
		wl[i].wid = (char *)0;
		wl[i].mid = (char *)lista_free(la);
		lista_put_free(la,i);
	     }
	  }
}

/*--------------------------------------------------------------------------
NAME:		OHANDLE UxWidListNameToSwidget(oh, name)
INPUT:		OHANDLE oh, char *name
RETURN:		OHANDLE
DESCRIPTION:	given the widget name return its corresponding swidget.
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/

OHANDLE  UxWidListNameToSwidget(oh,name)
OHANDLE oh;
char    *name;
{
	WidList  list;
	int      i,end;
	WID_LIST   *o;
	midget  *m;
	OHANDLE woh;

	if(o = wid_list_lookup(oh))
	  woh = wid_list_list(o);
	  if(list = (WidList)UxListaList(woh)){
	    end = UxListaEnd(woh);
	    for(i = 0; i < end; i++)
	       if(list[i].wid){
		 m = (midget *)list[i].mid;
		 if(!strcmp(name,midget_name(m)))
		     return midget_self(m);
	       }
	  }
	  return UxNULL_OHANDLE;
}


/*--------------------------------------------------------------------------
NAME:		OHANDLE UxWidListWindowToWidget(oh, win)
INPUT:		OHANDLE oh, Window win 
RETURN:		OHANDLE
DESCRIPTION:	Given the widget window return its corresponding widget.
CREATION:	Oct. 13  1989
REVISIONS:	--
--------------------------------------------------------------------------*/
Widget UxWidListWindowToWidget(oh, win)
OHANDLE oh;
Window win;
{
    WidList list;
    int i, end;
    WID_LIST *o;
    Widget w;
    OHANDLE woh;

    if(o = wid_list_lookup(oh))
	woh = wid_list_list(o);
        if(list = (WidList)UxListaList(woh)){
            end = UxListaEnd(woh);
            for(i = 0; i < end; i++)
                if(w = (Widget)list[i].wid){
		    if(XtWindow(w) == win)
			return w;
                }
        }
      
  return (Widget)0;
}

