/**********************************************************************/
/*
* $Date: 91/10/25 23:32:59 $
* $Revision: 1.7.33.1 $
*/
/**********************************************************************/

/*****************************************************************************/
/***									   ***/
/***		 Copyright (c) 1988, Visual Edge Software Ltd.		   ***/
/***									   ***/
/***   All rights reserved.  This notice is  intended  as  a  precaution   ***/
/***   against	inadvertent publication, and shall not be deemed to con-   ***/
/***   stitute an acknowledgment that publication has  occurred	 nor  to   ***/
/***   imply  any  waiver  of confidentiality.	The year included in the   ***/
/***   notice is the year of the creation of the work.			   ***/
/***									   ***/
/*****************************************************************************/
/* @(#)valloc.c	5.12 */

/* the general memory allocator for Visual Edge products;

   This file consists of routines that should be used in place of
   malloc calls.  It eventually calls malloc to get memory, but does
   some nifty error checking.  If the system malloc call returns a NULL
   pointer (out of memory), this will abort the program.

   The memory subsystem requires catalog 
   subssytem to work.  Please refer to the docs on the 
   catalog subsystem for info on how to link with them.

   The include file "valloc.h" should be included in all your
   application programs that uses UxMalloc et al.

----------------------------------------------------------------------------*/

#include <stdio.h>
#include <malloc.h>
#include <dialog.h>
#include <uimx_cat.h>
#include <valloc_ds.h>
#define	CGETS(x,y) UxCatGets(MC_VALLOC,(x),(y))

#include <varargs.h>
#define	NO_MEMORY	1

#ifdef SAFE_MALLOC
#define malloc(S) calloc((S),1)
#endif

extern	char	*UxCopyString();

static	char	*fmt;

/*****************************************************************************
NAME:		char *UxNoMemory(ptr, sz)
INPUT:		char	*ptr		- previous pointer when called from
					  UxRealloc
		unsigned sz		- number of bytes requested
RETURN: 	char *			- pointer to allocated space, or NULL
DESCRIPTION:	Repeatedly attempts to allocate space, requesting commands
		from the user at each step
CREATION:	4 July 1989
REVISIONS:	--
-----------------------------------------------------------------------------*/

char	*UxNoMemory(ptr, sz)
	char	 *ptr;
	unsigned sz;
{
	UxStandardError(fmt, (int)sz);
	abort();
	return(NULL);
}


/*****************************************************************************
NAME:		char *UxMalloc(sz)
DESCRIPTION:	Replaces malloc(), checks return value automatically.
CREATION:	4 July 1989
REVISIONS:	--
-----------------------------------------------------------------------------*/

char	*UxMalloc(sz)
	unsigned sz;
{
	char	 *rtrn;

	if (sz == 0)
		return NULL;

	rtrn = (char *) malloc(sz);
	if (rtrn == NULL)
		rtrn = UxNoMemory(NULL, sz);
	return(rtrn);
}

/*****************************************************************************
NAME:		char *UxCalloc(sz)
DESCRIPTION:	Replaces calloc(), checks return value automatically.
CREATION:	4 July 1989
REVISIONS:	--
-----------------------------------------------------------------------------*/

char 	*UxCalloc(n, sz)
	unsigned n, sz;
{
	char	 *rtrn;
	
	if ((sz == 0) || (n == 0))
	    	return NULL;

	rtrn = (char *) calloc(n, sz);

	if (rtrn == NULL)
		rtrn = UxNoMemory(NULL, n * sz);

	return(rtrn);
}

/*****************************************************************************
NAME:		char *UxRealloc(sz)
DESCRIPTION:	Replaces realloc(), checks return value automatically.
CREATION:	4 July 1989
REVISIONS:	--
-----------------------------------------------------------------------------*/

char 	*UxRealloc(ptr, sz)
	char 	 *ptr;
	unsigned sz;
{
	char	 *rtrn= ptr;
	
	if (sz == 0)
	    	return ptr;

	if (ptr)
		rtrn = (char *) realloc(ptr, sz); 
	else
		rtrn = (char *) malloc(sz);

	if (rtrn == NULL)
		rtrn = UxNoMemory(ptr, sz);

	return(rtrn);
}


/*---------------------------------------------------------------------------*/

void UxFree (p)
   char *p;
{
   if (p != (char *) 0) free (p);
}
/*****************************************************************************
NAME:		void UxInitMallocMsg()
INPUT:		None
CREATION:	22/08/90
REVISIONS:	--
-----------------------------------------------------------------------------*/
void	UxInitMallocMsg()
{
	fmt = UxCopyString(CGETS(MS_VL_ATMPTOALLCBYTES, DS_MS_VL_ATMPTOALLCBYTES));
}
