/**********************************************************************/
/*
/* $Date: 91/10/26 00:27:54 $
/* $Revision: 1.9.33.1 $
/*
/**********************************************************************/

/*****************************************************************************/
/***									   ***/
/***		 Copyright (c) 1988, Visual Edge Software Ltd.		   ***/
/***									   ***/
/***   All rights reserved.  This notice is  intended  as  a  precaution   ***/
/***   against	inadvertent publication, and shall not be deemed to con-   ***/
/***   stitute an acknowledgment that publication has  occurred	 nor  to   ***/
/***   imply  any  waiver  of confidentiality.	The year included in the   ***/
/***   notice is the year of the creation of the work.			   ***/
/***									   ***/
/*****************************************************************************/
#include <string.h>
#include <xtool.h>
#include <type_us.h>
#include <uxdd.h>
#include <utype.h>
#include <midget.h>
#include <types.h>
#include <uimx_cat.h>
#include <lib_ds.h>
#define	CGETS(x,y)	UxCatGets(MC_LIBUIMX,(x),(y))

#define  HASHSIZE	100
#define  NO_ERROR 0
#define  ERROR    -1

#define  NO_CONVERSION  1

OHANDLE T_DD;
OHANDLE T_CL;

DD	*DDTable[HASHSIZE];

static	int 	hash();
static DD	*DDTableLookup();
static DD 	*DDMake();
static CL_ENTRY *CLMake();


/*--------------------------------------------------------------------------
NAME:		DD*  *DDMake(name, ut, xt)
INPUT:		char* name, int ut, xt
RETURN:	       	return pointer to DD entry
DESCRIPTION:	given resources name and its uimxtype Xtype,  Make an DD entry
CREATION:	17 Nov. 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
static DD *DDMake(name,ut,xt)
char	*name;
int	ut,xt;
{
	OHANDLE oh;
        DD* dd;
	if(!is_type_defined(T_DD))
		T_DD= type_register(sizeof(DD));
	oh = UxTypeAllocInstance(T_DD);
	if(dd = dd_lookup(oh)){
		strcpy(dd->name,name);
		dd->utype= ut;
		dd->xtype= xt;
		dd->next_cl= (CL_ENTRY *)0;
		dd->next = (DD *)0;
	}
	return dd;
}
/*--------------------------------------------------------------------------
NAME:		CL_ENTRY  *CLMake(xtclass, ut, xt)
INPUT:		char* xtclass, int ut, xt
RETURN:	       	return pointer to CL entry
DESCRIPTION:	given xt class and its uimxtype Xtype,  Make an DD entry
CREATION:	17 Nov. 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
static CL_ENTRY *CLMake(xtclass,ut,xt)
char	*xtclass;
int	ut,xt;
{
	OHANDLE oh;
        CL_ENTRY* dd;

	if(!is_type_defined(T_CL))
		T_CL= type_register(sizeof(CL_ENTRY));
	oh = UxTypeAllocInstance(T_CL);
	if(dd = cl_lookup(oh)){
		dd->utype= ut;
		dd->xtype= xt;
		dd->next_cl= (CL_ENTRY *)0;
		dd->xtclass = xtclass;
	}
	return dd;
}


/*--------------------------------------------------------------------------
NAME:		void UxrDDInstall(name, utype, xtype)
INPUT:		char* name, int utype, xtype
RETURN:		
DESCRIPTION:    Given resource name and utype,xtype, link it to the hash table	
CREATION:	17, Nov, 1989 
REVISIONS:	--
--------------------------------------------------------------------------*/
void 	UxrDDInstall(name,utype,xtype)
char	*name;
int	utype;
int	xtype;
{
	DD	*np;
	int	hv;

	if(name)
		if(np = DDTableLookup(name)){
			printf(CGETS(MS_LU_ALDRYREGISTERED,
				DS_MS_LU_ALDRYREGISTERED),name);
			return;
		}
		else {
			np = DDMake(name,utype,xtype);
			hv = hash(name);	
			np->next = DDTable[hv];
			DDTable[hv] = np;
		}
}
/*--------------------------------------------------------------------------
NAME:		void UxrDDAddEntry(name,xtclass, utype, xtype)
INPUT:		char* name,*xtclass; int utype, xtype
RETURN:		
DESCRIPTION:    Given resource name and utype,xtype, link it to the hash table	
CREATION:	17, Nov, 1989 
REVISIONS:	--
--------------------------------------------------------------------------*/
void 	UxrDDAddEntry(name,xtclass,utype,xtype)
char	*name,*xtclass;
int	utype;
int	xtype;
{
	DD	*np;
	int	hv;
	CL_ENTRY *cl;

	if(name)
		if(np = DDTableLookup(name)){
			cl = CLMake(xtclass,utype,xtype);
			cl->next_cl= np->next_cl;
			np->next_cl=cl;
			return;
		}
		else {
			np = DDMake(name,utype,xtype);
			hv = hash(name);	
			np->next = DDTable[hv];
			DDTable[hv] = np;
		}
}


/*--------------------------------------------------------------------------
NAME:		static DD*  DDTableLookup(name) 
INPUT:		char* name
RETURN:	        pointer to DD Entry	
DESCRIPTION:	given  an resource name return its DD entry by checking  hash 
                index
CREATION:	17 Nov. 1989 
REVISIONS:	--
--------------------------------------------------------------------------*/
static 	DD *DDTableLookup(name)
char	*name;
{
	DD	*np;

	for(np = DDTable[hash(name)];np != (DD *)0;np = np->next)
		if(strcmp(name,np->name) == 0)
			return np;
	return (DD *)0;
}

/*--------------------------------------------------------------------------
NAME:		static int hash(name)
INPUT:		char* name
RETURN:	        hash table index (0-HASHSIZE)
DESCRIPTION:    given resource name to hash function get corresponding hash 
                index 
CREATION:	17  Nov 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
static 	int hash(name)
char	*name;
{
	int	hv;
	
	for(hv = 0; *name != '\0';)
		hv += *name++;
	return (hv % HASHSIZE);
}

/*-------------------------------------------------------------------------- 
NAME:		DDList UxrDDEntry(name)
INPUT:		char* name
RETURN:		DDList
DESCRIPTION:	given  an  name return its DDList
CREATION:	25 May 1989
REVISIONS:	10 April 1990
		-- Added class dependent dd entries.
--------------------------------------------------------------------------*/
CL_ENTRY *UxrDDEntry(name,xtclass)
char    *name;
char	*xtclass;
{
	CL_ENTRY *cl,*rcl=0;
	DD	 *dd;
	
	if(dd= DDTableLookup(name)){
		rcl = (CL_ENTRY *)dd;
	 	if(cl =dd->next_cl)
			do{
				if(cl->xtclass == xtclass){
					rcl = cl;
					break;
				}
			}while(cl=cl->next_cl);
	}
	return rcl;
}
/*--------------------------------------------------------------------------
NAME:		static int UimxToX(o,utype,v,xtype,data,to)
INPUT:		OHANDLE o;
		int	utype,xtype,to; 
		XtArgVal *v;
		char	 *data;
RETURN:		status:  ERROR	NO_ERROR	NO_CONVERSION
DESCRIPTION:	calls uimx convertors with the appropriate data types.
CREATION:	25 May 1989
--------------------------------------------------------------------------*/
static 	int UimxToX(o,utype,v,xtype,data,to)
OHANDLE o;
int	utype,xtype;
XtArgVal *v;
char	*data;
{
	char	vc;
	short	vs;
	int	stat= ERROR;

	switch(u_size(utype)){
	   case sizeof(char):
		if(to == TO_X)vc = (char)*v;
	       	stat =UxUimx_to_x(o,utype,&vc,xtype,data,to);
		if(to == TO_UIMX)*v = (XtArgVal)vc;
		break;
	   case sizeof(short):
		if(to == TO_X)vs = (short)*v;
	       	stat =UxUimx_to_x(o,utype,&vs, xtype,data,to);
		if(to == TO_UIMX)*v = (XtArgVal)vs;
		break;
	   default:
	       	stat = UxUimx_to_x(o,utype,v,xtype,data,to);
	}
	return stat;
}
/*--------------------------------------------------------------------------
NAME:		int UxrDDPutProp(o,p,v)
INPUT:		OHANDLE o, char *p, XtArgVal v
RETURN:
DESCRIPTION:	given swidget put its property pair (p, v) to proplist
CREATION:	25 May 1989
REVISIONS:	10 April 1990
		-- modified to handle class dependent dd entries.
--------------------------------------------------------------------------*/
int  	UxrDDPutProp(o,p,v)
OHANDLE   o;
char      *p;
XtArgVal  v;
{
	CL_ENTRY *dd;
	XtArgVal fi = v;
	char     fc = '\0',vc;
	int      stat = NO_ERROR;
	short	 fs =0,vs;

	if(is_instance_defined(o))
	    if(dd = UxrDDEntry(p,UxMidgetWClass(o))){
		switch(x_size(dd->xtype)){
			case sizeof(char):
			   stat= UimxToX(o,dd->utype,&v,dd->xtype,&fc,TO_X);
			   fi = (XtArgVal)fc;
			break;	
			case sizeof(short):
			   stat= UimxToX(o,dd->utype,&v,dd->xtype,&fs,TO_X);
			   fi = (XtArgVal)fs;
			break;
	      		default:
			   stat= UimxToX(o,dd->utype,&v,dd->xtype,&fi,TO_X);
	     	}
		if(stat == NO_ERROR)
			stat= UxrPutProp(o,p,fi);
	 	else if(stat == NO_CONVERSION)
	      		stat =UxrPutProp(o,p,v); 
            }
	return  stat;
}
/*--------------------------------------------------------------------------
NAME:		XtArgVal UxrDDGetProp(o,p)
INPUT:		OHANDLE o, char *p
RETURN:		XtArgVal
DESCRIPTION:	given swidget return its property p value 
CREATION:	25 May 1989
REVISIONS:      Oct. 1989	
                checking widget is created or not. 
		10 April 1990
		-- modified to handle class dependent dd entries.
---------------------------------------------------------------------------*/
XtArgVal UxrDDGetProp(o,p)
OHANDLE  o;
char     *p;
{
	CL_ENTRY *dd;
	XtArgVal v= 0;
	char	fc = '\0',vc;
	Arg	arg[2];
	short	fs,vs;
	int	stat;

	if(is_instance_defined(o) && UxMidgetWidget(o) && 
	  				(dd = UxrDDEntry(p,UxMidgetWClass(o)))){ 
		switch(x_size(dd->xtype)){
			case sizeof(char):
                 	    XtSetArg(arg[0],p,&fc);
		 	    XtGetValues(UxMidgetWidget(o),arg,1);
			    if(NO_ERROR==(stat=UimxToX(o,dd->utype,&v,
						dd->xtype,&fc,TO_UIMX)))
				return v;
			    else if(stat == NO_CONVERSION)
				return (XtArgVal)fc;
			break;
			case sizeof(short):
			    XtSetArg(arg[0],p,&fs);
			    XtGetValues(UxMidgetWidget(o),arg,1);
			    if(NO_ERROR==(stat=UimxToX(o,dd->utype,&v,
						dd->xtype,&fs,TO_UIMX)))
				return v;
			    else if(stat == NO_CONVERSION)
				return (XtArgVal)fs;
			break;
			default:
	         	    v = UxrGetProp(o,p);
	         	    if(NO_ERROR==(stat=UimxToX(o,dd->utype,&v,
						dd->xtype,&v,TO_UIMX)))
			    	return (XtArgVal)v;
			    else if(stat == NO_CONVERSION)
				return v;
		}
	  }
	  return UxrGetProp(o,p);
}
