/**********************************************************************/
/*
/* $Date: 91/11/19 12:27:51 $
/* $Revision: 1.42.33.2 $
/*
/**********************************************************************/

/****************************************************************************/
/***									   ***/
/***		 Copyright (c) 1988, Visual Edge Software Ltd.		   ***/
/***									   ***/
/***   All rights reserved.  This notice is  intended  as  a  precaution   ***/
/***   against	inadvertent publication, and shall not be deemed to con-   ***/
/***   stitute an acknowledgment that publication has  occurred	 nor  to   ***/
/***   imply  any  waiver  of confidentiality.	The year included in the   ***/
/***   notice is the year of the creation of the work.			   ***/
/***									   ***/
/*****************************************************************************/
#include <string.h>
#include <stdio.h>
#include <xtool.h>
#ifdef OL_WIDGETS
#include <Xol/BaseWindow.h>
#include <Xol/Notice.h>
#include <Xol/PopupWindo.h>
#endif	/* OL_WIDGETS */
#ifdef MOTIF_WIDGETS
#ifdef vms 
#include <decw$include/IntrinsicP.h>
#else
#include <X11/IntrinsicP.h>
#endif
#ifdef vms 
#include <decw$include/RectObjP.h>
#else
#include <X11/RectObjP.h>
#endif
#include <Xm/DialogS.h>
#endif  /* MOTIF_WIDGETS */

#ifdef OL_WIDGETS
#include <type_us.h>
#include <utype.h>
#include <midget.h>
#include <types.h>
#include <table.h>
#endif /* OL_WIDGETS */

#include <uimx.h>
#include <global.h>
#include <dstring.h>
#ifdef vms 
#include <decw$include/ShellP.h>
#else
#include <X11/ShellP.h>
#endif
#include <uimx_cat.h>
#include <lib_ds.h>
#define CGETS(x,y)      UxCatGets(MC_LIBUIMX,(x),(y))
extern	char	*UxCopyString();
  
Widget	UxTopLevel;	
XEvent   *UxCurrentEvent;
XtAppContext UxAppContext;
Display	*UxDisplay;
int	UxScreen;
Window	UxRootWindow;
char	*UxWindowManager;
char	*UxDefaultShellType;
char	*UxUserShell;
char	*UxFirstEditorShell;
char    *UxThisWidget;
GC       UxDrawGC;
GC  	UxUimxBlackGC;

int     UxNotifyFlag = 0;

static  OHANDLE WidgetTable = {-1,0};

static   void    RecordWidget();
static   void    GC_init();

/*-----------------------------------------------------------------------------
NAME:		void		UxrDelayUpdate(sw)
INPUT:		swidget		sw		
DESCRIPTION:	Set swidget update flag to false so that when resources
		are set update of the widget in swidget is delayed until
		UxUpdate is executed
CREATION:	14 Mar 89	run-time version
-----------------------------------------------------------------------------*/

void    UxrDelayUpdate(oM)
swidget oM;
{
	UxPutUpdateFlag(oM,0);
}

/*-----------------------------------------------------------------------------
NAME:		void		UxrUpdate(sw)
INPUT:		swidget		sw		
DESCRIPTION:	Udate the widget in swidget and set the swidget update flag
		to true.
REVISIONS:	14 Mar 89	run-time version
-----------------------------------------------------------------------------*/

void    UxrUpdate(oM)
swidget oM;
{
	ArgList al;
	Widget  w;
	int     sz;

	if(w = UxGetWidget(oM)){
	   al = UxGetArgList(oM);
	   sz = UxGetArgListSize(oM);
	   UxPutUpdateFlag(oM,1);
	   XtSetValues(w,al,sz);
	   UxMidgetFreeArgList(oM);
	}
}

/*-----------------------------------------------------------------------------
NAME:		int		UxrPutProp(sw,name,value)
INPUT:		swidget		sw		
		char            *name
		XtArgVal	value
DESCRIPTION:	Given a swidget build an argument list of resource name-value
		pairs. 
REVISIONS:	14 Mar 89	run-time version
		29 Jul 91       fix2823
-----------------------------------------------------------------------------*/

int  	UxrPutProp(oM,prop,val)
swidget oM;
String  prop;
XtArgVal val;
{
	Arg 	arg[2];
	Widget  w;
	if(is_instance_defined(oM)){
	   if(UxGetUpdateFlag(oM) && (w = UxGetWidget(oM))){
	      XtSetArg(arg[0],prop,val);
	      XtSetValues(w,arg,1);
	   }
	   else {
	   	UxObjectPutProp(oM,prop,(HANDLE)val);
	   }
	   return NO_ERROR;
	}
	return ERROR;
}

/*-----------------------------------------------------------------------------
NAME:		void		UxrGetProp(sw,name)
INPUT:		swidget		sw		
		char            *name
DESCRIPTION:	Get the value of the named resource associated with the 
		specified swidget.
REVISIONS:	14 Mar 89	run-time version
-----------------------------------------------------------------------------*/

XtArgVal UxrGetProp(oM,prop)
swidget  oM;
String   prop;
{
	Arg arg[2];
	Widget w;
	XtArgVal  val=0;

	if(is_instance_defined(oM)){
	   XtSetArg(arg[0],prop,&val);	
	   if(w = UxGetWidget(oM)){
	      XtGetValues(w,arg,1);
	      return ((XtArgVal)val);
	   }
	   else
	      return (XtArgVal)UxObjectGetProp(oM,prop);
	}
	return ((XtArgVal)(0));
}

/*-----------------------------------------------------------------------------
NAME:		void		UxrShortGetProp(sw,name)
INPUT:		swidget		sw		
		char            *name
DESCRIPTION:	Get the value of the named resource associated with the 
		specified swidget.
CREATION:	14 Feb 90	run-time version
-----------------------------------------------------------------------------*/
#ifdef MOTIF_WIDGETS

short 	UxrShortGetProp(oM,prop)
swidget  oM;
String   prop;
{
	Arg arg[2];
	Widget w;
	short  val=0;

	if(is_instance_defined(oM)){
	   XtSetArg(arg[0],prop,&val);	
	   if(w = UxGetWidget(oM)){
	      XtGetValues(w,arg,1);
	      return (val);
	   }
	   else
	      return (short)UxObjectGetProp(oM,prop);
	}
	return ((short)(0));
}
#endif	/* MOTIF_WIDGETS */

/*-----------------------------------------------------------------------------
NAME:		void		UxrCharGetProp(sw,name)
INPUT:		swidget		sw		
		char            *name
DESCRIPTION:	Get the value of the named resource associated with the 
		specified swidget.
CREATION:	14 Feb 90	run-time version
-----------------------------------------------------------------------------*/
#ifdef MOTIF_WIDGETS

char 	UxrCharGetProp(oM,prop)
swidget  oM;
String   prop;
{
	Arg arg[2];
	Widget w;
	char  val=0;

	if(is_instance_defined(oM)){
	   XtSetArg(arg[0],prop,&val);	
	   if(w = UxGetWidget(oM)){
	      XtGetValues(w,arg,1);
	      return ((XtArgVal)val);
	   }
	   else
	      return (char)UxObjectGetProp(oM,prop);
	}
	return ((char)(0));
}
#endif	/* MOTIF_WIDGETS */


/*-----------------------------------------------------------------------------
NAME:		String	UxrGetStringProp (oM, name)
INPUT:		swidget	oM			: swidget to get resource from
		char	*name			: name of resource
DESCRIPTION:	Get the value of the named resource (of xctype String)
		associated with the specified swidget.
CREATION:	Mar 23/90
-----------------------------------------------------------------------------*/
#ifdef OL_WIDGETS

String	UxrGetStringProp (oM, prop)
	swidget	oM;
	String	prop;
{
	Widget	w;

	if ( ! is_instance_defined (oM))
		return (NULL);

	if ((w = UxGetWidget (oM)) != NULL) {
		Arg		arg[1];
		String		val = NULL;

		XtSetArg (arg[0], prop, &val);	
		XtGetValues (w, arg, 1);
		return (val);
	}
	else
		return ((String) UxObjectGetProp (oM, prop));
}
#endif	/* OL_WIDGETS */

/*-----------------------------------------------------------------------------
NAME:		int	UxrGetIntProp (oM, name)
INPUT:		swidget	oM			: swidget to get resource from
		char	*name			: name of resource
DESCRIPTION:	Get the value of the named resource (of xctype int)
		associated with the specified swidget.
CREATION:	Mar 23/90
-----------------------------------------------------------------------------*/
#ifdef OL_WIDGETS

int	UxrGetIntProp (oM, prop)
	swidget	oM;
	String	prop;
{
	Widget	w;

	if ( ! is_instance_defined (oM))
		return (0);

	if ((w = UxGetWidget (oM)) != NULL) {
		Arg		arg[1];
		int		val = 0;

		XtSetArg (arg[0], prop, &val);	
		XtGetValues (w, arg, 1);
		return (val);
	}
	else
		return ((int) UxObjectGetProp (oM, prop));
}
#endif	/* OL_WIDGETS */

/*-----------------------------------------------------------------------------
NAME:		Position	UxrGetPositionProp (oM, name)
INPUT:		swidget	oM			: swidget to get resource from
		char	*name			: name of resource
DESCRIPTION:	Get the value of the named resource (of xctype Position)
		associated with the specified swidget.
CREATION:	Mar 23/90
-----------------------------------------------------------------------------*/
#ifdef OL_WIDGETS

Position	UxrGetPositionProp (oM, prop)
	swidget	oM;
	String	prop;
{
	Widget	w;

	if ( ! is_instance_defined (oM))
		return (0);

	if ((w = UxGetWidget (oM)) != NULL) {
		Arg		arg[1];
		Position	val = 0;

		XtSetArg (arg[0], prop, &val);	
		XtGetValues (w, arg, 1);
		return (val);
	}
	else
		return ((Position) UxObjectGetProp (oM, prop));
}
#endif	/* OL_WIDGETS */

/*-----------------------------------------------------------------------------
NAME:		Dimension	UxrGetDimensionProp (oM, name)
INPUT:		swidget	oM			: swidget to get resource from
		char	*name			: name of resource
DESCRIPTION:	Get the value of the named resource (of xctype Dimension)
		associated with the specified swidget.
CREATION:	Mar 23/90
-----------------------------------------------------------------------------*/
#ifdef OL_WIDGETS

Dimension	UxrGetDimensionProp (oM, prop)
	swidget	oM;
	String	prop;
{
	Widget	w;

	if ( ! is_instance_defined (oM))
		return (0);

	if ((w = UxGetWidget (oM)) != NULL) {
		Arg		arg[1];
		Dimension	val = 0;

		XtSetArg (arg[0], prop, &val);	
		XtGetValues (w, arg, 1);
		return (val);
	}
	else
		return ((Dimension) UxObjectGetProp (oM, prop));
}
#endif	/* OL_WIDGETS */

/*-----------------------------------------------------------------------------
NAME:		OlTextPosition	UxrGetOlTextPositionProp (oM, name)
INPUT:		swidget	oM			: swidget to get resource from
		char	*name			: name of resource
DESCRIPTION:	Get the value of the named resource (of xctype Dimension)
		associated with the specified swidget.
CREATION:	Mar 23/90
-----------------------------------------------------------------------------*/

#ifdef OL_WIDGETS

OlTextPosition	UxrGetOlTextPositionProp (oM, prop)
	swidget	oM;
	String	prop;
{
	Widget	w;

	if ( ! is_instance_defined (oM))
		return (0);

	if ((w = UxGetWidget (oM)) != NULL) {
		Arg		arg[1];
		OlTextPosition	val = 0;

		XtSetArg (arg[0], prop, &val);	
		XtGetValues (w, arg, 1);
		return (val);
	}
	else
		return ((OlTextPosition) UxObjectGetProp (oM, prop));
}
#endif /* OL_WIDGETS */

/*--------------------------------------------------------------------------
NAME:		void UxrFreeSwidget(sw)
INPUT:		swidget sw
RETURN:
DESCRIPTION:	free the specified swidget
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/

void UxrFreeSwidget(sw)
swidget sw;
{
	UxMidgetFree(sw);
}

/*-----------------------------------------------------------------------------
NAME:		int UxrIsOverrideShell(sw)
INPUT:		swidget sw
RETURN:		integer (1 or 0)
DESCRIPTION:	check if the given widgetclass is shellwidgetclass
CREATION:
REVISIONS:	Aug/1/90 	(see bug866)	
-----------------------------------------------------------------------------*/
int  	UxrIsOverrideShell(sw)
swidget sw;
{
	WidgetClass class;

	if(class = UxGetClass(sw))
		return  (class == overrideShellWidgetClass);
	return 0;
}

/*-----------------------------------------------------------------------------
NAME:		int UxrIsShellClass(class)
INPUT:		WidgetClass class
RETURN:		integer (1 or 0)
DESCRIPTION:	check if the given widgetclass is shellwidgetclass
CREATION:
REVISIONS:	14 Mar 89	run-time version
                29 Aug 90	OLE MERGE
		-- separator motif and ol  
-----------------------------------------------------------------------------*/

int     UxrIsShellClass(class)
WidgetClass    class;
{
#ifdef MOTIF_WIDGETS

	if(((long)class == (long)topLevelShellWidgetClass) ||
	   ((long)class == (long)transientShellWidgetClass) ||
	   ((long)class == (long)overrideShellWidgetClass) ||
	   ((long)class == (long)applicationShellWidgetClass) ||
	   ((long)class == (long)xmDialogShellWidgetClass))
	   return 1;
	return 0;

#endif /* MOTIF_WIDGETS */

#ifdef OL_WIDGETS
	return ((class == baseWindowShellWidgetClass) ||
		(class == transientShellWidgetClass) ||
		(class == overrideShellWidgetClass) ||   
		(class == noticeShellWidgetClass) ||
		(class == popupWindowShellWidgetClass));
#endif /* OL_WIDGETS */
}

#ifdef OL_WIDGETS
#include <uimxOL.c>
#endif	/* OL_WIDGETS */

#ifdef MOTIF_WIDGETS
#include <uimxMF.c>
#endif	/* MOTIF_WIDGETS */

/*-----------------------------------------------------------------------------
NAME:		void RecordWidget(w,m)
INPUT:		Widget w, swidget m
RETURN:
DESCRIPTION:	record widget swidget pair to widget table
CREATION:
REVISIONS:	14 Mar 89	run-time version
-----------------------------------------------------------------------------*/

static void    RecordWidget(w,m)
Widget   w;
swidget  m;
{
	if(!is_instance_defined(WidgetTable))
	   WidgetTable = UxWidListMake();

	UxWidListPutEntry(WidgetTable,w,m);
}

/*-----------------------------------------------------------------------------
NAME:		swidget UxrWidgetToSwidget(w)
INPUT:		Widget w
RETURN:		swidget
DESCRIPTION:	given object Widget return it's corresponding swidget
REVISIONS:	14 Mar 89	run-time version
-----------------------------------------------------------------------------*/

swidget UxrWidgetToSwidget(w)
Widget  w;
{
	swidget *swp,sw;

	sw= UxNULL_OHANDLE;
	if(swp = (swidget *)UxWidListGetMid(WidgetTable,w))
	   sw = *swp;
	return sw;
}
/*-----------------------------------------------------------------------------
NAME:		int UxrIsValidSwidget(m)
INPUT:		swidget
RETURN:         integer (1 or 0)
DESCRIPTION:    given swidget check if it is defined or not.
REVISIONS:	14 Mar 89	run-time version
-----------------------------------------------------------------------------*/

int     UxrIsValidSwidget(m)
swidget  m;
{
	return is_instance_defined(m);
}

/*-----------------------------------------------------------------------------
NAME:		void UxrAddCallback(m,name, callback, context)
INPUT:		swidget m, char *name, XtCallbackProc callback, char *context
RETURN:
DESCRIPTION:	given swidget add callback context to it.
REVISIONS:	14 Mar 89	run-time version
-----------------------------------------------------------------------------*/

void UxrAddCallback(m,name,callback,context)
swidget m;
char    *name;
XtCallbackProc callback;
char    *context;
{
	Widget  w;

	if(w = UxGetWidget(m))
		XtAddCallback(w,name,callback,(caddr_t)context);
}

/*-----------------------------------------------------------------------------
NAME:		void UxrMainLoop()
INPUT:
RETURN:
DESCRIPTION:	call XtmainLoop
REVISIONS:	14 Mar 89	run-time version
		25 Aug 89       call Events routines
-----------------------------------------------------------------------------*/
void UxrMainLoop()
{
    /* 	XtMainLoop(); */
	XEvent		event;

	for (;;) {
		UxrNextEvent(&event);
		UxrDispatchEvent(&event);
                
	}
}

/*--------------------------------------------------------------------------
NAME:		UxrNextEvent()
INPUT:		
RETURN:
DESCRIPTION:	get NextEvent 
CREATION:	Aug. 25, 1989	
REVISIONS:	Jul 29/1990
		      - removed call to UxrCheckContext
--------------------------------------------------------------------------*/
void	UxrNextEvent(event)
	XEvent	*event;
{
	XtAppNextEvent(UxAppContext, event);
}

/*--------------------------------------------------------------------------
NAME:		Void UxrDispatchEvent(event)
INPUT:		
RETURN:
DESCRIPTION:    call XtDispatchEvent	
CREATION:	Aug. 25 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void	UxrDispatchEvent(event)
	XEvent	*event;
{
	XtDispatchEvent(event);
}

/******************************************************************************
 ==== LOCAL ==================================================================
*******************************************************************************
NAME:		void		destroySwidgetsCallback(wid)

INPUT:		Widget		wid		- widget to destroy

DESCRIPTION:	Find the swidget for 'wid' and destroy all the libuimx data
		structures.  This is called as a callback from the top
		widget to be deleted in a tree.

CREATION:	Jul 29/1990
REVISIONS:	--
-----------------------------------------------------------------------------*/

static void destroySwidgetsCallback(wid)
	Widget		wid;
{
	swidget		curr;

	curr= UxWidgetToSwidget(wid);

	UxrDestroySwidgetTree(curr);
}
	
/******************************************************************************
 ==== LOCAL ==================================================================
*******************************************************************************
NAME:		void		destroyContextCallback(wid, con)

INPUT:		Widget		wid		- widget for callback
		char		*con		- context pointer

DESCRIPTION:	Destroy the swidgets and free the context structure.  This
		function is registered as a destroy callback from
		UxrDestroyInterface.

CREATION:	Jul 29/1990
REVISIONS:	--
-----------------------------------------------------------------------------*/

static void destroyContextCallback(wid, con)
	Widget		wid;
	char		*con;
{
	destroySwidgetsCallback(wid);
	UxFree(con);
}

/*-----------------------------------------------------------------------------
NAME:		void		UxrDestroyInterface(sw)
INPUT:		swidget		sw		
DESCRIPTION:	Destroys the interface.
CREATION:	20 Dec 88
REVISIONS:	14 Mar 89	run-time version
		25 Aug 89	change call free() to 
						UxrSaveContestToFree()
		Jul 29/1990
		      - register destroy handler to destroy the swidgets and
			context structure then destroy the widgets.
-----------------------------------------------------------------------------*/

int 	UxrDestroyInterface(sw)
	swidget		sw;
{
	Widget		w;

	w= UxGetWidget(sw);

	if(w == NULL)
		return(ERROR);
#ifdef MOTIF_WIDGETS
	XtAddCallback(w, XmNdestroyCallback, destroyContextCallback,
		UxGetContext(sw));
#endif /* MOTIF_WIDGETS */
#ifdef OL_WIDGETS
	XtAddCallback(w, XtNdestroyCallback, destroyContextCallback,
		UxGetContext(sw));
#endif /* OL_WIDGETS */

	XtDestroyWidget(UxrRealWidget(sw));

	return NO_ERROR;
}

/* ---------------------------------------------------------------------------
NAME:		UxrDestroySwidget(sw)
INPUT:		swidget 	sw;
RETURN:
DESCRIPTION:	Destroys an swidget.
CREATION:	14 Mar 89	
                16 Nov 89       added XtDestroyWidget (at top level)
		Jul 29/1990
		      - register destroy handler to destroy the swidgets then
			destroy the widgets.
---------------------------------------------------------------------------*/
void	UxrDestroySwidget(sw)
	swidget 	sw;
{
	Widget		w;

	w= UxGetWidget(sw);

	if(w == NULL)
		return;
#ifdef MOTIF_WIDGETS
	XtAddCallback(w, XmNdestroyCallback, destroySwidgetsCallback, NULL);
#endif /* MOTIF_WIDGETS */
#ifdef OL_WIDGETS
	XtAddCallback(w, XtNdestroyCallback, destroySwidgetsCallback, NULL);
#endif /* OL_WIDGETS */

	XtDestroyWidget(UxrRealWidget(sw));
}

/* ---------------------------------------------------------------------------
NAME:		void		UxrRealizeInterface(sw)
INPUT:		swidget		sw		
RETURN:
DESCRIPTION:	Realizes the interface.
CREATION:	Dec 20/1988
REVISIONS:	14 Mar 89	run-time version
-----------------------------------------------------------------------------*/
int UxrRealizeInterface(sw)
	swidget	sw;
{
	Widget	w;

	if (w = UxrRealWidget(sw)){
            XtRealizeWidget(w);
	    return NO_ERROR; 
	}
	return ERROR;
}

#ifdef MOTIF_WIDGETS
/*-----------------------------------------------------------------------------
NAME:		handle_dialog_child(wgt, manage_func)
INPUT:		Widget		wgt		- the dialogShell widget
		void	(*manage_func)()	- either XtManageChild
						  or XtUnmanageChild
RETURN:		int				- NO_ERROR if successful
						  ERROR otherwise
DESCRIPTION:	Handles the popping up or popping down of dialog shells
		by managing or unmanaging their children.
REVISIONS:	Oct 8/91	fix3035
-----------------------------------------------------------------------------*/

static	int	handle_dialog_child(wgt, manage_func)
	Widget	wgt;
	void	(*manage_func)();
{
	int	i, num_children;
	Widget	*children;

	XtVaGetValues( wgt,
		       XmNnumChildren, &num_children,
		       XmNchildren, &children,
		       NULL );

	/* We manage/unmanage the first rectObj child in the list.
	 * Note that the check for rectObjClass is necessary since some
	 * implementations of Motif add protocol children to the dialogShell.
	 */

	for (i = 0; i < num_children; i++)
	{
		if ( XtIsSubclass( children[i], rectObjClass ) )
		{
			(*manage_func)(children[i]);
			return ( NO_ERROR );
		}
	}

	return ( ERROR );
}
#endif /* MOTIF_WIDGETS */

#ifdef MOTIF_WIDGETS
/*-----------------------------------------------------------------------------
NAME:		popup_dialog(wgt, grab_flag)
INPUT:		Widget		wgt		- dialogShell to pop up
		XtGrabKind	grab_flag	- the grab flag
RETURN:		void
DESCRIPTION:	Pops up the dialogShell.
-----------------------------------------------------------------------------*/

static	void	popup_dialog(wgt, grab_flag)
	Widget		wgt;
	XtGrabKind	grab_flag;
{
	if (handle_dialog_child(wgt, XtManageChild) == ERROR)
		XtPopup(wgt, grab_flag);
}
#endif /* MOTIF_WIDGETS */

/*-----------------------------------------------------------------------------
NAME:		static void		DealWithWindowGroup(sw)
INPUT:		swidget	  	sw		- swidget to popup
RETURN:		void
DESCRIPTION:	Set the window group if the window group flag is set.
CREATION:	Aug/1 /1990    (see bug866)
REVISIONS:	
-----------------------------------------------------------------------------*/
static void DealWithWindowGroup(sw)
swidget sw;
{
	Widget	w= UxMidgetWidget(sw);

	if(w && UxrIsShellClass(UxGetClass(sw)) &&   /* if explicit shell */
	   !UxrIsOverrideShell(sw) &&		/* and not override shell */
	   UxMidgetGetWinGroupFlag(sw)){ 	/* and window group flag set*/
		if(!XtIsRealized(w))
			XtRealizeWidget(w);
		UxPutWindowGroup(sw,UxGetName(sw));
	}
}

/*-----------------------------------------------------------------------------
NAME:		int		UxrPopupInterface(sw, type)
INPUT:		swidget	  	sw		- swidget to popup
		grabtype	type		- grab type
RETURN:		ERROR/NO_ERROR
DESCRIPTION:	If the swidget is a shell then call a Popup function using 
		the proper grab type. 
CREATION:	Dec 19/1988
REVISIONS:	March 14/1989
		Aug 1/90  (see bug866)
		-- deal with window groups
		Oct 8/91	fix3035 - use of popup_dialog()
-----------------------------------------------------------------------------*/

int 	UxrPopupInterface(sw, type)
	swidget		sw;
	grabtype	type;
{
	Widget	w = UxrRealWidget(sw);

	if (w != NULL && XtIsSubclass(w, shellWidgetClass)) {

		XtGrabKind	xt_grab;

		/* deal with window group */
		DealWithWindowGroup(sw);

		switch (type) {
		    case nonexclusive_grab:
			xt_grab = XtGrabNonexclusive;
			break;
		    case exclusive_grab:
			xt_grab = XtGrabExclusive;
			break;
		    default:
			xt_grab = XtGrabNone;
			break;
		}

#ifdef MOTIF_WIDGETS
		if (XtIsSubclass(w, xmDialogShellWidgetClass))
			popup_dialog(w, xt_grab);
		else
#endif /* MOTIF_WIDGETS */
			XtPopup(w, xt_grab);

		return NO_ERROR;
	}
	return(ERROR);
}

#ifdef MOTIF_WIDGETS
/*-----------------------------------------------------------------------------
NAME:		popdown_dialog(wgt)
INPUT:		Widget		wgt		- dialogShell to pop down
RETURN:		void
DESCRIPTION:	Pops down the dialogShell.
-----------------------------------------------------------------------------*/

static	void	popdown_dialog(wgt)
	Widget		wgt;
{
	if (handle_dialog_child(wgt, XtUnmanageChild) == ERROR)
		XtPopdown(wgt);
}
#endif /* MOTIF_WIDGETS */

/*-----------------------------------------------------------------------------
NAME:		int		UxrPopdownInterface(sw)
INPUT:		swidget	  	sw		- swidget to popdown
RETURN:		ERROR/NO_ERROR
DESCRIPTION:	If the swidget is a shell then call a popdown function.
CREATION:	Dec 19/1988
REVISIONS:	Mar 14/1989
		Oct 8/91	fix3035	- use of popdown_dialog()
-----------------------------------------------------------------------------*/

int UxrPopdownInterface(sw)
	swidget	sw;
{
	Widget	w = UxrRealWidget(sw);

	if (w != NULL && XtIsSubclass(w, shellWidgetClass)) {
#ifdef MOTIF_WIDGETS
		if (XtIsSubclass(w, xmDialogShellWidgetClass))
			popdown_dialog(w);
		else
#endif /* MOTIF_WIDGETS */
			XtPopdown(w);
		return NO_ERROR;
	}
	return(ERROR);
}

/*-----------------------------------------------------------------------------
NAME:		void UxrUnmap(sw)
INPUT:		swidget sw
RETURN:
DESCRIPTION:	Unmap the swidget
CREATION:
REVISIONS:	14 Mar 89	run-time version
		24 July 90   (see bug802)
		-- unmap widgets that are subclass of windowObjClass
-----------------------------------------------------------------------------*/

void 	UxrUnmap(sw)
     	swidget sw;
{
	Widget	w;

  	if (w = UxrRealWidget(sw)) 
	{
		if (XtIsSubclass(w, shellWidgetClass)){
      			XtPopdown(w);
		}
		/* unmap if widget is subclass of windowObjClass */
		else if(XtIsSubclass(w, widgetClass)){
			XtUnmapWidget(w);
		}
    		else {
      			XtUnmanageChild(w);
		}
  	}
}
/*--------------------------------------------------------------------------
NAME:		void UxrMap(sw)
INPUT:		swidget sw
RETURN:
DESCRIPTION:	map swidget
CREATION:	25 May 1989
REVISIONS:	24 July 90   (see bug802)
		-- map widgets that are subclass of windowObjClass
--------------------------------------------------------------------------*/
void 	UxrMap(sw)
     	swidget sw;
{
	Widget	w;

  	if (w = UxrRealWidget(sw)) 
	{
		if (XtIsSubclass(w, shellWidgetClass)){
      			XtPopup(w, XtGrabNone);
		}
		/* map if widget is subclass of windowObjClass */
    		else if(XtIsSubclass(w, widgetClass)){
      			XtMapWidget(w);
		}
		else {
			XtManageChild(w);
		}
	}
}

/*-----------------------------------------------------------------------------
NAME:		void UxrUnmanage(sw)
INPUT:		swidget sw
RETURN:
DESCRIPTION:	Unmanage the swidget
CREATION:	29 July 1991
-----------------------------------------------------------------------------*/

void 	UxrUnmanage(sw)
     	swidget sw;
{
	Widget	w;

  	if (w = UxrRealWidget(sw)) 
	{
		if (XtIsSubclass(w, shellWidgetClass)){
      			XtPopdown(w);
		} else {
      			XtUnmanageChild(w);
		}
  	}
}

/*--------------------------------------------------------------------------
NAME:		void UxrManage(sw)
INPUT:		swidget sw
RETURN:
DESCRIPTION:	manage swidget
CREATION:	25 July 1991
--------------------------------------------------------------------------*/
void 	UxrManage(sw)
     	swidget sw;
{
	Widget	w;

  	if (w = UxrRealWidget(sw)) 
	{
		if (XtIsSubclass(w, shellWidgetClass)){
      			XtPopup(w, XtGrabNone);
		} else {
			XtManageChild(w);
		}
	}
}

/*-----------------------------------------------------------------------------
NAME:		void		UxrWaitForNotify()
INPUT:		--
RETURN:		--
DESCRIPTION:	Do an event loop until UxNotify_flag is set
CREATION:	Jan 21/1989
REVISIONS:	--
-----------------------------------------------------------------------------*/
void UxrWaitForNotify()
{
	XEvent		*oldev, event;

	UxNotifyFlag = 0;

	oldev = UxCurrentEvent;

	UxCurrentEvent = &event;

	while(!UxNotifyFlag) {
		XtAppNextEvent(UxAppContext, &event);
		XtDispatchEvent(&event);
	}

	UxCurrentEvent = oldev;

	UxrFlushQueue();
}

/*-----------------------------------------------------------------------------
NAME:		void		UxrNotify()
INPUT:		--
RETURN:		--
DESCRIPTION:	set UxNotify_flag to break from event loop in UxWait_for_notify
CREATION:	Jan 21/1989
REVISIONS:	--
-----------------------------------------------------------------------------*/
void UxrNotify()
{
	UxNotifyFlag= 1;
}

/*-----------------------------------------------------------------------------
NAME:		void		UxrFlushQueue()
INPUT:		--
RETURN:		--
DESCRIPTION:	set UxNotify_flag to break from event loop in UxWait_for_notify
CREATION:	Jan 21/1989
REVISIONS:	--
-----------------------------------------------------------------------------*/
void UxrFlushQueue()
{
	XEvent	*oldev, event;

	oldev = UxCurrentEvent;

	UxCurrentEvent = &event;

	while(XtAppPending(UxAppContext))
	{
		XtAppNextEvent(UxAppContext, &event);
		XtDispatchEvent(&event);
	}

	UxCurrentEvent = oldev;
}

static char	*UxUimxRFile= "app.rf",	 	/* main resource file */
		*UxToolkitRFile= "defaults.rf",	/* toolkit defaults file */
		*UxScreenRFile= "screen.rf",	 /* color/mono resource file */
		*UxSpecificRFile= "specific.rf"; /* size specific res. file */

/* ---------------------------------------------------------------------------
NAME:           Widget UxrXtInitialize(rfile, options, numOptions, argc, argv)
INPUT:		char *rfile  		-- The resource file of the user's 
					application.
		XrmDescRec options[]	-- Options to add to command line.
		Cardinal   numOptions   -- Number of options.
		int *arc;		-- Args from the mainline
		char **argc
RETURN: 	--
DESCRIPTION: Starts off our prototyping mode	
CREATION:       Jun 29 1988  Visual Edge Software
REVISION:	3 Jan 89
                -- added call to UxInit_interfaces().
		Jan 10.  - removed call to UxInit_interfaces
		-- Siegurd
		10 Jan 89
		-- put back call to UxInit_interfaces()
		18 Jan 89
		-- removed call to UxInit_interfaces() since it is to soon
		during the initialization phase to call it.
		4 May/90
		-- Added options and numOptions to parameter list.
		-- Fixed class and instance names for the application being
		run.
		19 May/90
		-- Changed path for OL resource files from 
		/usr/X/lib/X11/app-defaults to /usr/X/lib/app-defaults
		22 Jun/90
		-- Moved the specific file to be read in last. See scr88.
		31 August	OLE MERGE
		-- Merged UxrOptionInitialize function into
		   UxrXtInitialize.
		January 11 1991 -- Motif 1.1 Upgrade.	[bug1075]
		4 Septembre 1991 -- fix Merge from OLE
-----------------------------------------------------------------------------*/

char		*UxProgramName = (char *) 0;
char		*UxProgramClassName = (char *) 0;

Widget  UxrXtInitialize(rfile, options, numOptions, argc, argv)
     	char 			*rfile;
	XrmOptionDescRec	options[];
	Cardinal		numOptions;
     	unsigned int 		*argc;
     	char 			**argv;
{
	char		*appResDir;
  	char		*getenv();
  	void		UxrUimxError();
  	int		display_height;
  	char 		filename[256];
	dstring		uxapp;

	UxProgramName = strrchr(argv[0],'/');
	if( UxProgramName ) ++UxProgramName;
	else UxProgramName = argv[0];
	uxapp= dcreate("UXAPP=");
	dappend(uxapp, rfile);
	putenv(dnstr(uxapp));
	if (UxProgramClassName = strchr(dnstr(uxapp), '='))
		UxProgramClassName++;
	else
		UxProgramClassName = dnstr(uxapp);
	/* do not free uxapp -- memory used by putenv permanently */

#ifdef  OL_WIDGETS
	UxTopLevel = OlInitialize(argv[0], rfile, options , numOptions,
				  argc,argv);

	if ( UxTopLevel == NULL )
	{
		fprintf(stderr, "%s: OlInitialize() failed\n", argv[0]);
		return( NULL );
	}
#endif	/* OL_WIDGETS */
#ifdef  MOTIF_WIDGETS
	UxTopLevel = XtAppInitialize (&UxAppContext, rfile,
					options, numOptions, argc, argv,
					NULL, NULL, 0);

	XmRegisterConverters();
 	UxAddActions(action_list,XtNumber(action_list));
#endif	/* MOTIF_WIDGETS */
		
  	XSetErrorHandler(UxrUimxError); 

  	UxDisplay = XtDisplay(UxTopLevel);
  	UxScreen  = XDefaultScreen(UxDisplay);
  	UxRootWindow  = RootWindow(UxDisplay, UxScreen);

	/* We set the geometry of UxTopLevel so that dialogShells
	   that are parented on it will get centered on the screen
	   (if defaultPosition is true). */

	XtVaSetValues(UxTopLevel,
			XtNx, 0,
			XtNy, 0,
			XtNwidth, DisplayWidth(UxDisplay, UxScreen),
			XtNheight, DisplayHeight(UxDisplay, UxScreen),
			NULL);

	UxInit_colors();
	UxInitializeResourcePath();
	UxInitializeBitmapPath();

	/*******************************************************/
	/* Read all of the available resource files, merging   */
	/* the data base with the contents of all of the       */
	/* specified files.                                    */
	/*******************************************************/

        if ( (appResDir = getenv( "XAPPLRESDIR" )) != NULL) {
		strcpy(filename, appResDir);
		strcat(filename, "/");
	} else if ( (appResDir = getenv( "XAPPLOADDIR" )) != NULL ) {
		strcpy(filename, appResDir);
		strcat(filename, "/");
	} else {
#ifdef MOTIF_WIDGETS
		strcpy(filename, "/usr/lib/X11/app-defaults/");
#endif	/* MOTIF_WIDGETS */
#ifdef OL_WIDGETS
		strcpy(filename, "/usr/X/lib/app-defaults/");
#endif	/* OL_WIDGETS */
	}

	UxLoadResourceTree();
	UxUpdateScreenSpecificResources();

	UxrSetDefaultShell(0);
	UxUtype_init();
	UxrDDInit();
/*
 *
 *	At this point we are initializing the User defined resources.
 *
 */
	UxAddRuntimeResources();
	
	GC_init();
        return UxTopLevel;
}

/* ---------------------------------------------------------------------------
NAME:           Widget UxrInitialize(rfile,argc,argv)
INPUT:		char *rfile  	-- The resource file of the user's application.
		int *arc;	-- Args from the mainline
		char **argc
RETURN: 	--
DESCRIPTION: Starts off our prototyping mode	
CREATION:       Jun 29 1988  Visual Edge Software
REVISION:	3 Jan 89
                -- added call to UxInit_interfaces().
		Jan 10.  - removed call to UxInit_interfaces
		-- Siegurd
		10 Jan 89
		-- put back call to UxInit_interfaces()
		18 Jan 89
		-- removed call to UxInit_interfaces() since it is to soon
		during the initialization phase to call it.
		30 July 1990	bugfix 851
		-- CVEje01070, CVEje01069, CVEje00967
		-- new function UxrOptionInitialize performs most of the
		   work of UxrInitialize
		-- UxProgramName, UxProgramClassName declared and initialized
		16 August 90	[bug917]
		-- pass NULL instead of argv[0] as application name to XtOpenDisplay
		31 August 90	OLE MERGE
		-- Merged UxrOptionInitialize function with
		   UxrXtInitialize function. UxrOptionInitialize and
		   UxrInitialize just calls UxrXtInitialize now.
----------------------------------------------------------------------------*/
#ifdef MOTIF_WIDGETS

Widget  UxrOptionInitialize(rfile,argc,argv,options,num_options)
     	char 		*rfile;
     	unsigned int 	*argc;
     	char 		**argv;
	XrmOptionDescRec	*options;
	Cardinal	num_options;
{
	return(UxrXtInitialize(rfile, options, num_options, argc,argv));
}

Widget  UxrInitialize(rfile,argc,argv)
     	char 		*rfile;
     	unsigned int 	*argc;
     	char 		**argv;
{
    	return(UxrXtInitialize(rfile, NULL, 0, argc, argv));
}
#endif /* MOTIF_WIDGETS */

/* ---------------------------------------------------------------------------
NAME:		void UxrSetDefaultShell()
INPUT:		--
RETURN 		--
DESCRIPTION:	Initializes the shell class used depending on what the
		user places int the sub-resource:
		UIMX.UxWindowManager: uwm hpwm or twm
CREATION:       Sep 24 1988  Visual Edge Software
		-- changed to allow setting of UxDefaultShellType
REVISIONS:	29 Aug	1990	OLE MERGE
		-- Fixed UxrSetDefaultShell() to work for OL.
---------------------------------------------------------------------------*/
void UxrSetDefaultShell(shelltype)
	char	*shelltype;
{
#ifdef MOTIF_WIDGETS
#define	DEF_SHELL	"toplevel"
#endif /* MOTIF_WIDGETS */
#ifdef OL_WIDGETS
#define	DEF_SHELL	"baseWindow"
#endif /* OL_WIDGETS */

	dstring	ds;

	UxWindowManager = UxGetUimxDefault("windowManager", "uwm");

	if(shelltype == 0)
	    UxDefaultShellType = UxGetUimxDefault("defaultShell", DEF_SHELL);
	else
	    UxDefaultShellType = shelltype;

		/* store these in permanent storage */
	ds= dcreate(UxWindowManager);
	UxWindowManager= dnstr(ds);

	ds= dcreate(UxDefaultShellType);
	UxDefaultShellType= dnstr(ds);

#ifdef MOTIF_WIDGETS
	if(strcmp(UxDefaultShellType, DEF_SHELL) == 0)
		UxUserShell= (char*)topLevelShellWidgetClass;
	else if(strcmp(UxDefaultShellType, "transient") == 0)
		UxUserShell= (char*)transientShellWidgetClass;
	else
		UxUserShell= (char*)overrideShellWidgetClass;

	if(strcmp(UxWindowManager,"uwm") == 0)
		UxFirstEditorShell = (char*)topLevelShellWidgetClass;
	else
		UxFirstEditorShell = (char*)transientShellWidgetClass;
#endif	/* MOTIF_WIDGETS */
#ifdef OL_WIDGETS
	if(strcmp(UxDefaultShellType, "override") == 0)
		UxUserShell= (char*)overrideShellWidgetClass;
	else if(strcmp(UxDefaultShellType, "transient") == 0)
		UxUserShell= (char*)transientShellWidgetClass;
	else
		UxUserShell= (char*)baseWindowShellWidgetClass;
#endif /* OL_WIDGETS */

}
void UxrUimxError()
{
}

/*---------------------------------------------------------------------------
NAME:		Widget		UxrRealWidget(rs)
INPUT:		swidget	        s	
RETURN:		real widget (if shell get parent widget)
DESCRIPTION:	get the real widget for UIMX.
CREATION:	Feb 27/1989
REVISIONS:	March  1989
-----------------------------------------------------------------------------*/
Widget UxrRealWidget(s)
	swidget	s;
{
	Widget		wid,wp;
	swidget         sp;

	if(wid= UxGetWidget(s)){
	   if(XtIsSubclass(wid, shellWidgetClass))
	      return(wid);
	   sp = UxGetParent(s);
	   wp = XtParent(wid);
	   if(!UxrIsValidSwidget(sp))
	      return(wp ? wp : wid);
	   else if(wp && XtIsSubclass(wp,shellWidgetClass))
	      return wp;
	   else
	      return wid;
	}
	return (Widget)0;
}
/*--------------------------------------------------------------------------
NAME:		UxrAddTranslations(s,t)
INPUT:		swidget s, String t
RETURN:		--
DESCRIPTION:	add translation to swidget
CREATION:	25 May 1989
REVISIONS:      Sept 1989
                add ol virtual convertion.
		04 1990
		-- Handles policy: the switch statement is just a work around
		   a Motif bug.
--------------------------------------------------------------------------*/
void	UxrAddTranslations(s,t)
swidget	s;
String  t;
{
	Widget	w;
	XtTranslations tr;
	char *  vstr;
	Arg             a[1];
	char	*policy;


	if((w = UxGetWidget(s)) && t){
#ifdef OL_WIDGETS
	   vstr = OlConvertVirtualTranslation(t);
	   tr = XtParseTranslationTable(vstr);
	   if(vstr != t) 
              free(vstr);
#endif	/* OL_WIDGETS */
#ifdef MOTIF_WIDGETS
           tr = XtParseTranslationTable(t);
#endif	/* MOTIF_WIDGETS */
	policy = t;
	if (*policy == '#') {
		policy++;
		switch( *policy) {
			case 'r':
	    			XtSetArg(a[0], XtNtranslations, tr);
	    			XtSetValues(w, a, 1);
				break;
			case 'a':
	    			XtAugmentTranslations(w, tr);
				break;
			case 'o':
			default:
	    			XtOverrideTranslations(w, tr);
				break;
		}
	}
	else
	    	XtOverrideTranslations(w, tr);

/*	   XtOverrideTranslations(w,tr);  */
/*	   XtSetArg(a[0], XtNtranslations, tr);  */
/*	   XtSetValues(w, a, 1);  */

	}
}	

/*--------------------------------------------------------------------------
NAME:		char *UxrMakeString(txt)
INPUT:		char *txt
RETURN:		pointer to char
DESCRIPTION:	given string txt make a copy of it and return a pointer
		to copied string
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
char	*UxrMakeString(txt)
char	*txt;
{
	char   *str = (char *)0;

	if(txt != (char *)0)
           if(str = (char *)UxMalloc(strlen(txt)+1))
		strcpy(str,txt);
	return str;
}

/*--------------------------------------------------------------------------
NAME:		void GC_init()
INPUT:		--
RETURN:		--
DESCRIPTION:	create graphic context
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
static void GC_init()
{
	Window	root;
	XGCValues xgc;
  if (!UxDrawGC) {
	root = XRootWindow(UxDisplay,UxScreen);
    	xgc.foreground = 0xfd;
    	xgc.function = GXxor;
    	xgc.subwindow_mode = IncludeInferiors;
    	UxDrawGC = XCreateGC(UxDisplay,DefaultRootWindow(UxDisplay),
			   GCForeground | GCFunction | GCSubwindowMode, &xgc);

	xgc.foreground= BlackPixel(UxDisplay, UxScreen);
	xgc.background= WhitePixel(UxDisplay, UxScreen);
	UxUimxBlackGC = XCreateGC(UxDisplay,root,GCForeground | GCBackground,
			&xgc);
  }
}
/*--------------------------------------------------------------------------
NAME:		swidget UxrFindSwidget(name)
INPUT:		char *name
RETURN:		swidget
DESCRIPTION:	given a widgetname return it's swidget object
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/

swidget	UxrFindSwidget(name)
char	*name;
{
	swidget   w;
	swidget   UxWidListNameToSwidget();

	return UxWidListNameToSwidget(WidgetTable,name);
}	
/*--------------------------------------------------------------------------
NAME:		NameToSwidget(sw,name)	
INPUT:	        swidget    sw
		char	   *name
RETURN:
DESCRIPTION:      
CREATION:       1. March.90 
REVISIONS:      16, March, 90  
                -- gadget does not have name and has no children, 
                   add XrmQuarkToString to get gadget name
--------------------------------------------------------------------------*/
static  Widget NameToWidget(wid,name)
Widget	wid;
char	*name;
{	
	WidgetList	w_children;
	unsigned int	nc,i;
	Widget		w= (Widget)0;
        swidget sw;

	if(wid){
		if(!XtIsSubclass(wid,widgetClass)) {
                    if(!strcmp(XrmQuarkToString(wid->core.xrm_name), name)) 
                      return wid;
                }
		else if(w = XtNameToWidget(wid,name))
			return w;
		else if(UxrQueryTree(wid,&w_children,&nc)){
	     		for(i =0; i < nc; i++)
	            		if(w =NameToWidget(w_children[i],name))
					break;
	        	free(w_children);
		}
        }
	return w;
}

/*--------------------------------------------------------------------------
NAME:		swidget UxrNameToSwidget(ref,name)
INPUT:		char *name
		swidget ref 
RETURN:		swidget
DESCRIPTION:	given a widget name and a reference swidget 
		return it's swidget object if that object exist as 
		a child or as a sibling.
CREATION:	25 May 1989
LAST REV:	May 7, 1991			See bugfix 2311.
		-- Modified to start search at parent rather than grand-parent.
		   If search fails then do search over again starting at grand-
		   parent if one exists.
--------------------------------------------------------------------------*/

swidget	UxrNameToSwidget(ref,name)
swidget ref;
char	*name;
{
	Widget	  w,wid;
	swidget	  sw;

	/*
	 * Search for widget starting at parent.  If not found and there
	 * is a grand-parent then restart search at grand-parent.  If still
	 * not found then do global search.
	 */
	sw = UxMidgetParent(ref);
	if (wid = UxMidgetWidget(sw))
		w = NameToWidget(wid,name);
	else 
		w = NameToWidget(UxMidgetWidget(ref),name);

	if (w == NULL && wid != NULL) {
		Widget pwid = XtParent(wid);

		if (pwid != NULL)
			w = NameToWidget(pwid, name);
	}

	if (w != NULL) {
		return UxrWidgetToSwidget(w);
	} else {
		/* named swidget not in "ref" widget tree so 		*/
		/* find the first occurence of the named swidget in the */
		/* swidget table. Note that for multiple instances	*/
		/* interface this may not get the appropriate swidget   */

		return UxrFindSwidget(name);
	}
}

/*--------------------------------------------------------------------------
NAME:		swidget UxrCreateSwidget(name, c,p)
INPUT:		char *name, WidgetClass c, swidget p
RETURN:		swidget
DESCRIPTION:	create a swidget instance
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
swidget UxrCreateSwidget(name,c,p)
char		*name;
WidgetClass	c;
swidget		p;
{
	swidget	sw;

	sw = UxMidgetMake(name,c,p);
	return sw;
}

/*--------------------------------------------------------------------------
NAME:		Widget UxrShellWidget(sw)
INPUT:	        swidget sw	
RETURN:	        Widget	
DESCRIPTION:    gaven the swidget return it's most top Widget	
CREATION:       13, Sept. 1989	
REVISIONS:	19, Sept. 1989
                XtParent get extra parent, So add parentwp to keep
                Shell Widget
--------------------------------------------------------------------------*/
Widget UxrShellWidget(sw)
swidget sw;
{
    Widget w,wp, parentwp = (Widget) NULL;
    w = UxGetWidget(sw);
    if(w)
    {
        while(wp=XtParent(w))
        {
            parentwp = w;
            w = wp;
        }
    }
  return parentwp? parentwp: w;
}
    
  
/*--------------------------------------------------------------------------
NAME:		void UxTextAppend(w, string)
INPUT:          Widget	w
		char	*string
DESCRIPTION:	appends 'string' to the end of the buffer
CREATION:	Jun 30 1988, Visual Edge Software
REVISION:	July 11, 1989
                -- added support for Motif widgets
		July 15
		-- added OpenLook support
		July 16, 1990
		-- changed the second parameter from `string` to `str`
			because `string` is a typedef for some compiliers.
---------------------------------------------------------------------------*/
void	UxTextAppend(w,str)
     Widget w;
     char *str;
{
#ifdef	MOTIF_WIDGETS
	int	last_position;

	last_position = XmTextGetLastPosition(w);
	XmTextReplace(w, last_position, last_position, str);
#else
#ifdef OL_WIDGETS
	UxAppendToText(w, str);
#else
	XwTextSetInsertPos(w, XwTextGetLastPos(w));
	XwTextInsert(w, str);
	XwTextSetInsertPos(w, XwTextGetLastPos(w));
#endif	/* OL_WIDGETS */
#endif	/* MOTIF_WIDGETS */
}

static  void DestroySwidgetTree();


/*--------------------------------------------------------------------------
NAME:		UxrQueryTree(widget, wid_children, nc)	
INPUT:		Widget widget, WidgetList *wid_children, unsigned int *nc	
RETURN:         if given widget has children 1 otherwise return 0  
DESCRIPTION:    given widget copy its children widget list to  *wid_children 
                and copy the total number of children to *nc.  	
CREATION:	12, Oct. 89
REVISIONS:      15. Nov. 89
                fixed  popup childdren list index error. 
--------------------------------------------------------------------------*/

int	UxrQueryTree(widget,wid_children,nc)
Widget		widget;
WidgetList	*wid_children;
unsigned int	*nc;
{
	WidgetList	wlist,plist;
	int		i,np,n,size;
	CompositeWidget w;

	if(widget && XtIsSubclass(widget,widgetClass)){ 
		if(XtIsComposite(widget)){
	   		w= (CompositeWidget)widget;
	   		if(*nc = tree_num_children(w))
	      		wlist = tree_children(w);
		}
		else
			*nc= 0;
	   	if(np = tree_num_popups(widget))
	      	plist = tree_popups(widget);
           	if(n = *nc + np){
	      		size = n*sizeof(Widget);
              		if(*wid_children = (WidgetList)malloc(size)){
	         		for(i = 0; i < *nc; i++)
	            			(*wid_children)[i]= wlist[i];
		 		for(i = *nc; i < n; i++)
		    			(*wid_children)[i]= plist[i - *nc];
		 		*nc = n;
                 		return 1;
              		}
	   	}
	}
	return 0;
}

/*--------------------------------------------------------------------------
NAME:		UxrDestroySwidgetTree(Swidget)	
INPUT:	        swidget Swidget.
RETURN:
DESCRIPTION:    Delete given swidget and its children. 
CREATION:       12. Oct. 89
REVISIONS:      
--------------------------------------------------------------------------*/
void	UxrDestroySwidgetTree(Swidget)
swidget	Swidget;
{
	Widget	w;

	if(w = UxrRealWidget(Swidget))
	   DestroySwidgetTree(w);
}

/******************************************************************************
 ==== LOCAL ==================================================================
*******************************************************************************
NAME:		int		IsImplicitShell(sw)

INPUT:		swidget		sw		- swidget to check

RETURN:		1 or 0

DESCRIPTION:	Return whether this swidget has an implicit shell or not.
		It will only work correctly after the widget is created.

CREATION:	Aug 02/1990
REVISIONS:	--
-----------------------------------------------------------------------------*/

static int IsImplicitShell(sw)
	swidget		sw;
{
	swidget         par;
	Widget		wid, pwid;

	wid= UxGetWidget(sw);

	par= UxGetParent(sw);
	pwid= UxGetWidget(par);

	if((pwid == NULL) && !XtIsSubclass(wid, shellWidgetClass))
		return(1);

	return(0);
}

/*--------------------------------------------------------------------------
NAME:		DestroySwidgetTree(widget)	
INPUT:	        widget
RETURN:
DESCRIPTION:    given widget find all its children and  delete its corresponding                Swidget.  
CREATION:       12. Oct. 89
REVISIONS:      15. Nov. 89 
                move XtDestroyWidget()  to top level.
		Jul 29/1990
		      - removed call to UxrDestroyCallback: do code right here.
--------------------------------------------------------------------------*/
static  void DestroySwidgetTree(widget)
Widget	widget;
{	
	WidgetList	w_children;
	unsigned int	nc,i;	
	swidget		sw;

	if(widget)
        {  if(UxrQueryTree(widget,&w_children,&nc))
	   {     for(i =0; i < nc; i++)
	            DestroySwidgetTree(w_children[i]);
	         free(w_children);
	   }

	   sw = UxrWidgetToSwidget(widget);

	   if(UxrIsValidSwidget(sw))
	   {
		UxWidListFreeEntry(WidgetTable,widget);

		if(IsImplicitShell(sw))
			UxWidListFreeEntry(WidgetTable, UxRealWidget(sw));

		UxrFreeSwidget(sw);
	   }
	}
}

/*--------------------------------------------------------------------------
NAME:		Widget UxrWindowToWidget(win)	
INPUT:	        Window win. 
RETURN:         given Window win return its Widget.
DESCRIPTION:    
CREATION:       12. Oct. 89 
REVISIONS:    
--------------------------------------------------------------------------*/
Widget UxrWindowToWidget(win)
Window win;
{
	Widget UxWidListWindowToWidget();
	return UxWidListWindowToWidget(WidgetTable, win);
}


#ifdef OL_WIDGETS
#ifdef vms 
#include <decw$include/IntrinsicP.h>
#else
#include <X11/IntrinsicP.h>
#endif
#ifdef vms 
#include <decw$include/StringDefs.h>
#else
#include <X11/StringDefs.h>
#endif
#ifdef vms 
#include <decw$include/Shell.h>
#else
#include <X11/Shell.h>
#endif
#include <Xol/OpenLookP.h>
#include <Xol/ManagerP.h>
#include <Xol/TextP.h>
#include <Xol/TextFieldP.h>
#include <Xol/TextPaneP.h>
#include <Xol/PrimitiveP.h>
#endif	/* OL_WIDGETS */

/*--------------------------------------------------------------------------
NAME:		int UxPutReferenceWidget( o, wgt_name )
INPUT:		OHANDLE o, char *wgt_name;
RETURN:
DESCRIPTION:	This is the special case for  referenceWidget property of
		Text and TextField widgets.  
CREATION:	Jul/09/90
REVISIONS:	--
--------------------------------------------------------------------------*/
#ifdef OL_WIDGETS

int  	UxPutReferenceWidget( o, wgt_name )
OHANDLE   o;
char      *wgt_name;
{
   int    no_err = 1;
   Widget ref;

   if( is_instance_defined(o) ) {
      no_err = UxUimx_to_x(o, UxUT_string, &wgt_name, UxXT_Widget, &ref, TO_X);

      if( !no_err ) {
         Widget         w;

         UxObjectPutProp(o, XtNreferenceWidget, (HANDLE)ref );

         if( w = UxGetWidget( o ) ) {
	    TextPaneWidget tw = NULL;

	    if( XtClass( w ) == textFieldWidgetClass ) {
	       tw = ((TextFieldWidget)w)->textfield.text_widget;
	    } else if( XtClass( w ) == textWidgetClass ) {
	       tw = (TextPaneWidget)((TextWidget)w)->text.bb_child;
	    }

            if( tw ) {
               tw->primitive.reference_widget = ref;
               _OlDeleteDescendant( tw );
               _OlInsertDescendant( tw );
            }
         }
      }
   } 

   return  no_err;
}
#endif /* OL_WIDGETS */

/******************************************************************************
NAME:		int	UxStrEqual(str1, str2)
INPUTS:			char *str1, *str2;
RETURN:		1 if the strings are equal, 0 otherwise

DESCRIPTION:	Compares two strings and returns 1 if they are equal, 0
                otherwise. This routine checks for NULL pointers. If both
		pointers are NULL, the strings are equal. If only one
		pointer is NULL, the strings are not equal.

CREATION:	july/29/91  fix2823
REVISIONS:	--
-----------------------------------------------------------------------------*/

int	UxStrEqual(str1, str2)
	char *str1, *str2;
{
    if (str1 == str2)
	return 1;			/* both same ptr (maybe NULL) */
    else if (!str1 || !str2)
	return 0;			/* one is NULL and one is not */
    else
	return !strcmp(str1, str2);	/* both are valid strings */
}		

