/**********************************************************************/
/*
/* $Date: 91/10/26 00:27:41 $
/* $Revision: 1.4.33.1 $
/*
/**********************************************************************/

/*****************************************************************************/
/***									   ***/
/***		 Copyright (c) 1988, Visual Edge Software Ltd.		   ***/
/***									   ***/
/***   All rights reserved.  This notice is  intended  as  a  precaution   ***/
/***   against	inadvertent publication, and shall not be deemed to con-   ***/
/***   stitute an acknowledgment that publication has  occurred	 nor  to   ***/
/***   imply  any  waiver  of confidentiality.	The year included in the   ***/
/***   notice is the year of the creation of the work.			   ***/
/***									   ***/
/*****************************************************************************/

#include <malloc.h>
#include <type_us.h>
#include <type.h>
#include <id.h>		
#include <t_error.h>

#define TYPE_BLK          64
#define MAX_TYPE_SZ       1024
#define MAX_COLUMNS       1024
#define DEFAULT_NCOL      1
#define DEFAULT_NROW      8
#define DEFAULT_NCOL_INC  4

static  TYPE     *TypeHeader;
static  int       TypeSize,TypeFree,TypeNew;
static  int       InitType();

OHANDLE         UxNULL_TYPE={(short)-1,(short)0};

/******************************************************************************

NAME:           UxTypeRegister(id,super,is,cs)
INPUT:          HANDLE  id      -type name handle id
		OHANDLE super   -object handle to super type
		int     is      -instance size
		int     cs      -type size
RETURN:         OHANDLE         -object handle to type registered
DESCRIPTION:    Register a data structure as a type
CREATION:       Jan 3, 1989

_____________________________________________________________________________*/

OHANDLE UxTypeRegister(id,super,is,cs)
HANDLE  id;
OHANDLE super;
int     cs,is;
{
	short tid,next;
	TYPE  *header;
	
	if(!TypeHeader){
	    TypeNew = 0;
	    TypeFree = MAX_TYPE_SZ;
	    TypeSize =  TYPE_BLK ;
	    TypeHeader = (TYPE *)malloc((int)TypeSize * sizeof(TYPE));
	}
	if(TypeHeader){
	  if(TypeNew < TypeSize){
	    tid=  InitType(TypeNew,id,super,is,cs);
	    TypeNew++;
	    return UxOhCreate(tid,STATIC_CLASS,(HANDLE)TypeHeader[tid].data);
	  }
	  else if(TypeFree < TypeSize){
	    next = type_next(&TypeHeader[TypeFree]);
	    tid = InitType(TypeFree,id,super,is,cs);
	    TypeFree = next;
	    return UxOhCreate(tid,STATIC_CLASS,(HANDLE)TypeHeader[tid].data);
	  }
	  else if(TypeSize < MAX_TYPE_SZ){
	    TypeSize += TYPE_BLK;
	    if((header = (TYPE *)realloc(TypeHeader,TypeSize*sizeof(TYPE)))){
	       TypeHeader = header;
	       tid=  InitType(TypeNew,id,super,is,cs);
	       TypeNew++;
	       return UxOhCreate(tid,STATIC_CLASS,(HANDLE)TypeHeader[tid].data);
	    }
	  }
	}
	return UxNULL_TYPE;
}
/*****************************************************************************

NAME:           InitType(new,id,super,is,cs)
INPUT:          int     new     -new type id
		HANDLE  id      -type name handle id
		OHANDLE super   -object handle to super type
		int     is      -instance size
		int     cs      -type size
RETURN:         int             -new type id
DESCRIPTION:    Initializes the TYPE data structure
CREATION:       Jan 3, 1989

______________________________________________________________________________*/

static  int InitType(new,id,super,is,cs)
int     new;
HANDLE  id;
OHANDLE super;
int     cs,is;
{
	TYPE *type;

	type = &TypeHeader[new];
	type_set_class(type,super);
	type_set_name(type,id);
	type_set_class_size(type,cs);
	is = (is > sizeof(INT) ? is : sizeof(INT));
	type_set_instance_size(type,is);
	type_set_class_prop(type,UxNULL_OHANDLE);
	type_set_instance_prop(type,UxNULL_OHANDLE);
	type_set_data(type,(char *)0);
	if(cs)
	  type_set_data(type,(char *)malloc(cs));
	type_set_instance(type,(char **)malloc(DEFAULT_NCOL *sizeof(char *)));
	type_set_next(type,-1);
	type_set_ncol_inc(type,DEFAULT_NCOL_INC);
	type_set_new(type,-1);
	type_set_free(type,-1);
	type_set_ncol(type,DEFAULT_NCOL);
	type_set_nrow(type,DEFAULT_NROW);
	return new;
}

/*****************************************************************************

NAME:           UxTypeAllocInstance(class)
INPUT:          OHANDLE class   -object handle to super type
RETURN:         OHANDLE         -object handle to type registered
DESCRIPTION:    Allocate space for an instance of type or class
CREATION:       Jan 3, 1989

____________________________________________________________________________*/

OHANDLE UxTypeAllocInstance(class)
OHANDLE class;
{
	TYPE     *type;
	int       inc;
        short     col;
	char    **inst,*silo;
	INT       id;
	OHANDLE   oh;
	short     r,c;

	oh = UxNULL_OHANDLE;
	if(is_type_defined(class)){
	  type = &TypeHeader[oh_type(class)];
c = id_column(type_free(type));
	 if(id_column(type_free(type)) >= MAX_COLUMNS){
r = id_row(type_new(type));
	   if(id_row(type_new(type)) >= type_nrow(type)){
	     id_set_row(type_new(type),0);
r = id_row(type_new(type));
	     col = id_column(type_new(type))+1;
	     id_set_column(type_new(type),col);
c = id_column(type_new(type));
	     if(id_column(type_new(type)) >= type_ncol(type)){
	       inc = type_ncol(type) + type_ncol_inc(type);
	       type_set_ncol(type,inc);
	       if(type_ncol(type) > MAX_COLUMNS)
		 UxErrorHandler(INSTANCES_EXCEEDED,FATAL,"UxTypeAllocInstance");
	       if(!(inst = (char **)realloc(type_instance(type),
				      sizeof(char *)*type_ncol(type))))
		 UxErrorHandler(REALLOC_FAILED,FATAL,"UxTypeAllocInstance");
	       type_set_instance(type,inst);
	     }
r = id_row(type_new(type));
	     if(id_row(type_new(type)) == 0){
	       int	temp_var;

	       col = id_column(type_new(type));
	       inc = type_nrow(type) * type_instance_size(type);
	       if(!(silo = (char *)malloc(inc)))
		 UxErrorHandler(MALLOC_FAILED,FATAL,"UxTypeAllocInstance");

	       /* PS/2 compiler gives warnings when a subscript of an array
			is of type short				*/
	       temp_var = (int)col;
	       type->instance[temp_var] = silo;
	     }
	   }
	   id = type_new(type);
	   oh = UxOhCreate(oh_type(class),STATIC_INSTANCE,(HANDLE)id);
	   id_set_row(type_new(type),id_row(type_new(type)) + 1);
r = id_row(type_new(type));
	 }
	 else{
	    id = type_free(type);
	    oh = UxOhCreate(oh_type(class),STATIC_INSTANCE,(HANDLE)id);
	    type_set_free(type,*id_lookup(oh));
	 }
	}
	return oh;
}

/*--------------------------------------------------------------------------
NAME:		char *UxTypeLookup(oh)
INPUT:		OHANDLE
RETURN:		pointer to char  
DESCRIPTION:	looks up given OHANDLE (oh)'s actual memory address, return
                the pointer which will be casted to user defined type.
CREATION:	25 May 1989
REVISIONS:	--
---------------------------------------------------------------------------*/
char    *UxTypeLookup(oh)
OHANDLE oh;
{
	int     t,r,c;
	TYPE    *type;

	if(is_instance_defined(oh)){
	   t = oh_type(oh);
	   c = id_column(oh_handle(oh));
	   r = id_row(oh_handle(oh));
	   if((t >= 0) && (t < TypeNew)){
	      type = &TypeHeader[t];
	      if((r >=  0) && (r < type_nrow(type)) &&
		 (c >=  0) && (c < type_ncol(type)))
		 return (char *)(type->instance[c] + type->instance_size * r);
	   }
	}
	return (char *)0;
}
/*--------------------------------------------------------------------------
NAME:		void    UxTypeResize(oh,nr,nci)   
INPUT:		OHANDLE oh; int  nr,nci;                 
RETURN:		
DESCRIPTION:	resets the default page_size and page_increment of the 
		OHANDLE oh to the values defined by user (nr,nci)
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void    UxTypeResize(oh,nr,nci)
OHANDLE oh;
int     nr,nci;                
{
	UxTypeSetNrow(oh,nr);
	UxTypeSetNcolInc(oh,nci);
}

/*--------------------------------------------------------------------------
NAME:		void    UxTypeSetNrow(oh,nr)                              
INPUT:		OHANDLE oh, int nr                                          
RETURN:		
DESCRIPTION:	set default page_size by nr
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void    UxTypeSetNrow(oh,nr)
OHANDLE oh;
int     nr;			
{
	TYPE    *type;
	if(nr && is_class_defined(oh)){
	  type = &TypeHeader[oh_type(oh)];
	  if(type_new(type) < 0)
	    type_set_nrow(type,nr);
	}
}

/*--------------------------------------------------------------------------
NAME:		void    UxTypeSetNcolInc(oh,nci)          
INPUT:		OHANDLE oh, int     nci                            
RETURN:		
DESCRIPTION:	set default page_increment value by nci
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void    UxTypeSetNcolInc(oh,nci)
OHANDLE oh;
int     nci;
{
	TYPE    *type;

	if(nci && is_class_defined(oh)){
	  type = &TypeHeader[oh_type(oh)];
	  type_set_ncol_inc(type,nci);
	}
}
/*--------------------------------------------------------------------------
NAME:		char    *UxTypeGet(oh)            
INPUT:		OHANDLE oh
RETURN:		pointer to char
DESCRIPTION:	return the type of OHANDLE oh
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
char    *UxTypeGet(oh)
OHANDLE oh;
{

	if(is_class_defined(oh))
	  return (char *)&TypeHeader[oh_type(oh)];
}

/*--------------------------------------------------------------------------
NAME:		void UxTypeFreeInstance(oh)
INPUT:		OHANDLE oh
RETURN:
DESCRIPTION:	deallocates a memory block
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void	UxTypeFreeInstance(oh)
OHANDLE oh;
{
	INT *ptr;	
	TYPE	*type;

	if(ptr = (INT *)UxTypeLookup(oh)){
	   type = &TypeHeader[oh_type(oh)];
	   *ptr = type_free(type);
	   type_set_free(type,oh_handle(oh));
	}
}
