/**********************************************************************/
/*
/* $Date: 91/10/26 00:29:04 $
/* $Revision: 1.4.33.1 $
/*
/**********************************************************************/

 
/*****************************************************************************/
/***									   ***/
/***		 Copyright (c) 1988, Visual Edge Software Ltd.		   ***/
/***									   ***/
/***   All rights reserved.  This notice is  intended  as  a  precaution   ***/
/***   against	inadvertent publication, and shall not be deemed to con-   ***/
/***   stitute an acknowledgment that publication has  occurred	 nor  to   ***/
/***   imply  any  waiver  of confidentiality.	The year included in the   ***/
/***   notice is the year of the creation of the work.			   ***/
/***									   ***/
/*****************************************************************************/

#include <malloc.h>
#include <string.h>
#include <type_us.h>
#include <lista.h>
#include <proplist.h>
#include <uimx_cat.h>
#include <lib_ds.h>
#define	CGETS(x,y)	UxCatGets(MC_LIBUIMX,(x),(y))

OHANDLE T_prop_list;

static OHANDLE InitPropList();


/*--------------------------------------------------------------------------
NAME:		OHANDE ProListMake()
INPUT:		
RETURN:
DESCRIPTION:	Make a property list instance
REVISIONS:	--
--------------------------------------------------------------------------*/
OHANDLE UxPropListMake()
{
	OHANDLE oh;

	if(!is_type_defined(T_prop_list))
	   T_prop_list = type_register(sizeof(PROP_LIST));
	oh = UxTypeAllocInstance(T_prop_list);
	return InitPropList(oh);
}

/*--------------------------------------------------------------------------
NAME:		static OHANDE InitPropList(oh)
INPUT:		OHANDLE oh
RETURN:		OHANDLE
DESCRIPTION:	Initialize the OHANDLE (oh)
CREATION:	J. Cronembold           25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
static OHANDLE InitPropList(oh)
OHANDLE oh;
{
	PROP_LIST *l;

	if(l = prop_list_lookup(oh))
	   prop_list_put_list(l,UxNULL_OHANDLE);
	return oh;
}

/*--------------------------------------------------------------------------
NAME:		OHANDLE UxPropListPutEntry(pList, name , val)
INPUT:		OHANDLE  pList; char     *name;  HANDLE   val;
RETURN:		OHANDLE
DESCRIPTION:	Add a property name-value pair to the property lsit (p)
		If the property lsit (p) does not exist create one, and
		return its Object HANDLE
CREATION:	J. Cronembold           25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
OHANDLE  UxPropListPutEntry(pList,name,val)
OHANDLE  pList;
char     *name;
HANDLE   val;
{
	PropList  prop,new;
	char     *nm;
	int      sz;
	Prop      p;
	PROP_LIST   *o;

	if(!is_instance(pList))
	   pList = UxPropListMake();
	if(o = prop_list_lookup(pList)){
	   if(!is_instance(prop_list_list(o)))
	      prop_list_put_list(o,UxListaMake(sizeof(Prop)));
	   if(p.name =(char *)malloc(strlen(name) + 1)){
	       strcpy(p.name,name);
	        p.value = val;
	        if(new = (PropList)UxListaMakeEntry(prop_list_list(o))){
	            *new = p;
	            return pList;
		 }
	   }
	}
	return UxNULL_OHANDLE;
}


/*--------------------------------------------------------------------------
NAME:		HANDLE UxPropListValue(pList, name)
INPUT:		OHANDLE pList, char *name
RETURN:		HANDLE 
DESCRIPTION:	Return the value of the named property
CREATION:	J. Cronembold           25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
HANDLE   UxPropListValue(pList,name)
OHANDLE  pList;
char     *name;
{
	PropList        prop;

	if(prop = UxPropListEntry(pList,name))
	   return prop_value(prop);
	return NULL_HANDLE;
}


/*--------------------------------------------------------------------------
NAME:		PropList UxPropListEntry(pList, name)
INPUT:		OHANDLE pList, char *name
RETURN:`	PropList
DESCRIPTION:	Return a pointer to the name-value property pair
CREATION:	J. Cronembold           25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
PropList UxPropListEntry(pList,name)
OHANDLE pList;
char    *name;
{
	int     i,end;
	PropList list;
	OHANDLE  ohList;
	PROP_LIST   *pl;

	if(pl = prop_list_lookup(pList)){
	   ohList = prop_list_list(pl);
	   if(list = (PropList)UxListaList(ohList)){
	      end = UxListaEnd(ohList);
	      for(i = 0; i < end; i++)
		 if(!strcmp(list[i].name,name))
	      return &list[i];
	   }
	}
	return (PropList)0;
}


/*--------------------------------------------------------------------------
NAME:		int UxPropListSize(pList)
INPUT:		OHANDLE pList
RETURN:		integer
DESCRIPTION:	REturn the size of the property list
CREATION:	J. Cronembold           25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
int     UxPropListSize(pList)
OHANDLE pList;
{
	PROP_LIST *pl;

	if(pl = prop_list_lookup(pList))
	   return UxListaEnd(prop_list_list(pl));
	return 0;
}


/*-------------------------------------------------------------------------
NAME:		void UxPropListDump (oh)
INPUT:		OHANDLE oh
RETURN:
DESCRIPTION:	Dump to the scrren all properties  in the list (oh)
CREATION:	J. Cronembold           25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void    UxPropListDump(oh)
OHANDLE oh;
{
	PropList  list;
	int      i,end;
	PROP_LIST   *o;
	char	*fmt;

	fmt = CGETS(MS_LU_FORMATDUMP,DS_MS_LU_FORMATDUMP);
	if(o = prop_list_lookup(oh))
	  if(list = (PropList)UxListaList(prop_list_list(o))){
	    end = UxListaEnd(prop_list_list(o));
	    for(i = 0; i < end; i++)
	       if(list[i].name)
		  printf(fmt,list[i].name,list[i].value);
	  }
}


/*--------------------------------------------------------------------------
NAME:		PropList UxPropListLookup(pLIst)
INPUT:		OHANDLE pList
RETURN:		PropList
DESCRIPTION:	Return a pointer to the beginning og the property list.
CREATION:	J. Cronembold           25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
PropList UxPropListLookup(pList)
OHANDLE pList;
{
	PROP_LIST *pl;

	if(pl = prop_list_lookup(pList))
	   return (PropList)UxListaList(prop_list_list(pl));
	return (PropList)0;
}


/*--------------------------------------------------------------------------
NAME:		void UxPropListFree (oL)
INPUT:		OHANDLE oL
RETURN:
DESCRIPTION:	Free memory associated with the specified property list.
CREATION:	J. Cronembold           25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void    UxPropListFree(oL)
OHANDLE oL;
{
	PROP_LIST *pl;
	int        sz,i;
	PropList   list;

	if(pl = prop_list_lookup(oL)){
	  if(list = (PropList)UxListaList(prop_list_list(pl))){
	     sz = UxListaEnd(prop_list_list(pl));
	     for(i = 0; i < sz; i++)
	       if(list[i].name)
		 free(list[i].name);
	     UxListaFree(prop_list_list(pl));
	  }
	  UxTypeFreeInstance(oL);
	}
}

/*--------------------------------------------------------------------------
NAME:		void UxPropListFreeEntry(oL, prop)
INPUT:		OHANDLE oL, char *prop
RETURN:
DESCRIPTION:	Remove a property entry from the property list.
CREATION:	J. Cronembold           25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void    UxPropListFreeEntry(oL,prop)
OHANDLE oL;
char    *prop;
{
	PropList list;

	if(list = UxPropListEntry(oL,prop))
	  if(list->name){
	     free(list->name);
	     list->name = (char *)0;
	  }
}

/*--------------------------------------------------------------------------
NAME:		OHANDLE UxPropListMerge(oL1, oL2)
INPUT:		OHANDLE oL1, oL2
RETURN:		OHANDLE
DESCRIPTION:	Marger two property lists (not implemented)
CREATION:	J. Cronembold           25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
OHANDLE UxPropListMerge(oL1,oL2)
OHANDLE oL1,oL2;
{
}
