/**********************************************************************/
/*
/* $Date: 91/10/26 00:27:28 $
/* $Revision: 1.3.33.1 $
/*
/**********************************************************************/

/*****************************************************************************/
/***									   ***/
/***		 Copyright (c) 1988, Visual Edge Software Ltd.		   ***/
/***									   ***/
/***   All rights reserved.  This notice is  intended  as  a  precaution   ***/
/***   against	inadvertent publication, and shall not be deemed to con-   ***/
/***   stitute an acknowledgment that publication has  occurred	 nor  to   ***/
/***   imply  any  waiver  of confidentiality.	The year included in the   ***/
/***   notice is the year of the creation of the work.			   ***/
/***									   ***/
/*****************************************************************************/

#include <object.h>

OHANDLE C_object;

static  OHANDLE InitObject();


/*--------------------------------------------------------------------------
NAME:		void UxObjectRegisterClass()
INPUT:	        	
RETURN:
DESCRIPTION:	Register the object class
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void    UxObjectRegisterClass()
{
	C_object = UxTypeRegister(0l,UxNULL_OHANDLE,sizeof(object),0);
}


/*--------------------------------------------------------------------------
NAME:		OHANDLE UxObjectMake(type)
INPUT:		OHANDLE type
RETURN:		OHANDLE
DESCRIPTION:	Make an instance of the class object
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
OHANDLE  UxObjectMake(type)
OHANDLE  type;
{
	OHANDLE oh;

	if(is_type_defined(type)){
	   if(!is_type_defined(C_object))
	       UxObjectRegisterClass();
	   oh = UxTypeAllocInstance(type);
	   oh_set_flag(oh,DYNAMIC_INSTANCE);
	   return InitObject(oh);
	}
	return UxNULL_OHANDLE;
}

/*--------------------------------------------------------------------------
NAME:		static OHANDLE InitObject(oh)
INPUT:		OHABDLE oh
RETURN:         OHANDLE
DESCRIPTION:	Initialize the OHANDLE 
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
static OHANDLE InitObject(oh)
OHANDLE oh;
{
	object  *m;

	if(m = obj_lookup(oh)){
	   obj_put_self(m,oh);
	   obj_put_prop_list(m,UxNULL_OHANDLE);
	}
	return oh;
}

/*--------------------------------------------------------------------------
NAME:		void UxObjectPutProp(o,p,v)
INPUT:		OHANDLE o, char* p, HANDLE v
RETURN:         
DESCRIPTION:	Set a synamic property (p) of the object (o) to the 
		value (v)
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void    UxObjectPutProp(o,p,v)
OHANDLE o;
char    *p;          
HANDLE   v;
{
	OHANDLE pList,pl;
	object  *obj;

	if(is_dynamic_instance(o) && (obj = obj_lookup(o))){
	   pList = obj_prop_list(obj);
	   pl = UxPropListPutEntry(pList,p,v);
	   if(is_instance(pl))
	      obj_put_prop_list(obj,pl);
	}
}


/*--------------------------------------------------------------------------
NAME:		HANDLE UxObjectGetProp(o,p)
INPUT:		OHANDLE o, char *p
RETURN:		HANDLE 
DESCRIPTION:	Return the value of the dynammic property (p) og object
                (o)
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
HANDLE UxObjectGetProp(o,p)
OHANDLE o;
char    *p;
{
	OHANDLE pList;
	object  *obj;

	if(is_dynamic_instance(o) && (obj = obj_lookup(o))){
	   pList = obj_prop_list(obj);
	   return UxPropListValue(pList,p);
	}
	return 0l;
}


/*--------------------------------------------------------------------------
NAME:		OHANDLE ObjectPropLIst(o)
INPUT:		OHANDLE o
RETURN:
DESCRIPTION:	Return a handle to the object's dynamic property list
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
OHANDLE UxObjectPropList(o)
OHANDLE o;
{
	OHANDLE pList;
	object  *obj;

	if(is_dynamic_instance(o) && (obj = obj_lookup(o)))
	   return (pList = obj_prop_list(obj));
	return UxNULL_OHANDLE;
}

/*--------------------------------------------------------------------------
NAME:		int UxObjectIsPropDefined (o, prop)
INPUT:		OHANDLE o, char *prop
RETURN:		1 or 0
DESCRIPTION:	Given an object (o) determine if the dynamic property (prop)
		has been set.
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
int     UxObjectIsPropDefined(o,prop)
OHANDLE o;
char    *prop;
{
	OHANDLE pl;
	object  *obj;

	if(obj = obj_lookup(o)){
	   pl = obj_prop_list(obj);
	   if(UxPropListEntry(pl,prop))
	     return 1;
	}
	return 0;
}


/*--------------------------------------------------------------------------
NAME:		UxObjectDump (o)
INPUT:		OHANDLE o
RETURN:
DESCRIPTION:	Dump the dynamic property list to the screen
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void    UxObjectDump(o)
OHANDLE o;
{
	OHANDLE pList;
	object  *obj;

	if(is_dynamic_instance(o) && (obj = obj_lookup(o))){
	   pList = obj_prop_list(obj);
	   UxPropListDump(pList);
	}
}


/*--------------------------------------------------------------------------
NAME:		int UxObjectPropListSize(o)
INPUT:		OHANDLE o
RETURN:		integer
DESCRIPTION:	Return the size of th dynamic property list
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
int     UxObjectUxPropListSize(o)
OHANDLE o;
{
	OHANDLE pList;
	object  *obj;

	if(is_dynamic_instance(o) && (obj = obj_lookup(o))){
	   pList = obj_prop_list(obj);
	   return UxPropListSize(pList);
	}
	return 0;
}
/*--------------------------------------------------------------------------
NAME:		void UxObjectSetProps(o,p)
INPUT:		OHANDLE o,p
RETURN:
DESCRIPTION:	Set an object's dynamic property to the property list (p)
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void     UxObjectSetProps(o,p)
OHANDLE  o,p;
{
	object  *obj;

	if(is_dynamic_instance(o) && (obj = obj_lookup(o)))
	   UxPropListMerge(obj_prop_list(obj),p);
}


/*--------------------------------------------------------------------------
NAME:		void UxObjectRemove(oh)
INPUT:		OHANDLE oh
RETURN:
DESCRIPTION:	Free the memory occupied by the object (oh)
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void    UxObjectRemove(oh)
OHANDLE oh;
{
	object *o;

	if(o = obj_lookup(oh)){
	   UxPropListFree(obj_prop_list(o));
	   UxTypeFreeInstance(oh);
	}
}
