/**********************************************************************/
/*
/* $Date: 91/10/26 00:29:50 $
/* $Revision: 1.5.33.1 $
/*
/**********************************************************************/


/*****************************************************************************/
/***									   ***/
/***		 Copyright (c) 1988, Visual Edge Software Ltd.		   ***/
/***									   ***/
/***   All rights reserved.  This notice is  intended  as  a  precaution   ***/
/***   against	inadvertent publication, and shall not be deemed to con-   ***/
/***   stitute an acknowledgment that publication has  occurred	 nor  to   ***/
/***   imply  any  waiver  of confidentiality.	The year included in the   ***/
/***   notice is the year of the creation of the work.			   ***/
/***									   ***/
/*****************************************************************************/

#include <malloc.h>
#include <string.h>
#include <xtool.h>
#include <object.h>
#include <midget.h>
#include <midgetD.h>

OHANDLE C_midgetD;

/*--------------------------------------------------------------------------
NAME:		OHANDLE UxMidgetDialogRegisterClass()
INPUT:		
RETURN:
DESCRIPTION:	Register the midget Dialog class, Sould be call only once.
CREATION:	July 1990 (see bug710)
REVISIONS:	--
--------------------------------------------------------------------------*/
void    UxMidgetDialogRegisterClass()
{
	if(!is_type_defined(C_midget))
	   UxMidgetRegisterClass();
	C_midgetD = UxTypeRegister(0l,C_midget,sizeof(midgetD),0);
	type_resize_page(C_midgetD,16);
}


/*-------------------------------------------------------------------------
NAME:		OHANDLE UxMidgeDialogMake(name, wclass, parent, context)
INPUT:		char* name,       WidgetClass wclass,
		OHANDLE parent,   unsigned char *context
RETURN:		OHANDLE
DESCRIPTION:	Instantiate a new dialog midget and initialize it to the data
		passed through the arguments above.
CREATION:	July 1990 (see bug710)
REVISIONS:	--
--------------------------------------------------------------------------*/
OHANDLE  UxMidgetDialogMake(name,wclass,parent)
char            *name;
WidgetClass     wclass;
OHANDLE         parent;
{
	OHANDLE oh;

	if(!is_type_defined(C_midgetD))
	   UxMidgetDialogRegisterClass();
	oh = UxObjectMake(C_midgetD);
	return UxMidgetInit(oh,name,wclass,parent);
}

