/*------------------------------------------------------------------------
 * $Date: 91/10/26 00:28:47 $ 		        $Revision: 1.9.33.1 $
 *
 * Copyright 1990, Visual Edge Software Ltd.
 * -----------------------------------------
 * ALL RIGHTS RESERVED.  This notice is intended as a precaution against
 * inadvertent publication, and shall not be deemed to constitute an 
 * acknowledgment that publication has  occurred nor to imply any waiver  
 * of confidentiality.	The year included in the notice is the year 
 * of the creation of the work.			   
 *------------------------------------------------------------------------*/

#include <malloc.h>
#include <string.h>
#include <xtool.h>
#include <object.h>
#include <midget.h>

#ifdef OL_WIDGETS
#include <table.h>
#endif /* OL_WIDGETS */

OHANDLE C_midget;


/*--------------------------------------------------------------------------
NAME:		OHANDLE UxMidgetRegisterClass()
INPUT:		
RETURN:
DESCRIPTION:	Register the midget class, Sould be call onlu once.
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void    UxMidgetRegisterClass()
{
	if(!is_type_defined(C_object))
	   UxObjectRegisterClass();
	C_midget = UxTypeRegister(0l,C_object,sizeof(midget),0);
	type_resize_page(C_midget,16);
}


/*-------------------------------------------------------------------------
NAME:		OHANDLE UxMidgetMake(name, wclass, parent, context)
INPUT:		char* name,       WidgetClass wclass,
		OHANDLE parent,   unsigned char *context
RETURN:		OHANDLE
DESCRIPTION:	Instantiate a new midget and initialize it to the data
		passed through the arguments above.
CREATION:	25 May 1989
REVISIONS:	--
REVISIONS:	July 18 1990
		-- made the function global and changed its name from
		   InitMidget to UxMidgetInit. (see bug710)
--------------------------------------------------------------------------*/
OHANDLE  UxMidgetMake(name,wclass,parent)
char            *name;
WidgetClass     wclass;
OHANDLE         parent;
{
	OHANDLE oh;

	if(!is_type_defined(C_midget))
	   UxMidgetRegisterClass();
	oh = UxObjectMake(C_midget);
	return UxMidgetInit(oh,name,wclass,parent);
}


/*--------------------------------------------------------------------------
NAME:		OHANDLE UxMidgetInit(oh, name, wclass parent)
INPUT:		OHANDLE oh,           char* name
		WidgetClass wclass,   OHANDLE parent
RETURN:         OHANDLE 
DESCRIPTION:	
CREATION:	25 May 1989
LAST REV:	June 19, 1991
		- Initialize the context to NULL if no parent is specified.
--------------------------------------------------------------------------*/
OHANDLE UxMidgetInit(oh,name,wclass,parent)
OHANDLE         oh;
char            *name;
WidgetClass     wclass;
OHANDLE         parent;
{
	midget  *m;

	UxMidgetPutName(oh,name);
	if(m = midget_lookup(oh)){
	    midget_put_widget(m,(Widget)0);
	    if (is_instance_defined(parent))
	    	midget_put_context(m,UxMidgetContext(parent));
	    else
	    	midget_put_context(m,(unsigned char *)0);
	    midget_put_parent(m,parent);
	    midget_put_wclass(m,wclass);
	    midget_put_update_flag(m,1);
	    midget_put_translations(m,(char *)0);
	    midget_put_accelerators(m,(char *)0);
	    midget_put_defaultShell(m, (char *)0);
#ifdef OL_WIDGETS
	    m->table = UxrtTableGet(wclass);
	    m->counter = 0;
#endif /* OL_WIDGETS */
 	    m->flags = 0;
	}
	return oh;
}
/*--------------------------------------------------------------------------
NAME:		unsigned char *UxMidgetContext(oM)
INPUT:		OHANDLE oM
RETURN:		unsigned char
DESCRIPTION:	return the midget's context property
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
unsigned char *UxMidgetContext(oM)
OHANDLE oM;
{
	midget  *m;

	if(m = midget_lookup(oM))
	   return midget_context(m);
	return (unsigned char *)0;
}


/*--------------------------------------------------------------------------
NAME:		Widget UxMidgetWidget(oM)
INPUT:		OHANDLE oM
RETURN:		Widget
DESCRIPTION:	Return the midget's widget property
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
Widget  UxMidgetWidget(oM)
OHANDLE oM;
{
	midget  *m;

	if(m = midget_lookup(oM))
	   return midget_widget(m);
	return (Widget)0;
}


/*--------------------------------------------------------------------------
NAME:		void UxMidgetPutContext(oM, c)
INPUT:		OHANDLE oM, unsigned char *c
RETURN:
DESCRIPTION:	Set the midget's widget property.
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void    UxMidgetPutContext(oM,c)
OHANDLE oM;
unsigned char *c;
{
	midget  *m;

	if(m = midget_lookup(oM))
	   midget_put_context(m,c);
}


/*--------------------------------------------------------------------------
NAME:		void UxMidgetPutWidget(oM, w)
INPUT:		OHANDLE oM, Widget w
RETURN:
DESCRIPTION:	Set the midget's widget property
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void    UxMidgetPutWidget(oM,w)
OHANDLE oM;
Widget  w;
{
	midget  *m;

	if(m = midget_lookup(oM))
	   midget_put_widget(m,w);
}


/*--------------------------------------------------------------------------
NAME:		ArgList UxMidgetArgList(oM)
INPUT:		OHANDLE oM
RETURN:		ArgList
DESCRIPTION:	Return the midget's argument list.
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
ArgList UxMidgetArgList(oM)
OHANDLE oM;
{
	midget  *m;

	if(m = midget_lookup(oM))
	   return (ArgList)UxPropListLookup(midget_prop_list(m));
	 return (ArgList)0;
}


/*--------------------------------------------------------------------------
NAME:		int UxMidgetArgListSz(oM)		
INPUT:		OHANDLE oM	
RETURN:		int
DESCRIPTION:	return the midget's argument list size
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
int     UxMidgetArgListSz(oM)
OHANDLE oM;
{
	midget  *m;
	OHANDLE  pl;

	if(m = midget_lookup(oM)){
	   pl = midget_prop_list(m);
	   return UxPropListSize(pl);
	}
	return 0;
}


/*--------------------------------------------------------------------------
NAME:		void UxMidgetFree(oM)
INPUT:		OHANDLE oM
RETURN:
DESCRIPTION:	Free the specified midget instance.
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void    UxMidgetFree(oM)
OHANDLE oM;
{
	midget   *m;
	if(m = midget_lookup(oM)){
	   free(midget_name(m));
	   UxObjectRemove(oM);
	}
}


/*--------------------------------------------------------------------------
NAME:		void UxMidgetPutName(oM, name)
INPUT:		OHANDLE oM, char* name
RETURN:
DESCRIPTION:	set the midget's name property
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void    UxMidgetPutName(oM,name)
OHANDLE oM;
char    *name;
{
	midget  *m;
	char    *n;
	int	len;

	if(m = midget_lookup(oM)){
	   len = (name ? (strlen(name)+1) : 32);
	   if(n = (char *)malloc(len)){
	      if(name)
	         strcpy(n,name);
	      else
		 sprintf(n,"midget_%lu",oh_handle(oM));
	      midget_put_name(m,n);
	   }
	}
}


/*--------------------------------------------------------------------------
NAME:		char *UxMidgetName(oM)
INPUT:		OHANDLE oM
RETURN:		pointer to char
DESCRIPTION:	return the midget's name property value
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
char    *UxMidgetName(oM)
OHANDLE oM;
{
	midget  *m;

	if(m = midget_lookup(oM))
	   return midget_name(m);
	return (char *)0;
}

/*--------------------------------------------------------------------------
NAME:		void UxMidgetPutParent(oM, parent)
INPUT:		OHANDLE oM, parent
RETURN:
DESCRIPTION:	Set the midget's parent property.
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void    UxMidgetPutParent(oM,parent)
OHANDLE oM;
OHANDLE parent;
{
	midget  *m;

	if(m = midget_lookup(oM))
	      midget_put_parent(m,parent);
}


/*--------------------------------------------------------------------------
NAME:		OHANDLE UxMidgetParent(oM)
INPUT:		OHANDLE oM
RETURN:		OHANDLE
DESCRIPTION:	Return the midget's parent property value
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
OHANDLE  UxMidgetParent(oM)
OHANDLE oM;
{
	midget  *m;

	if(m = midget_lookup(oM))
	   return midget_parent(m);
	return UxNULL_OHANDLE;
}


/*--------------------------------------------------------------------------
NAME:		void UxMidgetPutWClass(oM, wclass)
INPUT:		OHANDLE oM, WidgetClass wclass
RETURN:	
DESCRIPTION:	Set the midget's widget class property.
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void    UxMidgetPutWClass(oM,wclass)
OHANDLE oM;
WidgetClass wclass;
{
	midget  *m;

	if(m = midget_lookup(oM))
	      midget_put_wclass(m,wclass);
}


/*--------------------------------------------------------------------------
NAME:		WidgetClass UxMidgetWClass(oM)
INPUT:		OHANDLE oM
RETURN:		WidgetClass
DESCRIPTION:	Return the midget's widget class property value
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
WidgetClass  UxMidgetWClass(oM)
OHANDLE oM;
{
	midget  *m;

	if(m = midget_lookup(oM))
	   return midget_wclass(m);
	return (WidgetClass)0;
}


/*--------------------------------------------------------------------------
NAME:		void UxMidgetPutUpdateFlag(oM,u)
INPUT:		OHANDLE oM, int u
RETURN:
DESCRIPTION:	set the midget's update flag property.
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void    UxMidgetPutUpdateFlag(oM,u)
OHANDLE oM;
int     u;
{
	midget  *m;

	if(m = midget_lookup(oM))
	      midget_put_update_flag(m,u);
}


/*--------------------------------------------------------------------------
NAME:		int UxMidgetUpdateFlag(oM)
INPUT:		OHANDLE oM
RETURN:         int
DESCRIPTION:	Return the midget's update flag property value
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
int     UxMidgetUpdateFlag(oM)
OHANDLE oM;
{
	midget  *m;

	if(m = midget_lookup(oM))
	  return  midget_update_flag(m);
	return 0;
}


/*--------------------------------------------------------------------------
NAME:		void MidgetPutTrandlations(oM, tr)
INPUT:		OHANDLE oM, char* tr
RETURN:
DESCRIPTION:	Set the Midget's tranlation property
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void    UxMidgetPutTranslations(oM,tr)
OHANDLE oM;
char    *tr ;
{
	midget  *m;
	Widget   w;

	if(m = midget_lookup(oM)){
           if(w = midget_widget(m)){
	      UxrAddTranslations(oM,tr);
	      return;
	   }	
	   midget_put_translations(m,tr);
  	}
}

/*--------------------------------------------------------------------------
NAME:		void UxMidgetPutAccelerators(oM, tr)
INPUT:		OHANDLE oM, char* tr
RETURN:
DESCRIPTION:	Set the swidget (or widget) accelerator property  
CREATION:	23  Nov. 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void    UxMidgetPutAccelerators(oM,tr)
OHANDLE oM;
char    *tr ;
{
	midget  *m;
	Widget   w;

	if(m = midget_lookup(oM)){
           if(w = midget_widget(m)){
	      UxrAddAccelerators(oM,tr);
	      return;
	   }	
	   midget_put_accelerators(m,tr);
  	}
}

/*--------------------------------------------------------------------------
NAME:		char* MidgetAccelerator(oM)
INPUT:		OHANDLE oM
RETURN:         char *
DESCRIPTION:    return the midget's accelerator translation name	
CREATION:	23  Nov. 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
char  	*UxMidgetAccelerators(oM)
OHANDLE oM;
{
	midget  *m;

	if(m = midget_lookup(oM))
	   return midget_accelerators(m);
	return (char *)0;
}

/*--------------------------------------------------------------------------
NAME:		char *UxMidgetTranslations(oM)
INPUT:		OHANDLE oM
RETURN:         pointer to char
DESCRIPTION:	Return the midget's translation name 
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
char  	*UxMidgetTranslations(oM)
OHANDLE oM;
{
	midget  *m;

	if(m = midget_lookup(oM))
	   return midget_translations(m);
	return (char *)0;
}

#ifdef OL_WIDGETS
/*--------------------------------------------------------------------------
NAME:		char *UxMidgetTable(oM)
INPUT:		OHANDLE oM
RETURN:         pointer to char
DESCRIPTION:	Return midget's Table property value
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
char  	*UxMidgetTable(oM)
OHANDLE oM;
{
	midget  *m;

	if(m = midget_lookup(oM))
	   return m->table;
	return (char *)0;
}

/*--------------------------------------------------------------------------
NAME:		int UxMidgetCounter(oM)
INPUT:		OHANDLE oM
RETURN:		int 
DESCRIPTION:	Return midget's conter value
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
int  	UxMidgetCounter(oM)
OHANDLE oM;
{
	midget  *m;
	int	ctr;

	if(m = midget_lookup(oM)){
	   ctr = m->counter;
	   m->counter += 1;
	   return ctr;
	}
	return -1;
}
#endif /* OL_WIDGETS */

/*--------------------------------------------------------------------------
NAME:		void UxMidgetFreeArgList(o)
INPUT:		OHANDLE o
RETURN: 
DESCRIPTION:	given an OHANDLE object free it's midget Arglist
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void	UxMidgetFreeArgList(o)
OHANDLE o;
{
	midget	*m;

	if(m = midget_lookup(o)){
	   UxPropListFree(midget_prop_list(m));
	   midget_put_prop_list(m,UxNULL_OHANDLE);
	}
}

/*--------------------------------------------------------------------------
NAME:		void UxMidgetPutDefaultShell(o,c)
INPUT:		OHANDLE o, char* c
RETURN: 
DESCRIPTION:	put shellclass name to midget 
CREATION:	10, Oct. 1989 
REVISIONS:	--
--------------------------------------------------------------------------*/

#ifdef MOTIF_WIDGETS
#include <Xm/DialogS.h>
#include <Xm/MenuShell.h>
#endif

void UxMidgetPutDefaultShell(o, class)
OHANDLE o;
char *class;
{

    midget	*m;
    if(m = midget_lookup(o)){
        if(!strcmp(class, "applicationShell")) 
	    midget_put_defaultShell(m, (char*)applicationShellWidgetClass);
        else if(!strcmp(class, "overrideShell"))
	    midget_put_defaultShell(m, (char*)overrideShellWidgetClass);
        else if(!strcmp(class, "topLevelShell"))
	    midget_put_defaultShell(m, (char*)topLevelShellWidgetClass);
        else if(!strcmp(class, "transientShell"))
	    midget_put_defaultShell(m, (char*)transientShellWidgetClass);

#ifdef MOTIF_WIDGETS
        if(!strcmp(class, "dialogShell"))
	    midget_put_defaultShell(m, (char*)xmDialogShellWidgetClass);
        else if(!strcmp(class, "menuShell"))
	    midget_put_defaultShell(m, (char*)xmMenuShellWidgetClass);
#endif

  }

}

/*--------------------------------------------------------------------------
NAME:		char * UxMidgetDefaultShell(o)
INPUT:		OHANDLE o;
RETURN: 
DESCRIPTION:    return the midget defaultShell value 
CREATION:	10, Oct. 1989 
REVISIONS:	--
--------------------------------------------------------------------------*/
char* UxMidgetDefaultShell(o)
OHANDLE o;
{
    
    midget	*m;
    char *s;
    if(m = midget_lookup(o)){
         if(s = midget_defaultShell(m))
              return s;
         else
              return (char*)0;
    }
}
/*--------------------------------------------------------------------------
NAME:		UxMidgetSetFlag(o,mask)
INPUT:		OHANDLE o;
		int	mask;		- mask specifying flag to be set
RETURN: 
DESCRIPTION:    sets the flags bit spedified in the mask 
CREATION:	1, Aug. 1990  (see bug866)
REVISIONS:	--
--------------------------------------------------------------------------*/

void	UxMidgetSetFlag(o,mask)
OHANDLE o;
int	mask;
{
	midget *m;
    	if(m = midget_lookup(o))
		m->flags = m->flags | mask;
}

/*--------------------------------------------------------------------------
NAME:		UxMidgetUnsetFlag(o,mask)
INPUT:		OHANDLE o;
		int	mask;		- specifies bit to unset
RETURN: 
DESCRIPTION:    unsets the flags bit spedified in mask 
CREATION:	1, Aug. 1990  (see bug866)
REVISIONS:	--
--------------------------------------------------------------------------*/

void	UxMidgetUnsetFlag(o,mask)
OHANDLE o;
int	mask;
{
	midget *m;
    	if(m = midget_lookup(o))
		m->flags = m->flags & ~mask;
}

/*--------------------------------------------------------------------------
NAME:		UxMidgetFlag(o,mask)
INPUT:		OHANDLE o;
		int	mask;		- specifies bit to get
RETURN: 
DESCRIPTION:    gets the flags bit spedified in mask 
CREATION:	1, Aug. 1990  (see bug866)
REVISIONS:	--
--------------------------------------------------------------------------*/

int	UxMidgetFlag(o,mask)
OHANDLE o;
int	mask;
{
	midget *m;
    	if(m = midget_lookup(o))
		return (m->flags & mask ? 1 : 0);
	return 0;
}
/*--------------------------------------------------------------------------
NAME:		UxMidgetSetWinGroupFlag(o)
INPUT:		OHANDLE o;
RETURN: 
DESCRIPTION:    sets the window group flag 
CREATION:	1, Aug. 1990   (see bug866)
REVISIONS:	--
--------------------------------------------------------------------------*/

void	UxMidgetSetWinGroupFlag(o)
OHANDLE o;
{
	UxMidgetSetFlag(o,UXWIN_GROUP_FLAG);
}

/*--------------------------------------------------------------------------
NAME:		UxMidgetGetWinGroupFlag(o)
INPUT:		OHANDLE o;
RETURN: 
DESCRIPTION:    gets the window group flag 
CREATION:	1, Aug. 1990   (see bug866)
REVISIONS:	--
--------------------------------------------------------------------------*/

int	UxMidgetGetWinGroupFlag(o)
OHANDLE o;
{
	return UxMidgetFlag(o,UXWIN_GROUP_FLAG);
}
/*--------------------------------------------------------------------------
NAME:		UxMidgetUnsetWinGroupFlag(o)
INPUT:		OHANDLE o;
RETURN: 
DESCRIPTION:    unsets the window group flag 
CREATION:	1, Aug. 1990   (see bug866)
REVISIONS:	--
--------------------------------------------------------------------------*/

void	UxMidgetUnsetWinGroupFlag(o)
OHANDLE o;
{
	UxMidgetSetFlag(o,UXWIN_GROUP_FLAG);
}

/*--------------------------------------------------------------------------
NAME:		UxMidgetGetCreateManaged(o)
INPUT:		OHANDLE o;
RETURN: 
DESCRIPTION:    gets the createManaged flag
CREATION:	15 April 1991	bugfix 2170
REVISIONS:	--
--------------------------------------------------------------------------*/

char*	UxMidgetGetCreateManaged(o)
	OHANDLE o;
{
	/** Create managed is true by default, 
	 ** unless the create_unmanaged flag has been set.
	 **/

	if (UxMidgetFlag (o,UXCREATE_UNMANAGED_FLAG)) 
	{
		return "false";
	}
	else
	{	
		return "true";
	}
}

/*--------------------------------------------------------------------------
NAME:		UxMidgetPutCreateManaged(o)
INPUT:		OHANDLE o;
		char    *cm;
RETURN: 
DESCRIPTION:    sets the create unmanaged flag according to whether
		'cm' is "true" or "false".
		
CREATION:	15 April 1991	bugfix 2170
REVISIONS:	--
--------------------------------------------------------------------------*/

void	UxMidgetPutCreateManaged(o, cm)
	OHANDLE o;
	char    *cm;
{
	if (cm && (strcmp(cm, "false") == 0)) {
		UxMidgetSetFlag (o, UXCREATE_UNMANAGED_FLAG);
	} else {
		UxMidgetUnsetFlag (o, UXCREATE_UNMANAGED_FLAG);
	}
}

