/**********************************************************************/
/*
/* $Date: 91/10/26 00:28:54 $
/* $Revision: 1.3.33.1 $
/*
/**********************************************************************/

/*****************************************************************************/
/***									   ***/
/***		 Copyright (c) 1988, Visual Edge Software Ltd.		   ***/
/***									   ***/
/***   All rights reserved.  This notice is  intended  as  a  precaution   ***/
/***   against	inadvertent publication, and shall not be deemed to con-   ***/
/***   stitute an acknowledgment that publication has  occurred	 nor  to   ***/
/***   imply  any  waiver  of confidentiality.	The year included in the   ***/
/***   notice is the year of the creation of the work.			   ***/
/***									   ***/
/*****************************************************************************/

#include <malloc.h>
#include <type_us.h>
#include <lista.h>

#define LIST_INC        5

static  OHANDLE T_lista;

static  OHANDLE InitLista();
static  char    *ListaRealloc();


/*--------------------------------------------------------------------------
NAME:	    	 OHANDLE UxListaMake(esize)
INPUT:	         int esize 	
RETURN:          OHANDLE
DESCRIPTION:     Create an array whose elements are of size "esize",
                 return a Object HANDLE to the array 
CREATION:	 25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/

OHANDLE UxListaMake(esize)
int     esize;
{
	OHANDLE oh;

	if(!is_type_defined(T_lista))
	   T_lista = type_register(sizeof(LISTA));
	oh = UxTypeAllocInstance(T_lista);
	return InitLista(oh,esize);
}


static OHANDLE InitLista(oh,esize)
OHANDLE oh;
int     esize;
{
	LISTA *l;

	if(l = lista_lookup(oh)){
	   lista_put_size(l,LIST_INC);
	   lista_put_end(l,0);
	   esize = (esize > sizeof(int) ? esize : sizeof(int));
	   lista_put_el_size(l,esize);
	   lista_put_free(l,-1);
	   lista_put_list(l,(char *)calloc(LIST_INC,esize));
	}
	return oh;
}


/*--------------------------------------------------------------------------
NAME:     	char *UxListaGetEntry(ohList) 
INPUT:	        OHANDLE	
RETURN:         pointer to char  
DESCRIPTION:    Given a list Object HANDLE, return a pointer to the first 
                available element entry, If there are no free element entries,
                make a new entry.
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/

char    *UxListaGetEntry(ohList)
OHANDLE  ohList;
{
	LISTA   *la;
	int      free;
	int     *list;
	char    *rtrn= (char *)0;

	if(la = lista_lookup(ohList))
	   if(lista_free(la) < 0)
	      return UxListaMakeEntry(ohList);
	   else {
		list = (int *)lista_list(la);
		rtrn = (char *)&list[lista_free(la)];
		free = list[lista_free(la)];
		lista_put_free(la,free);
	   }
	return rtrn;
}



/*--------------------------------------------------------------------------
NAME:		char *UxListaMakeEntry(ohList)
INPUT:	 	OHANDLE ohList	
RETURN:         pointer to char
DESCRIPTION:    given a list Object HANDLE, return a pointer to the next
		available element entry	
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/

char     *UxListaMakeEntry(ohList)
OHANDLE  ohList;
{
	int     i= 0;
	LISTA   *la;
	char   *list,*rtrn;

	if(la = lista_lookup(ohList)){
	  if(lista_end(la) >= (lista_size(la)-1))
	     list = ListaRealloc(ohList);
	  if(lista_list(la)){
	     i = lista_end(la) * lista_el_size(la);
	     rtrn = &la->list[i];
	     la->end++;
	     return rtrn;
	  }
	}
	return (char *)0;
}

static  char *ListaRealloc(ohL)
OHANDLE ohL;
{
	LISTA   *la;
	char   *list;
	int     ns,os,i,sz;

	if(la = lista_lookup(ohL)){
	   os = lista_size(la)*lista_el_size(la);
	   ns = (sz =lista_size(la) + LIST_INC)*lista_el_size(la);
	   if(list = realloc(lista_list(la),ns)){
	     for(i = os; i < ns; i++)
		list[i] = '\0';
	     lista_put_list(la,list);
	     lista_put_size(la,sz);
	     return list;
	   }
	}
	return (char *)0;
}



/*--------------------------------------------------------------------------
NAME:		char *UxListaEntry(ohList, index)
INPUT:	       	OHANDLE ohList, int index
RETURN:         pointer to char
DESCRIPTION:	Given a list Object HANDLE, return the pointer to the array
		element at the specified "index" location
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/

char    *UxListaEntry(ohList,index)
OHANDLE ohList;
int     index;
{
	LISTA   *la;
	int     i;

	if(la = lista_lookup(ohList)){
	   i = index * lista_el_size(la);
	   return &la->list[i];
	}
	return (char *)0;
}



/*--------------------------------------------------------------------------
NAME:		int UxListaSize(ohList)
INPUT:	 	OHANDLE ohList
RETURN:		number of entries
DESCRIPTION:    Given a list Object HANDLE, return the number of entries
		in the array.	
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/

int     UxListaSize(ohList)
OHANDLE ohList;
{
	LISTA   *la;

	if(la = lista_lookup(ohList))
	   return lista_size(la);
	return 0;
}



/*--------------------------------------------------------------------------
NAME:		int UxListaEnd(ohList)
INPUT:		OHANDLE ohList
RETURN:         length of the array 
DESCRIPTION: 	Given a list Object HANDLE, returns the length of the array
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/

int     UxListaEnd(ohList)
OHANDLE ohList;
{
	LISTA   *la;

	if(la = lista_lookup(ohList))
	   return lista_end(la);
	return 0;
}



/*--------------------------------------------------------------------------
NAME:		char *UxListaList(ohList)
INPUT:		OHANDLE ohList
RETURN:         pinter to list header 
DESCRIPTION:	Given a list Object HANDLE, return a pointer to the beginning
		of the list	
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
char    *UxListaList(ohList)
OHANDLE ohList;
{
	LISTA   *la;

	if(la = lista_lookup(ohList))
	   return lista_list(la);
	return (char *)0;
}

/*--------------------------------------------------------------------------
NAME:		void UxListaFreeEntry(ohList, index)
INPUT:		OHANDLE ohLIst, int index
RETURN:
DESCRIPTION:	Given a list Object HANDLE, add to a fre list the entry
		specified by the index.
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/

void    UxListaFreeEntry(ohList,index)
OHANDLE ohList;
int     index;
{
	LISTA   *la;
	int      free,i;
	int     *list;

	if(la = lista_lookup(ohList)){
	  free = index * lista_el_size(la);
	  list = (int *)lista_list(la);
	  list[free] = lista_free(la);
	  lista_put_free(la,free);
	}
}


/*--------------------------------------------------------------------------
NAME:		void UxListaFree(ohList, index)
INPUT:		OHANDLE ohLIst, int index
RETURN:
DESCRIPTION:	Given a list Object HANDLE free the memory associated with 
		the list.
CREATION:	25 May 1989
REVISIONS:	--
--------------------------------------------------------------------------*/
void    UxListaFree(ohList)
OHANDLE ohList;
{
	LISTA   *la;

	if(la = lista_lookup(ohList)){
	  if(lista_list(la));
	   	free(lista_list(la));
	  UxTypeFreeInstance(ohList);
	}
}
