/**********************************************************************/
/*
/* $Date: 91/10/25 23:32:52 $
/* $Revision: 1.5.33.1 $
/*
/**********************************************************************/

/*****************************************************************************/
/***                                                                       ***/
/***             Copyright (c) 1988, Visual Edge Software Ltd.             ***/
/***                                                                       ***/
/***   ALL RIGHTS RESERVED.  This notice is  intended  as  a  precaution   ***/
/***   against  inadvertent publication, and shall not be deemed to con-   ***/
/***   stitute an acknowledgment that publication has  occurred  nor  to   ***/
/***   imply  any  waiver  of confidentiality.  The year included in the   ***/
/***   notice is the year of the creation of the work.                     ***/
/***                                                                       ***/
/*****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <valloc.h>
#include <dstring.h>

#define BLOCKSIZE	64
#define round(len, sz) ( ((len)/(sz)+1)*(sz) )

dstring UxDefaultDstring= {NULL, 0, BLOCKSIZE};

/*****************************************************************************
 ==== GLOBAL ===================================== (called by code only) ====
******************************************************************************
NAME:		void		UxFree_dstring(ds)

INPUT:		dstring		*ds		- dstring to free

DESCRIPTION:	free the contents of the dstring
CREATION:	Jan 14/1989
REVISIONS:	--
-----------------------------------------------------------------------------*/

void UxFree_dstring(ds)
	dstring		*ds;
{
	if(ds->str != NULL)
		UxFree(ds->str);

	ds->str= NULL;
	ds->size= 0;
}

/*****************************************************************************
 ==== GLOBAL ===================================== (called by code only) ====
******************************************************************************
NAME:		void		UxAppend_to_dstring(s, dat)

INPUT:		dstring		*s		- string to append to
				*dat		- string to append

DESCRIPTION:	Append 'dat' to 's' resizing it if needed
CREATION:	Dec 16, 1988
REVISIONS:	--
-----------------------------------------------------------------------------*/

void UxAppend_to_dstring(s, dat)
	dstring		*s;
	char		*dat;
{
	int		UxDl, slen;

	if(dat == NULL)
		return;

	UxDl= strlen(dat);

	if(s->str == NULL)
	{	s->size= round(UxDl+1, s->blksize);
		s->str= UxRealloc(s->str, s->size);
		strcpy(s->str, dat);
		return;
	}

	slen= strlen(s->str);

	if(slen+UxDl+1 > s->size)
	{	s->size= round(slen+UxDl+1, s->blksize);
		s->str= UxRealloc(s->str, s->size);
	}

	strcat(s->str, dat);
}

/*****************************************************************************
 ==== GLOBAL ===================================== (called by code only) ====
******************************************************************************
NAME:		void		UxAppend_dstring(s, dat)

INPUT:		dstring		*s		- string to append to
				*dat		- string to append

DESCRIPTION:	Append 'dat' to 's' resizing it if needed
CREATION:	Dec 16, 1988
REVISIONS:	--
-----------------------------------------------------------------------------*/

void UxAppend_dstring(s, dat)
	dstring		*s, dat;
{
	int		UxDl, slen;

	if(dat.str == NULL)
		return;

	UxDl= strlen(dat.str);

	if(s->str == NULL)
	{	s->size= round(UxDl+1, s->blksize);
		s->str= UxRealloc(s->str, s->size);
		strcpy(s->str, dat.str);
		return;
	}

	slen= strlen(s->str);

	if(slen+UxDl+1 > s->size)
	{	s->size= round(slen+UxDl+1, s->blksize);
		s->str= UxRealloc(s->str, s->size);
	}

	strcat(s->str, dat.str);
}

/*****************************************************************************
 ==== GLOBAL ===================================== (called by code only) ====
******************************************************************************
NAME:		void		UxSet_ds_block(s, size)

INPUT:		dstring		*s		- dstring to change
		int		size		- new block size

DESCRIPTION:	set the block size for 's'.
CREATION:	Jan 14/1989
REVISIONS:	--
-----------------------------------------------------------------------------*/

void UxSet_ds_block(s, size)
	dstring		*s;
	int		size;
{
	int		UxDl;

	if(size == s->blksize)
		return;

	UxDl= strlen(s->str);

	s->blksize= size;

	s->size= round(UxDl+1, s->blksize);
	s->str= UxRealloc(s->str, s->size);
}

/*****************************************************************************
 ==== GLOBAL ===================================== (called by code only) ====
******************************************************************************
NAME:		dstring		UxDcreate(str)

INPUT:		char		*str		- initial string

RETURN:		created dstring

DESCRIPTION:	create a dstring given the initial string
CREATION:	Jan 14/1989
REVISIONS:	--
-----------------------------------------------------------------------------*/

dstring UxDcreate(str)
	char		*str;
{
	dstring		ds;

	ds.str= NULL;
	ds.size= 0;
	ds.blksize= BLOCKSIZE;

	UxAppend_to_dstring(&ds, str);

	return(ds);
}
