
/**********************************************************************/
/*
* $Date: 91/10/25 23:33:36 $
* $Revision: 1.4.33.1 $
*/
/**********************************************************************/

/*****************************************************************************/
/***                                                                       ***/
/***             Copyright (c) 1990, Visual Edge Software Ltd.             ***/
/***                                                                       ***/
/***   ALL RIGHTS RESERVED.  This notice is  intended  as  a  precaution   ***/
/***   against  inadvertent publication, and shall not be deemed to con-   ***/
/***   stitute an acknowledgment that publication has  occurred  nor  to   ***/
/***   imply  any  waiver  of confidentiality.  The year included in the   ***/
/***   notice is the year of the creation of the work.                     ***/
/***                                                                       ***/
/*****************************************************************************/
#include <stdio.h>
#include <ctype.h>
extern	char	*UxMalloc();

/* ---------------------------------------------------------------------------
NAME:           char *UxCopyString(string)
INPUT:		string		-- String to be duplicated
RETURNS:	A pointer to a copy of the input string
DESCRIPTION:   	Copies a string and returns a copy of it.
CREATION:       7 Sept 1990
---------------------------------------------------------------------------*/
char * UxCopyString(string)
     char * string;
{
  char * new_str = NULL;
  if ( string != NULL )
    {
      new_str = UxMalloc(strlen(string) + 1);
      strcpy(new_str, string);
    }
  return(new_str);
}

/*-----------------------------------------------------------------------------
 * NAME:	UxToLowerString()
 * INPUT:	pointer to a character string
 * RETURNS:	nothing
 *
 * DESCRIPTION:	
 *   This procedure takes the incoming string and puts it in lower case. 
 *   Notice: The string being passed is directly modified by this procedure.
 *   
 * CREATION:	20 Novembre 1990
 *---------------------------------------------------------------------------*/

char	*
UxToLowerString(string_ptr)
char *string_ptr;
{
    int i=0;
    while ( string_ptr[i] != '\0') {
 	if (isupper(string_ptr[i])) {
           string_ptr[i] = tolower(string_ptr[i]);
        }
        i++;
    }
    return(string_ptr);
}
