
/**********************************************************************/
/*
* $Date: 91/10/30 11:07:11 $
* $Revision: 1.10.33.2 $
*/
/**********************************************************************/

/*****************************************************************************/
/***                                                                       ***/
/***             Copyright (c) 1990, Visual Edge Software Ltd.             ***/
/***                                                                       ***/
/***   ALL RIGHTS RESERVED.  This notice is  intended  as  a  precaution   ***/
/***   against  inadvertent publication, and shall not be deemed to con-   ***/
/***   stitute an acknowledgment that publication has  occurred  nor  to   ***/
/***   imply  any  waiver  of confidentiality.  The year included in the   ***/
/***   notice is the year of the creation of the work.                     ***/
/***                                                                       ***/
/*****************************************************************************/

#ifndef	_UIMXCAT_H_
#define	_UIMXCAT_H_

#include <uxproto.h>

#ifdef  XOPEN_CATALOG
/* If XOPEN_CATALOG is defined, we use the message catalog */

#ifdef DESIGN_TIME
#define CAT_FILE	"uimx2_0.cat"
#endif
#ifdef RUNTIME
#define	CAT_FILE	"libuimx2_0.cat"
#endif
#ifdef UTILITIES
#define	CAT_FILE	"uxutils2_0.cat"
#endif


extern int	UxCatOpen UXPROTO(( void ));
extern void	UxCatClose UXPROTO(( void ));
extern char	*UxCatGets UXPROTO(( int, int, char * ));

#define UxCatGetc(setnum,msgnum,default) *UxCatGets(setnum,msgnum,default)

#else /* not using message catalog */

#define UxCatOpen()	0
#define UxCatClose()
#define UxCatGets(setnum,msgnum,default) (default)
#define UxCatGetc(setnum,msgnum,default) *(default)

#endif /* XOPEN_CATALOG */

#if defined(__STDC__) && !defined(apollo)
#define PASTE(token1,token2)		token1##token2
#define PASTE3(token1,token2,token3)	token1##token2##token3
#else
#define PASTE(token1,token2)		token1/**/token2
#define PASTE3(token1,token2,token3)	token1/**/token2/**/token3
#endif

#define UXCATGETS(setnum,msg_prefix,msg) \
	UxCatGets(setnum,PASTE(msg_prefix,msg),PASTE3(DS_,msg_prefix,msg))

#include <system_ds.h>


#endif /* _UIMXCAT_H_ */

