/**********************************************************************/
/*
/* $Date: 91/10/26 00:28:31 $
/* $Revision: 1.9.33.1 $
/*
/**********************************************************************/

#ifndef _UIMX_INCLUDED
#define _UIMX_INCLUDED

#include <malloc.h>
#ifdef vms 
#include <decw$include/IntrinsicP.h>
#else
#include <X11/IntrinsicP.h>
#endif
#ifdef vms 
#include <decw$include/CoreP.h>
#else
#include <X11/CoreP.h>
#endif
#ifdef vms 
#include <decw$include/CompositeP.h>
#else
#include <X11/CompositeP.h>
#endif
#ifdef vms 
#include <decw$include/Composite.h>
#else
#include <X11/Composite.h>
#endif

#include <object.h>
#include <midget.h>
#include <widlist.h>
#include <valloc.h>

#define ERROR           -1
#define NO_ERROR        0

typedef char    *Context;
typedef OHANDLE  swidget;
typedef char    *string;

typedef enum
{
    no_grab,
    nonexclusive_grab,
    exclusive_grab
} grabtype;

typedef struct cont_free_copy {
	char* cp;
	struct cont_free_copy *next;
} CFCOPY, *CFCOPY_PTR;

extern XtAppContext UxAppContext;

/* For UxrDestorySwidgetTree */
#define tree_num_children(w)	(((CompositeWidget)(w))->composite.num_children)
#define tree_children(w)	(((CompositeWidget)(w))->composite.children)
#define tree_num_popups(w)      ((w)->core.num_popups)
#define tree_popups(w)		((w)->core.popup_list)

#define UxGetContext(m)          UxMidgetContext(m)
#define UxPutContext(m,c)        UxMidgetPutContext(m,(unsigned char *)c)
#define UxPutUpdateFlag(m,f)     UxMidgetPutUpdateFlag(m,f)
#define UxGetWidget(m)           UxMidgetWidget(m)
#define UxGetArgList(m)          UxMidgetArgList(m)
#define UxGetArgListSize(m)      UxMidgetArgListSz(m)
#define UxGetUpdateFlag(m)       UxMidgetUpdateFlag(m)
#define UxGetParent(m)           UxMidgetParent(m)
#define UxGetClass(m)            UxMidgetWClass(m)
#define UxGetName(m)             UxMidgetName(m)
#define UxPutWidget(m,w)           UxMidgetPutWidget(m,w)
#define UxPutTranslations(m,t)     UxMidgetPutTranslations(m,t)
#define UxGetTranslations(m)       UxMidgetTranslations(m)
#define UxGetDefaultShell(m)       UxMidgetDefaultShell(m)
#define UxPutDefaultShell(m,s)     UxMidgetPutDefaultShell(m,s)

#ifdef	OL_WIDGETS
#include <UxPutsOL.h>
#include <UxGetsOL.h>
#endif
#ifdef   MOTIF_WIDGETS
#include <UxPutsMF.h>
#include <UxGetsMF.h>
#endif

#ifdef  HP_WIDGETS
#include <UxGetsHP.h>
#include <UxPutsHP.h>
#endif

#define x_used(o)                UxObjectIsPropDefined(o,XtNx)
#define y_used(o)                UxObjectIsPropDefined(o,XtNy)
#define allowShellResize_used(o) UxObjectIsPropDefined(o,XtNallowShellResize)
/* see bug836 */
#define height_used(o)		 UxObjectIsPropDefined(o,XtNheight)
#define width_used(o)		 UxObjectIsPropDefined(o,XtNwidth)
/* end bug836 */
#define NO_PARENT       UxNULL_OHANDLE

void    UxrDelayUpdate();
void    UxrUpdate();
int     UxrPutProp();
XtArgVal UxrGetProp();
Widget  UxrCreateWidget();
swidget UxrWidgetToSwidget();
void    UxrFreeSwidget();
int     UxrNeedsParentShell();
int     UxrIsShellClass();
Widget  UxrInitialize();
int     UxrIsValidSwidget();
void    UxrAddCallback();
void    UxrMainLoop();
int     UxrDestroyInterface();
void    UxrDestroySwidget();
void    UxrDestroyCallback();
int     UxrRealizeInterface();
int     UxrPopupInterface();
int     UxrPopdownInterface();
void    UxrUnmap();
void    UxrMap();
void    UxrWaitForNotify();
void    UxrNotify();
void    UxrFlushQueue();
void    UxrSetDefaultShell();
char    *UxGetUimxDefault();
Widget  UxrRealWidget(); 
char    *UxrMakeString();
void    UxrAddTranslations();
void    UxrAddAccelerators();
void    UxrCenterVisibly();
swidget UxrFindSwidget(); 
void    UxrPostMenu();
swidget UxrCreateSwidget();
void    UxrUimxError();
void    UxrNextEvent();
void    UxrDispatchEvent();
void    UxrSaveContextToFree();                
void	UxrCheckContext();
Widget  UxrShellWidget();
int 	UxrQueryTree();
void 	UxrDestroySwidgetTree();
swidget UxrNameToSwidget();
/** see bug804 */
void	UxrAddTabGroup();
void	UxrRemoveTabGroup();
/** end bug804 */
/** see bug847 */
void	UxrCenterWidgetVisibly();
Widget	UxrOptionInitialize();
/** end bug847 */

static int nfree = 0;
static CFCOPY_PTR cphead;

#define UxAddActions(a,b)    	XtAppAddActions(UxAppContext,a,b)

#define UxDelayUpdate(sw)     	UxrDelayUpdate(sw)
#define UxUpdate(sw) 		UxrUpdate(sw)
#define UxPutProp(s,n,v)       	UxrPutProp(s,n,v)
#define UxGetProp(s,n)	        UxrGetProp(s,n)
#define UxCreateWidget(s) 	UxrCreateWidget(s)
#define UxFreeSwidget(s)        UxrFreeSwidget(s)
#define UxIsShellClass(c)       UxrIsShellClass(c)
#define UxWidgetToSwidget(w)    UxrWidgetToSwidget(w)
#define UxNeedsParentShell(s)	UxrNeedsParentShell(s)
#define UxInitialize(r,argc,argv) UxrInitialize(r,argc,argv)
#define UxIsValidSwidget(m)	 UxrIsValidSwidget(m)
#define UxAddCallback(m,n,cb,c)  UxrAddCallback(m,n,cb,c)
#define UxMainLoop() UxrMainLoop()
#define UxDestroyInterface(sw)	 UxrDestroyInterface(sw)
#define UxDestroySwidget(sw)	 UxrDestroySwidget(sw)
#define UxDestroyCallback(w,a,b) UxrDestroyCallback(w,a,b)
#define UxRealizeInterface(sw)	 UxrRealizeInterface(sw)
#define UxPopupInterface(s,t)	 UxrPopupInterface(s,t)
#define UxPopdownInterface(sw)	 UxrPopdownInterface(sw)
#define UxUnmap(sw)		 UxrUnmap(sw)
#define UxMap(sw)		 UxrMap(sw)
#define UxWaitForNotify()	 UxrWaitForNotify()
#define UxNotify()		 UxrNotify()
#define UxFlushQueue()		 UxrFlushQueue()
#define UxSetDefaultShell(st)	 UxrSetDefaultShell(st)
#define UxRealWidget(s)		 UxrRealWidget(s)
#define UxMakeString(s)		 UxrMakeString(s)
#define UxAddTranslations(s,t)	 UxrAddTranslations(s,t)
#define UxCenterVisibly(rs,p)	 UxrCenterVisibly(rs,p)
#define UxFindSwidget(n)	 UxrFindSwidget(n)
#define UxPostMenu(s,o,p,q)	 UxrPostMenu(s,o,p,q)
#define UxCreateSwidget(n,c,p)	 UxrCreateSwidget(n,c,p)
#define UxUimxError()		 UxrUimxError()
#define UxShellWidget(sw)	 UxrShellWidget(sw)
#define UxQueryTree(w,wc, nc)	 UxrQueryTree(w,wc,nc)
#define UxDestroySwidgetTree(sw) UxrDestroySwidgetTree(sw)
#define UxNameToSwidget(r,n)	 UxrNameToSwidget(r,n)
/* see bug804 */
#define UxAddTabGroup(sw)	 UxrAddTabGroup(sw)
#define UxRemoveTabGroup(sw)	 UxrRemoveTabGroup(sw)
/* end bug804 */
/* see bug847 */
#define UxCenterWidgetVisibly(sw,sp) UxrCenterWidgetVisibly(sw,sp)
#define UxOptionInitialize(r,ac,av,op,no) UxrOptionInitialize(r,ac,av,op,no)
/* end bug847 */
#endif   /* _UIMX_INCLUDED */
