/**********************************************************************/
/*
/* $Date: 91/10/26 00:28:15 $
/* $Revision: 1.2.33.1 $
/*
/**********************************************************************/

#ifndef _OH_INCLUDED
#define _OH_INCLUDED

#define oh_SIZE 8   /* The size in bytes */

typedef struct ohandle{
	short           type;
	short           flag;
	union {
	  long	      	i;
	  float	      	f;
	  char	      	*p;
	  void        	(*func)();
	  unsigned long handle;
	} id;
} OHANDLE;


#define NULL_OH_TYPE -1
#define NULL_OH_FLAG -1

#define oh_i(oh)            ((&(oh))->id.i)
#define oh_f(oh)            ((&(oh))->id.f)
#define oh_p(oh)            ((&(oh))->id.p)
#define oh_func(oh)         ((&(oh))->id.func)
#define oh_handle(oh)       ((&(oh))->id.handle)
#define oh_type(oh)         ((&(oh))->type)
#define oh_flag(oh)         ((&(oh))->flag)


#define oh_set_i(oh,d)         (oh_i(oh) = (long)(d))
#define oh_set_f(oh,d)         (oh_f(oh) = (float)(d))
#define oh_set_p(oh,d)         (oh_p(oh) = (char *)(d))
#define oh_set_func(oh,d)      (oh_func(oh) = (void (*)())(d))
#define oh_set_handle(oh,d)    (oh_handle(oh) = (unsigned long)(d))
#define oh_set_type(oh,d)      (oh_type(oh) = (short)(d))
#define oh_set_flag(oh,d)      (oh_flag(oh) = (short)(d))

/*put given a pointer, used to modify a field within an existing ohandle */
#define oh_pset_i(vp, val)          ( (vp)->id.i= (val) )
#define oh_pset_f(vp, val)          ( (vp)->id.f= (val) )
#define oh_pset_p(vp, val)          ( (vp)->id.p= (char *)(val) )
#define oh_pset_func(vp,val)        ( (vp)->id.func= (val) )
#define oh_pset_handle(vp, val)     ( (vp)->id.handle= (val) )
#define oh_pset_type(vp, val)       ( (vp)->type= (val) )
#define oh_pset_flag(vp, val)       ( (vp)->flag= (val) )

extern OHANDLE UxNULL_OHANDLE;

OHANDLE UxOhCreate();

#endif    /* _OH_INCLUDED */
