/**********************************************************************/
/* $Date: 91/10/26 00:29:00 $
/* $Revision: 1.7.33.1 $
/**********************************************************************/

#ifndef _MIDGET_INCLUDED
#define _MIDGET_INCLUDED 

/* 
   define the flag constants. At the moment
   only need to define a constant for window
   group. If in the need for other flags
   arises in the future define other constants 
   as 2,4,8,16,etc  (see bug866)
*/
#define UXWIN_GROUP_FLAG	1
#define UXCREATE_UNMANAGED_FLAG 2


typedef struct  {
		OHANDLE         self;
		OHANDLE         prop_list;
		char            *name;
		WidgetClass     wclass;
		Widget          widget;
		OHANDLE         parent;
                char            *accelerators;
		char		*translations;
		int             update_flag;
		unsigned char   *context;
		char  		*defaultShell;
#ifdef OL_WIDGETS
		char		*table;
		int		counter;
#endif /* OL_WIDGETS */
		int		flags;
	} midget;

void    UxMidgetRegisterClass();
OHANDLE UxMidgetMake();
OHANDLE UxMidgetInit();
OHANDLE UxMidgetPutArgEntry();
XtArgVal UxMidgetArgEntry();
unsigned char *UxMidgetContext();
Widget  UxMidgetWidget();
void    UxMidgetPutContext();
void    UxMidgetPutWidget();
void    UxMidgetDumpArg();
ArgList UxMidgetArgList();
int     UxMidgetArgListSz();
void    UxMidgetDestroy();
void    UxMidgetPutName();
char    *UxMidgetName();
void    UxMidgetPutParent();
OHANDLE UxMidgetParent();
void    UxMidgetPutWClass();
WidgetClass UxMidgetWClass();
void    UxMidgetPutUpdateFlag();
int     UxMidgetUpdateFlag();
void    UxMidgetFree();
void    UxMidgetPutTranslations();
char    *UxMidgetTranslations();

#ifdef OL_WIDGETS
char	*UxMidgetTable();
int	UxMidgetCounter();
#endif /* OL_WIDGETS */

void    UxMidgetFreeArgList();
void	UxMidgetPutDefaultShell();
char    *UxMidgetDefaultShell();
void    UxMidgetPutAccelerators();
char    *UxMidgetAccelerators(); 

void	UxMidgetSetFlag();
void	UxMidgetUnsetFlag();
void    UxMidgetSetWinGroupFlag();
int	UxMidgetGetWinGroupFlag();
void	UxMidgetUnsetWinGroupFlag();

#define midget_lookup(o)        type_lookup(o,midget)

#define midget_self(m)             (m->self)
#define midget_put_self(m,c)       (midget_self(m) = c)
#define midget_widget(m)           (m->widget)
#define midget_prop_list(m)        (m->prop_list)
#define midget_context(m)          (m->context)
#define midget_put_widget(m,w)     (midget_widget(m) = w)
#define midget_put_prop_list(m,l)  (midget_prop_list(m) = l)
#define midget_put_context(m,c)    (midget_context(m) = c)
#define midget_name(m)             (m->name)
#define midget_put_name(m,n)       (midget_name(m) = n)
#define midget_parent(m)           (m->parent)
#define midget_put_parent(m,p)     (midget_parent(m) = p)
#define midget_wclass(m)           (m->wclass)
#define midget_put_wclass(m,p)     (midget_wclass(m) = p)
#define midget_update_flag(m)           (m->update_flag)
#define midget_put_update_flag(m,p)     (midget_update_flag(m) = p)
#define midget_translations(m)		(m->translations)
#define midget_put_translations(m,t)    (midget_translations(m) = t)
#define midget_defaultShell(m)		(m->defaultShell)
#define midget_put_defaultShell(m,s)    (midget_defaultShell(m) = s)
#define midget_accelerators(m)          (m->accelerators)
#define midget_put_accelerators(m,t)    (midget_accelerators(m) = t)


extern OHANDLE C_midget;

#endif   /* _MIDGET_INCLUDED */
