/**********************************************************************/
/*
/* $Date: 91/10/26 00:28:09 $
/* $Revision: 1.3.33.1 $
/*
/**********************************************************************/


/*****************************************************************************/
/***									   ***/
/***		 Copyright (c) 1988, Visual Edge Software Ltd.		   ***/
/***									   ***/
/***   All rights reserved.  This notice is  intended  as  a  precaution   ***/
/***   against	inadvertent publication, and shall not be deemed to con-   ***/
/***   stitute an acknowledgment that publication has  occurred	 nor  to   ***/
/***   imply  any  waiver  of confidentiality.	The year included in the   ***/
/***   notice is the year of the creation of the work.			   ***/
/***									   ***/
/*****************************************************************************/

#ifndef _LISTA_INCLUDED
#define _LISTA_INCLUDED

typedef struct  {
		int     size,end,el_size,free;
		char    *list;
		} LISTA;

OHANDLE UxListaMake();
char    *UxListaMakeEntry();
char    *UxListaEntry();
int     UxListaSize();
int     UxListaEnd();
char    *UxListaList();
void    UxListaFreeEntry();
void    UxListaFree();

#define lista_lookup(l)       type_lookup(l,LISTA)

#define lista_size(a)          (a->size)
#define lista_list(a)          (a->list)
#define lista_end(a)           (a->end)
#define lista_el_size(a)       (a->el_size)
#define lista_put_size(a,s)    (lista_size(a) = s)
#define lista_put_list(a,l)    (lista_list(a) = l)
#define lista_put_end(a,e)     (lista_end(a) = e)
#define lista_put_el_size(a,s) (lista_el_size(a) = s)
#define lista_free(a)          (a->free)
#define lista_put_free(a,f)    (lista_free(a) = f)

#endif  /* _LISTA_INCLUDED */
