/**********************************************************************/
/*
/* $Date: 91/10/26 00:27:21 $
/* $Revision: 1.2.33.1 $
/*
/**********************************************************************/


/*****************************************************************************/
/***									   ***/
/***		 Copyright (c) 1988, Visual Edge Software Ltd.		   ***/
/***									   ***/
/***   All rights reserved.  This notice is  intended  as  a  precaution   ***/
/***   against	inadvertent publication, and shall not be deemed to con-   ***/
/***   stitute an acknowledgment that publication has  occurred	 nor  to   ***/
/***   imply  any  waiver  of confidentiality.	The year included in the   ***/
/***   notice is the year of the creation of the work.			   ***/
/***									   ***/
/*****************************************************************************/

#ifndef _IS_FLG_INCLUDED
#define _IS_FLG_INCLUDED

#define   METHOD                42
#define   DYNAMIC_INSTANCE      33
#define   DYNAMIC_CLASS         34
#define   STATIC_CLASS          36
#define   FIXED_CLASS           30
#define   STATIC_INSTANCE       37
#define   FIXED_INSTANCE        31
#define   LISTS                 80
#define   SYMBOLS               20
#define   USER                  38
#define   OPERATION             32
#define   OPERATION_ID          35
#define   METHOD_ID             43
#define   PROP                  40
#define   PROP_ID               41
#define   FIXED_INSTANCE_PROP   44
#define   FIXED_CLASS_PROP      45
#define   FIXED_PROP            46
#define   DYNAMIC_INSTANCE_PROP 54
#define   DYNAMIC_CLASS_PROP    55
#define   DYNAMIC_PROP          52

#define is_method(o)            (oh_flag(o) == METHOD)
#define is_operation(o)         (oh_flag(o) == OPERATION)
#define is_operation_id(o)      (oh_flag(o) == OPERATION_ID)
#define is_method_id(o)         (oh_flag(o) == METHOD_ID)
#define is_static_class(o)      (oh_flag(o) == STATIC_CLASS)
#define is_fixed_class(o)       (oh_flag(o) == FIXED_CLASS)
#define is_dynamic_class(o)     (oh_flag(o) == DYNAMIC_CLASS)
#define is_class(o)             (is_static_class(o) || is_fixed_class(o) || \
				is_dynamic_class(o))
#define is_type(o)              (is_class(o))
#define is_static_instance(o)   (oh_flag(o) == STATIC_INSTANCE)
#define is_fixed_instance(o)    (oh_flag(o) == FIXED_INSTANCE)
#define is_dynamic_instance(o)  (oh_flag(o) == DYNAMIC_INSTANCE)
#define is_instance(o)          (is_static_instance(o) || is_fixed_instance(o) || \
				 is_dynamic_instance(o))
#define is_class_defined(o)     ((oh_type(o) >= 0) && is_class(o) && (oh_handle(o) >= 0))
#define is_type_defined(o)      (is_class_defined(o))
#define is_instance_defined(o)  ((oh_type(o) >= 0) && is_instance(o) && (oh_handle(o) >= 0))
#define is_fixed_instance_prop(o)  (oh_flag(o) == FIXED_INSTANCE_PROP)
#define is_fixed_class_prop(o)     (oh_flag(o) == FIXED_CLASS_PROP)
#define is_fixed_prop(o)           (oh_flag(o) == FIXED_PROP)

#endif   /* _IS_FLG_INCLUDED */
