/**********************************************************************/
/*
/* $Date: 91/10/25 23:40:42 $
/* $Revision: 1.4.33.1 $
/*
/**********************************************************************/

/*****************************************************************************/
/***                                                                       ***/
/***             Copyright (c) 1988, Visual Edge Software Ltd.             ***/
/***                                                                       ***/
/***   ALL RIGHTS RESERVED.  This notice is  intended  as  a  precaution   ***/
/***   against  inadvertent publication, and shall not be deemed to con-   ***/
/***   stitute an acknowledgment that publication has  occurred  nor  to   ***/
/***   imply  any  waiver  of confidentiality.  The year included in the   ***/
/***   notice is the year of the creation of the work.                     ***/
/***                                                                       ***/
/*****************************************************************************/

#ifndef _DSTRING_INCLUDED
#define _DSTRING_INCLUDED

#include <uxproto.h>

typedef struct
{	char	*str;
	int	size,
		blksize;
} dstring;


/*** private calls ***/

extern dstring	UxDcreate UXPROTO(( char *str ));
extern void	UxFree_dstring UXPROTO(( dstring *ds ));
extern void	UxAppend_to_dstring UXPROTO(( dstring *s, char *dat ));
extern void	UxSet_ds_block UXPROTO(( dstring *s, int size ));

/*** public declarations ***/

extern dstring		UxDefaultDstring;

#define UxEmptyDstring		{NULL, 0, 64}

#define dappend(s, dat)		(UxAppend_to_dstring(&(s), dat))
#define dconcat(s, ds)		(UxAppend_dstring(&(s), ds))
#define dsetblk(s, blk)		(UxSet_ds_block(&(s), blk))
#define dgetblk(s)		((s).blksize)
#define dfree(s)		(UxFree_dstring(&(s)))
#define dgetstr(s)		((s).str)
#define dnstr(s)		((s).str ? (s).str : "")
#define dlen(s)			(strlen(dnstr(s)))
#define dcopy(ds)		(dcreate(dgetstr(ds)))
#define dcreate(s)		(UxDcreate(s))

#endif /* _DSTRING_INCLUDED */
