! @(#)regrima.prg	16.1.1.1 (ES0-DMD) 06/19/01 14:53:30
! ++++++++++++++++++++++++++++++++++++++++++++++
!
! .PURPOSE
!  LINEAR REGRESSION ANALYSIS ON IMAGE PIXELS
!  THE RESULTING IMAGES CONTAIN THE SLOPE AND ZERO POINT
!  FOR EACH PIXEL.
!  REGRESSION EQUATION IS
!   Y = SLOPE*X + ZERO
!  WHERE X IS THE EXPOSURE TIME.
!  THE EXPOSURE TIME IS REQUESTED BY THE PROCEDURE
!
! .CALLING SEQUENCE
!  @@ REGR slope zero number-of-images
!
!    modified    870127, 901108   KB
!
! ---------------------------------------------
! PREPARE WORK SPACE
DEFINE/LOCAL I/I/1/1 0
DEFINE/LOCAL J/I/1/1 0
DEFINE/LOCAL N/R/1/1 0.
DEFINE/LOCAL X/R/1/1 0.
DEFINE/LOCAL X2/R/1/1 0.
DEFINE/LOCAL SX/R/1/1 0.
DEFINE/LOCAL SX2/R/1/1 0.
DEFINE/LOCAL DENOM/R/1/1 0.
DEFINE/LOCAL NAME/C/1/8 "          "
DEFINE/LOCAL NAME01/C/1/8 "          "
DEFINE/LOCAL NAME02/C/1/8 "          "
DEFINE/LOCAL NAME03/C/1/8 "          "
DEFINE/LOCAL NAME04/C/1/8 "          "
DEFINE/LOCAL NAME05/C/1/8 "          "
DEFINE/LOCAL NAME06/C/1/8 "          "
DEFINE/LOCAL NAME07/C/1/8 "          "
DEFINE/LOCAL NAME08/C/1/8 "          "
DEFINE/LOCAL NAME09/C/1/8 "          "
DEFINE/LOCAL NAME10/C/1/8 "          "
DEFINE/LOCAL NAME11/C/1/8 "          "
DEFINE/LOCAL NAME12/C/1/8 "          "
DEFINE/LOCAL TIME/R/1/12 0.,0.,0.,0.,0.,0.,0.,0.,0.,0.
SET/FORMAT I2
! 
! iteration on input images
DO I = 1 'P3'
  INQUIRE/KEYW NAME'I' Enter\image\name:
  INQUIRE/KEYW X Enter\exp.time\for\'NAME{I}':
  WRITE/KEYW   TIME/R/'I'/1 'X'
ENDDO
COMPUTE/PIXEL &a = 'NAME01'*0.
COPY/II       &a &b
DO I = 1 'P3'
  WRITE/KEYW NAME/C/1/8 'NAME{I}'
  N    = N + 1
  WRITE/KEYW X/R/1/1 'TIME({I})'
  X2  = X * X
  SX  = SX + X
  SX2 = SX2 + X2
  COMPUTE/PIXEL &a = &a+'NAME'
  COMPUTE/PIXEL &b = &b+'X'*'NAME'
ENDDO
! 
! final results
IF N .EQ. 0. THEN
  WRITE/OUT No\input\data\!!!!!
ELSE
  DENOM = SX * SX
  DENOM = DENOM / N
  DENOM = SX2 - DENOM
  X     = SX / N
  COMPUTE/PIXEL 'P1' = (&b-'X'*&a)/'DENOM'
  DENOM = N * DENOM
  COMPUTE/PIXEL 'P2' = (&a*'SX2'-'SX'*&b)/'DENOM'
ENDIF
