/* @(#)sortrow.c	16.1.1.1 (ESO-DMD) 06/19/01 14:52:11 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge, 
  MA 02139, USA.
 
  Correspondence concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/* Program : sortcol.c                      */
/* Author  : P. Ballester   ESO - Garching  */
/* Date    : 29.04.91                       */

#include  <midas_def.h>
#define   ipos(col, row,siz)    row * siz + col

main()
{

      char   inpframe[TEXT_LEN+1], outframe[TEXT_LEN+1];
      char   *kunit;
      int    naxis, npix[2], actvals, imno_inp, imno_out;
      float  *pntr_inp, *pntr_out;
      char   ident[TEXT_LEN+1], cunit[16*2 + 1];
      double start[2], step[2];

      int    nbrow, nbcol, row, col, flag, pos, posmin, posmax;
      float  value, ratio, thres=20.;
      char   text[TEXT_LEN+1], time[TEXT_LEN+1];

      SCSPRO("sortcol");

      SCKGETC("IN_A", 1, 60, &actvals, inpframe);
      SCKGETC("IN_B", 1, 60, &actvals, outframe);

      SCIGET (inpframe, D_R4_FORMAT, F_I_MODE, F_IMA_TYPE, 2,
              &naxis, npix, start, step, ident, cunit, (char **)&pntr_inp,
              &imno_inp);


      SCIPUT (outframe, D_R4_FORMAT, F_IO_MODE, F_IMA_TYPE, naxis,
              npix, start, step, ident, cunit, (char **)&pntr_out, &imno_out);

      nbrow = npix[1];
      nbcol = npix[0];

      for (row=0; row<nbrow; row++) {

        ratio = 100. * (row+1) / nbrow;
        if (ratio >= thres) {
           OSY_ASCTIM(time);
           sprintf (text," %d%% done ...",(int) thres);
           strcat  (time,text);
           SCTPUT(time);
           thres += 20.;
	 }

        /* Copy column into output frame */
        posmin = ipos(0,row,nbcol);
        posmax = ipos(nbcol, row, nbcol);

        for (pos=posmin; pos<posmax; pos++)
                 pntr_out[pos] = pntr_inp[pos];

        sort(nbcol,&pntr_out[posmin-1]);

      }
        SCSEPI();
}


/*  Sorting algorithm:      Heapsort method                      */
/*  From: Numerical Recipes, Cambridge University Press, p. 226  */

sort(n,ra)
int n;
float ra[];
{
	int l,j,ir,i;
	float rra;

	l=(n >> 1)+1;
	ir=n;
	for (;;) {
		if (l > 1)
			rra=ra[--l];
		else {
			rra=ra[ir];
			ra[ir]=ra[1];
			if (--ir == 1) {
				ra[1]=rra;
				return;
			}
		}
		i=l;
		j=l << 1;
		while (j <= ir) {
			if (j < ir && ra[j] < ra[j+1]) ++j;
			if (rra < ra[j]) {
				ra[i]=ra[j];
				j += (i=j);
			}
			else j=ir+1;
		}
		ra[i]=rra;
	}
}



