C @(#)triang.for	16.1.1.1 (ES0-DMD) 06/19/01 14:51:43
C===========================================================================
C Copyright (C) 1995 European Southern Observatory (ESO)
C
C This program is free software; you can redistribute it and/or 
C modify it under the terms of the GNU General Public License as 
C published by the Free Software Foundation; either version 2 of 
C the License, or (at your option) any later version.
C
C This program is distributed in the hope that it will be useful,
C but WITHOUT ANY WARRANTY; without even the implied warranty of
C MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C GNU General Public License for more details.
C
C You should have received a copy of the GNU General Public 
C License along with this program; if not, write to the Free 
C Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
C MA 02139, USA.
C
C Corresponding concerning ESO-MIDAS should be addressed as follows:
C	Internet e-mail: midas@eso.org
C	Postal address: European Southern Observatory
C			Data Management Division 
C			Karl-Schwarzschild-Strasse 2
C			D 85748 Garching bei Muenchen 
C			GERMANY
C===========================================================================
C
      SUBROUTINE TRIANG(INDEP,X,NP,PARAM,Y1,DERIV)                              
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++                  
C.COPYRIGHT: Copyright (c) 1987 European Southern Observatory,                  
C                                         all rights reserved                   
C                                                                               
C.VERSION: 1.0  ESO-FORTRAN Conversion, AA  18:01 - 21 DEC 1987                 
C                                                                               
C.LANGUAGE: F77+ESOext                                                          
C                                                                               
C.AUTHOR: J.D.PONZ                                                              
C                                                                               
C--------------------------------------------------------------                 
C***************************************************                            
C                                                                               
C      IMPLICIT NONE                                                            
C   FIT WITH A TRIANGULAR FUNCTION                                              
C                                                                               
C***************************************************                            
C                                                                               
C   Author: O.-G. Richter, ESO Garching                                         
C                                                                               
   
      INTEGER NP,INDEP
      REAL X(INDEP)                                                        
      DOUBLE PRECISION Y1,PARAM(NP),DERIV(NP),A,B,C,D,E                         
C                                                                               
      DERIV(1) = 0.D0                                                           
      DERIV(2) = 0.D0                                                           
      DERIV(3) = 0.D0                                                           
      A      = X(1) - PARAM(2)                                                  
      B      = DABS(A)                                                          
      C      = 2.0D0*PARAM(3)                                                   
      IF (B.GE.C) RETURN                                                        
      DERIV(1) = 1.0D0                                                          
      IF (X(1).EQ.PARAM(2)) RETURN                                              
      D      = B/C                                                              
      E      = 1.0D0 - D                                                        
      Y1     = E*PARAM(1)                                                       
      DERIV(1) = E                                                              
      DERIV(2) = -PARAM(1)*D/A                                                  
      DERIV(3) = PARAM(1)*D/PARAM(3)                                            
      RETURN                                                                    
                                                                                
      END                                                                       
