! @(#)verify55.prg	16.1.1.1 (ESO-DMD) 06/19/01 15:44:02
! ++++++++++++++++++++++++++++++++++++++++++++++++++++++
!
!  MIDAS procedure verify55.prg  to verify MIDAS commands
!  K. Banse     980928, 990210
!
!  use as @@ verify55 ffffffff             with f = 1 or 0 (on/off)
!
! ++++++++++++++++++++++++++++++++++++++++++++++++++++++
!
define/par p1 1111111 n "Enter control flags for entries: "
!
define/local loop/i/1/1 0
define/local rval/r/1/1 0. ? +lower
define/local ival/i/1/5 0 all +lower
define/local rcorr/r/1/20 0. all +lower
define/local icorr/i/1/20 0 all +lower
define/local errsum/i/1/1 0 ? +lower
define/local ccc/c/1/8 00000000
define/local scale/i/1/1 1 ? +lower
define/local seconds/i/1/2 0,0? +lower
!
delete/temp				!get rid of old temporary files
seconds(1) = m$secs()
write/key sizez/i/1/5 600,600,0,0,0
write/key dispyes/i/1/2 0,0
write/key stop/i/1/1 0
! 
write/key ccc {p1}
set/format i1
do loop = 1 2				!currently only 2 entries
   if ccc({loop}:{loop}) .eq. "1" @@ verify55,000{loop}
enddo
! 
seconds(2) = m$secs()
ival = seconds(2)-seconds(1)
!
write/out +------------------------------------------+
write/out procedure verify55.prg:
write/out Total time elapsed = {ival} seconds.
if errsum .gt. 0 then
   write/out We got problems - check the MIDAS logfile !!!
   stop = 1
else
   write/out All tests o.k. - you deserve a coffee now...
endif
write/out +------------------------------------------+
!
!  here the different sub-procedures
!
entry 0001
!
write/out test of CREATE/DISPLAY 
write/out "----------------------"
!
reset/display  >Null
write/out create a display window in RGB mode
write/out initialize/display  p5=rgb
initialize/display  p5=rgb
create/display 7 900,512,10,300 
dispyes(1) = 1                          !mark that we have display + graphic
dispyes(2) = 1
display/lut off
!
entry 0002
!
write/out test of LOAD/IMAGE
write/out "------------------"
!
if m$exist("veria.bdf") .eq. 1 then
   write/out "copy last image as red, green and blue component of an RGB image"
else
   write/out "create image as red, green and blue component of an RGB image"
   @@ creamask                     !create image arti.bdf
   !
   rebin/linear arti &z .1,.25
   filter/smooth &z &b 2,2,0. >Null
   !
   create/ima &a 2,{&b,npix(1)},{&b,npix(2)} ? poly 0.,0.7
   replace/ima &b veria 0.09,>=&a,0. >Null
endif
! 
compute/image &red = veria
compute/image &green = veria
compute/image &blue = veria
write/out and use them for the different planes
write/out
! 
if dispyes(2) .eq. 1 then
   write/out "load only into channel 0 (red)"
   load/ima &red 0 scale=1,1
   write/out "load only into channel 1 (green)"
   clear/channel 0
   load/ima &green 1 scale=1,1
   write/out "load only into channel 2 (blue)"
   clear/channel 1
   load/ima &blue 2 scale=1,1
   !
   write/out "now load red + green"
   clear/channel 2
   load/ima &red 0 
   load/ima &green 1
   write/out "now load red + blue"
   clear/channel 1
   load/ima &blue 2
   write/out "now load green + blue"
   clear/channel 0
   load/ima &green 1 
   load/ima &blue 2
   write/out "now load all colour planes, so final image is grayscale..."
   load/ima &red 0 
endif
! 
