#! /bin/sh 
# @(#)drs_config.sh	14.5 (ESO-IPG) 05/12/00 09:55:08
#
#  Assign the necessary logical names for Midas
#  needed for the Unix command `drs'
#  Klaus Banse ESO - DMD                000503
#
#  if root directory for Midas is NOT `/midas'
#  and the Midas version is NOT 99NOV
#  then, the env. variables MIDASHOME and MIDVERS have to be set before ...!
# 
#**************************************************************************
# Configure Here:
# ---------------
# Modify the default values of MIDASHOME0 and MIDVERS0
# accordingly to your site.
#
# Environment variables MIDASHOME and MIDVERS overwrite these defaults.
#
# Done automaticaly by option "8- setup MIDAS" in the "config" script.
#
MIDASHOME0=/midas
MIDVERS0=99NOV
#
# END of Configure Here
#**************************************************************************

#
# If MIDASHOME variable not defined then set to default.
#
if [ -z "$MIDASHOME" ]; then
  if [ -z "$MIDASHOME0" ]; then
    echo "inmidas - ERROR: Environment variable MIDASHOME not defined" >&1
    echo "          and no default MIDASHOME0 found in this script. EXIT." >&1
    exit 1
  else
    MIDASHOME="$MIDASHOME0"; export MIDASHOME
  fi
fi

#
# If MIDVERS variable not defined then set to default.
#
if [ -z "$MIDVERS" ]; then
  if [ -z "$MIDVERS0" ]; then
    echo "inmidas - ERROR: Environment variable MIDVERS not defined" >&2
    echo "          and no default MIDVERS0 found in this script. EXIT." >&2
    exit 1
  else
    MIDVERS="$MIDVERS0"; export MIDVERS
  fi
fi

#
# Check access to directories and files
#
if [ ! -d $MIDASHOME ]; then
  echo "${MIDASHOME}: not such directory."
  echo "Call your MIDAS operator. EXIT."
  exit 1
fi
if [ ! -d $MIDASHOME/$MIDVERS ]; then
  echo "$MIDASHOME/${MIDVERS}: not such directory."
  echo "Call your MIDAS operator. EXIT."
  exit 1
fi

#
# if necessary create MIDAS work directory
#
#if [ -z "$MID_WORK" ]; then
#  MID_WORK=$HOME/midwork/ ; export MID_WORK
#fi

#
# if last char. of MID_WORK != '/'  append a '/'
#
#if [ `expr $MID_WORK : '.*\(.\)'` != '/' ]; then
#  MID_WORK=$MID_WORK/ ; export MID_WORK
#fi

#if [ ! -d $MID_WORK ]; then
#  mkdir `expr $MID_WORK : '\(.*\).'`         #use MID_WORK except last char.
#  if [ $? != 0 ]; then
#    echo Could not create directory `expr $MID_WORK : '\(.*\).'`
#    exit 1
# fi
#fi

#
#
# get all the variables (logical names)
#
if [ -f $MIDASHOME/$MIDVERS/monit/midlogs.sh ]; then
  . $MIDASHOME/$MIDVERS/monit/midlogs.sh
else
  echo "$MIDASHOME/$MIDVERS/monit/midlogs.sh not such file."
  echo "Call your MIDAS operator. EXIT."
  exit 1
fi

#
# Catch any possible interrupt and remove the lock file
#
trap "exit 1" 1 3 15

#
# Set PATH for shared libraries
#
os=`uname`
case "$os" in
    "SunOS"|"Linux")
        if [ -z "$LD_LIBRARY_PATH" ] ; then
          LD_LIBRARY_PATH=$MIDASHOME/$MIDVERS/lib
        else
          LD_LIBRARY_PATH=$MIDASHOME/$MIDVERS/lib:$LD_LIBRARY_PATH
        fi
        export LD_LIBRARY_PATH
        ;;
    "HP-UX")
        if [ -z "$SHLIB_PATH" ] ; then
          SHLIB_PATH=$MIDASHOME/$MIDVERS/lib
        else
          SHLIB_PATH=$MIDASHOME/$MIDVERS/lib:$SHLIB_PATH
        fi
        export SHLIB_PATH
        ;;
     *)
        ;;
esac

# run QREQA
#
$MID_MONIT/qreqa.exe $*

exit 0
