:
#! /bin/sh
# @(#)ftoc_params.sh	16.1.1.1 (ESO-IPG) 06/19/01 15:41:43
# .COPYRIGHT: Copyright (c) 1988 European Southern Observatory,
#                                         all rights reserved
# .TYPE           command
# .NAME           ftoc_params.sh
# .LANGUAGE       shell script
# .ENVIRONMENT    Unix Systems. Executable under SHELL and C-SHELL
# .COMMENTS  	  Test for Fortran to C interface     
# .REMARKS
# .AUTHOR         Carlos Guirao
# .VERSION 1.1    02-Jan-1991:	Implementation
# .VERSION 1.2    04-Oct-1991:	eval has been deleted because apollo complains.
#				but could also be used within quotes.


# <dirname> emulated with <sed>
#   DIR=`dirname $0`
DIR=`echo $0 | sed -e 's/[^\/]*$//' -e 's/^$/./' -e 's/\/$//'`

if [ -f $DIR/ftoc_fx.exe -a -s $DIR/ftoc_fx.exe ] ; then
        $DIR/ftoc_fx.exe >/dev/null 2>&1
        if [ $? -eq "0" ] ; then
                FTOC_PARAM="fx"
        fi
fi

if [ -f $DIR/ftoc_sun.exe -a -s $DIR/ftoc_sun.exe ] ; then
        $DIR/ftoc_sun.exe >/dev/null 2>&1
        if [ $? -eq "0" ] ; then
                FTOC_PARAM="sun"
        fi
fi

if [ -f $DIR/ftoc_hp.exe -a -s $DIR/ftoc_hp.exe ] ; then
        $DIR/ftoc_hp.exe >/dev/null 2>&1
        if [ $? -eq "0" ] ; then
                FTOC_PARAM="hp"
        fi
fi

if [ -f $DIR/ftoc_hpr.exe -a -s $DIR/ftoc_hpr.exe ] ; then
        $DIR/ftoc_hpr.exe >/dev/null 2>&1
        if [ $? -eq "0" ] ; then
                FTOC_PARAM="hpr"
        fi
fi

if [ -f $DIR/ftoc_hpn.exe -a -s $DIR/ftoc_hpn.exe ] ; then
        $DIR/ftoc_hpn.exe >/dev/null 2>&1
        if [ $? -eq "0" ] ; then
                FTOC_PARAM="hpn"
        fi
fi

if [ -f $DIR/ftoc_pc.exe -a -s $DIR/ftoc_pc.exe ] ; then
        $DIR/ftoc_pc.exe >/dev/null 2>&1
        if [ $? -eq "0" ] ; then
                FTOC_PARAM="pc"
        fi
fi

if [ -f $DIR/ftoc_osf.exe -a -s $DIR/ftoc_osf.exe ] ; then
        $DIR/ftoc_osf.exe >/dev/null 2>&1
        if [ $? -eq "0" ] ; then
                FTOC_PARAM="osf"
        fi
fi

if [ -f $DIR/ftoc_osf2.exe -a -s $DIR/ftoc_osf2.exe ] ; then
        $DIR/ftoc_osf2.exe >/dev/null 2>&1
        if [ $? -eq "0" ] ; then
                FTOC_PARAM="osf2"
        fi
fi

if [ -f $DIR/ftoc_titan.exe -a -s $DIR/ftoc_titan.exe ] ; then
        $DIR/ftoc_titan.exe >/dev/null 2>&1
        if [ $? -eq "0" ] ; then
                FTOC_PARAM="titan"
        fi
fi

if [ -f $DIR/ftoc_axp.exe -a -s $DIR/ftoc_axp.exe ] ; then
        $DIR/ftoc_axp.exe >/dev/null 2>&1
        if [ $? -eq "0" ] ; then
                FTOC_PARAM="axp"
        fi
fi

if [ "$FTOC_PARAM" = "sun"   -o "$FTOC_PARAM" = "hp" \
  -o "$FTOC_PARAM" = "fx"    -o "$FTOC_PARAM" = "hpr" \
  -o "$FTOC_PARAM" = "titan" -o "$FTOC_PARAM" = "hpn" \
  -o "$FTOC_PARAM" = "pc"    -o "$FTOC_PARAM" = "osf" \
  -o "$FTOC_PARAM" = "osf2"  -o "$FTOC_PARAM" = "axp" ]; then 
    echo ftoc_${FTOC_PARAM}.h
else
    echo "" >&2
    echo "#################################################################" >&2
    echo "# ftoc_params: ERROR. Unexpected Fortran to C interface      	#" >&2
    echo "# Unable to set your <ftoc.h> file                           	#" >&2
    echo "# MIDAS installation will fail if you do not set your own    	#" >&2
    echo "# <ftoc.h> in \$MIDASHOME/\$MIDVERS/incl                     	# ">&2
    echo "#                                                            	#" >&2
    echo "# Please report this to ESO-IPG.                             	#" >&2
    echo "#         EARN:MIDAS@DGAESO51                                	#" >&2
    echo "#         SPAN:ESO::MIDAS                                 	#" >&2
    echo "#         INTERNET:midas@eso.org                             	#" >&2
    echo "#################################################################" >&2
    echo "" >&2
    exit 1
fi
