! @(#)necopt.prg	16.1.1.1 (ES0-DMD) 06/19/01 15:35:47
! @(#)necopt.prg	16.1.1.1  (ESO)  06/19/01  15:35:47
! +++++++++++++++++++++++++++++++++++++++++++++++++
!
! .IDENTIFICATION
!
! ECHELLE PROCEDURE : ECHOPT.PRG
!  Michele Peron	version 1.0   sep91
!  Sebastian Wolf	version 2.0   apr99
!
! .PURPOSE
!
! execute the command : level 1
! EXTR/OPT in out slit,ord1,ord2 ron,g,sigma table coeffs calcw
!
! .RETURN	-1 on error, 0 on successful return.
!
! .HISTORY
! 1999.04.08-SW	Compute the initial variance frame from
!		input frame, RON and GAIN. Here GAIN means the
!		inverse gain-factor, i.e. CONAD
! 1999.05.17-SW	Do an optimal extraction using the weights of an previous
!		call to EXTRACT/OPTIMAL. This may be done by setting P7=NO
!		This is necessary for flatfielding optimal extracted science
!		spectra.
! 1999.06.11-SW	Average the weights for each order and store in wbin.bdf
! 1999.09.08-SW	The variance of the input frame and the variance of the
!		extracted data will be determined in any case of P7
!		P7 may accept the name of the weight map (e.g. Y,name).
!
! --------------------------------------------------
!
DEFINE/PARAM P1 ? IMAGE "Enter input image:"
DEFINE/PARAM P2 ? IMAGE "Enter output extracted orders:"
DEFINE/PARAM P3 ? NUMBER "Enter extraction pars(SLIT,ORD1,ORD2):"
DEFINE/PARAM P4 {RON},{GAIN},{EXTSIGMA}  NUMBER   "Enter extraction pars (RON,G,SIGMA):"
DEFINE/PARAM P5 {ORDTAB} TABLE "Enter auxiliary table:"
DEFINE/PARAM P6 COEFF CHAR "Enter coeffs with order position:"
DEFINE/PARAM P7 YES CHAR "Enter YES determine weights, NO apply weights:"
!
WRITE/KEYW IN_A/C/1/60   'P1'
WRITE/KEYW OUT_A/C/1/60  'P2'
WRITE/KEYW OUT_B/C/1/60  " " ALL
WRITE/KEYW OUTPUTC/C/1/60  variance.bdf
WRITE/KEYW INPUTI/I/2/3  0,0
WRITE/KEYW INPUTI/I/1/3  'P3'
WRITE/KEYW INPUTR/R/1/3  'P4'
WRITE/KEYW IN_B/C/1/60   'P5'
WRITE/KEYW INPUTC/C/1/8  'P6'

DEFINE/LOCAL RON/R/1/1 0.0
!
! compute the variance frame. The input frame is assumed to be only background
! subtracted (de-biased)
! The variance frame is in units of [ADU^2]:
!   V_ij = (RON / CONAD)^2 + |IN_ij|/CONAD ;
!  [RON] = e-, [CONAD] = e-/ADU, [GAIN] = ADU/e-
!
if INPUTR(2) .gt. 0.0 then
  RON = INPUTR(1) / INPUTR(2)	!RON in ADU
  RON = RON * RON			!RON^2 in ADU
  COMPUTE/IMAGE {OUTPUTC} = {RON} + ABS({P1}) / {INPUTR(2)}
else
  WRITE/OUT "Error bad CONAD to determine variance frame!"
  RETURN -1
endif

INPUTI(4) = M$INDEX(p7,",") + 1	!Check for the name of the weight map
IF INPUTI(4) .GT. 1 THEN
  OUT_B = P7({INPUTI(4)}:)
ELSE
  OUT_B = "weight.bdf"
ENDIF

INPUTI(4) = 0			!Perform an optimal extraction with the
				!weights of a previous call to EXTRACT/OPTIMAL
				!(used for flatfields) if INPUTI(4) == 0
if P7(1:1) .eq. "Y" .OR. P7(1:1) .eq. "y" INPUTI(4) = 1
				!otherwise determine the weights.

WRITE/KEYW OUT_A/C/1/60  'P2'



RUN STD_EXE:NECOPT
write/out "Optimal extraction done."

if INPUTI(4) .eq. 1 then
  DEFINE/LOCAL ISTP/i/1/1 1
  ISTP = M$VALUE({out_b},NPIX(2)) / M$VALUE({p2},NPIX(2))
  COPY/DD {p2} *,3 {out_b}
  REBIN/LINEAR {out_b} wbin 1,{ISTP} 0,0
  COPY/DD {p2} START wbin START
  COPY/DD {p2} STEP wbin STEP
endif
!
RETURN 0

