! @(#)lnhough.prg	16.1.1.1 (ES0-DMD) 06/19/01 15:38:26
!+++++++++++++++++++++++++++++++++++++++++++++++++++++++
!.COPYRIGHT   (C) 1993 European Southern Observatory
!.IDENT       lnhough.prg
!.AUTHORS     Pascal Ballester (ESO/Garching)
!.KEYWORDS    Spectroscopy, Long-Slit
!.PURPOSE     Tutorial for context Long . PB 12.02.1993
!.VERSION     1.0  Command Creation  09-APR-1993
!-------------------------------------------------------
!
CROSSREF wdisp wcent ystart line cat  mode  range
!
define/param P1  {AVDISP}  ?    "Dispersion, tolerance, accuracy:"
define/param P2  {WCENTER} ?    "Central wav., tolerance, accuracy:"
define/param P3  {YSTART}  NUM    "Reference row:"
define/param P4  {LINTAB}  TAB    "Line table:"
define/param P5  {LINCAT}  TAB    "Line catalog:"
define/param P6   LINEAR   CHAR   "Mode:"
define/param P7   2.5      NUM    "Range:"
define/param P8   K        CHAR   "Keep/Visualise result (K/N/V)"

define/local  wcent/D/1/3  0.,0.,0.
define/local  wdisp/D/1/3  0.,0.,0.
define/local  error/I/1/1  1
define/local   DIM/I/1/1   0

write/key     wcent {P2}
write/key     wdisp {P1}

if wdisp(2) .eq. 0.  wdisp(2) = 15  ! Tolerance in percent
if wdisp(3) .eq. 0   wdisp(3) = 1   ! Accuracy in percent
if wcent(2) .eq. 0   wcent(2) = 50  ! Tolerance 100 pixels
if wcent(3) .eq. 0   wcent(3) = 0.2 ! Accuracy in pixels

SET/FORMAT  F8.6
WRITE/OUT "Initial values:"
WRITE/OUT " Central Wav.  : {wcent(1)} +/- {wcent(2)} pix, {wcent(3)} pix"
WRITE/OUT " Average disp. : {wdisp(1)} +/- {wdisp(2)} %, {wdisp(3)} %"

!wdisp(1) = wdisp(1)
wdisp(2) = wdisp(2)/100 
wdisp(3) = wdisp(3)/100
!
define/local nblines/I/1/1 0
define/local conf/R/1/1    0.
!
@s lnident,seline
nblines = outputi(1)
!
COPY/TABLE   {LINTAB} &l
SELECT/TABLE {LINTAB} ALL
CREATE/COLUMN &l  :WAVEC R*8  F10.3


DEFINE/LOCAL  XC/D/1/1     0.
DEFINE/LOCAL  XMEAN/R/1/1  0.
define/local RANGE/R/1/1  0.
define/local FACTOR/R/1/1 0.
define/local OFFSET/R/1/1 0.

RANGE  = {P7}*STEP(1)

! Dispersion relation is relative to central positions of the group
! of lines in pixel space.
STAT/TABLE {LINTAB} :X

XMEAN = (OUTPUTR(3) - START(1))/STEP(1) + 1.
XC    = NPIX(1)/2. + 0.5

FACTOR = XMEAN
OFFSET = (XMEAN - XC)*WDISP(1)

WRITE/OUT "XCENTER = {XC}  XMEAN = {XMEAN} OFFSET={OFFSET}"

WCENT(1) = WCENT(1) + OFFSET

SET/FORMAT F20.10
COMPUTE/TABLE  &l  :XMEAN  =  (:X - ({START(1)}))/{STEP(1)}+1.-{FACTOR}
COMPUTE/TABLE  &l  :XNORM  =  :XMEAN/{FACTOR}

define/local wlim/D/1/2  0.,0.
IF LINCAT(1:1) .NE. "@" COPY/TABLE    {LINCAT}   &c

define/local hg_start/D/1/3 0.,0.,0.  ? +lower
define/local hg_step/D/1/3  0.,0.,0.  ? +lower
define/local hg_npix/I/1/3  0,0,0     ? +lower

IF P6(1:1) .EQ. "L"  THEN
  hg_start(1) = wdisp(1) * (1.-wdisp(2))
  hg_step(1)  = wdisp(1) * wdisp(3)
  hg_npix(1)  = 2.*wdisp(2)/wdisp(3)

  hg_start(2) = wcent(1) - wcent(2)*wdisp(1)
  hg_step(2)  = wcent(3)*wdisp(1)
  hg_npix(2)  = 2.*wcent(2)/wcent(3)

  DIM = 2
  WRITE/KEY INPUTC/C/1/10  :XMEAN
ENDIF

IF P6(1:1) .EQ. "1" THEN
      DIM = 1
      hg_start(1) = wcent(1) - wcent(2)*wdisp(1)
      hg_step(1)  = wcent(3)*wdisp(1)
      hg_npix(1)  = 2.*wcent(2)/wcent(3)
      INPUTR(2) = WDISP(1)
      WRITE/KEY INPUTC/C/1/10 :XMEAN
ENDIF

IF P6(1:1) .EQ. "N" THEN

      DIM = 2
      INPUTR(2) = WDISP(1)*FACTOR
      WRITE/KEY INPUTC/C/1/10  :XNORM

      hg_start(1) = -0.30
      hg_step(1)  = M$ABS(hg_start(1))/100.
      hg_npix(1)  = 200

      hg_start(2) = wcent(1) - wcent(2)*wdisp(1)
      hg_step(2)  = wcent(3)*wdisp(1)
      hg_npix(2)  = 2.*wcent(2)/wcent(3)

ENDIF

IF P6(1:1) .EQ. "3" THEN

      DIM = 3
      INPUTR(2) = WDISP(1)*FACTOR
      RANGE     = RANGE/FACTOR
      WRITE/KEY INPUTC/C/1/10  :XNORM

      hg_start(1) = inputr(2) * (1.-wdisp(2))
      hg_step(1)  = inputr(2) * wdisp(3)
      hg_npix(1)  = 2.*wdisp(2)/wdisp(3)

      hg_start(2) = wcent(1) - wcent(2)*wdisp(1)
      hg_step(2)  = wcent(3)*wdisp(1)
      hg_npix(2)  = 2.*wcent(2)/wcent(3)

      hg_start(3) = -0.2
      hg_step(3)  = 0.01
      hg_npix(3)  = 40

ENDIF

IF DIM .EQ. 0  THEN
   WRITE/OUT "Wrong Method : {P6}"
   RETURN/EXIT
ENDIF

WRITE/KEY INPUTC/C/10/10  :WAVE

write/key in_a   middumml.tbl
IF LINCAT(1:1) .NE. "@" THEN
   write/key in_b   middummc.tbl
ELSE
   write/key in_b   {LINCAT}
ENDIF
IF P8(1:1) .NE. "N" THEN
    write/key out_a  middummh.bdf
ELSE
    write/key out_a @@@
ENDIF
write/key out_b  {P6}

@s lnhough,bounds

INPUTI(4) = DIM
INPUTR(4) = RANGE
copy/key hg_npix/I/1/3  inputi/I/1/3
copy/key hg_start/D/1/3 inputd/D/1/3 
copy/key hg_step/D/1/3  INPUTD/D/4/3

RUN STD_EXE:lnhough.exe

define/local panmax/I/1/1 {OUTPUTI(5)}

conf = (outputr(1)/nblines)*100.
if conf .gt. 100. conf = 100.

IF P8(1:1) .EQ. "V"  THEN
   EXTRACT/IMA &y = &h[<,<,@{PANMAX}:>,>,@{PANMAX}]
   LOAD &y SCALE=5,1
ENDIF

define/local staep/D/1/3  0.,0.,0.

IF P6(1:1) .EQ. "1" THEN
   staep(1) = HG_START(1) + (OUTPUTI(3)-1)*HG_STEP(1)
   WCENTER = staep(1)  - OFFSET
ENDIF

IF P6(1:1) .EQ. "L" .OR. P6(1:1) .EQ. "N" THEN

staep(1) = HG_START(1) + (OUTPUTI(3)-1)*HG_STEP(1)
staep(2) = HG_START(2) + (OUTPUTI(4)-1)*HG_STEP(2)

IF P6(1:1) .EQ. "L" THEN
    COMPUTE/TABLE &l :WAVEC = {STAEP(2)}+{STAEP(1)}*:XMEAN
    AVDISP   = staep(1)
    BETA     = 0.
ENDIF

IF P6(1:1) .EQ. "N" THEN
    COMPUTE/TABLE &l :WAVEC = {STAEP(2)}+{WDISP(1)}*{FACTOR}*:XNORM+{STAEP(1)}*:XNORM*:XNORM
    BETA     = staep(1)
ENDIF

WCENTER  = staep(2) - OFFSET

ENDIF

IF P6(1:1) .EQ. "3" THEN

staep(1) = HG_START(1) + (OUTPUTI(3)-1)*HG_STEP(1)
staep(2) = HG_START(2) + (OUTPUTI(4)-1)*HG_STEP(2)
staep(3) = HG_START(3) + (OUTPUTI(5)-1)*HG_STEP(3)

COMPUTE/TABLE &l :WAVEC = {STAEP(2)}+{STAEP(1)}*:XNORM+{STAEP(3)}*:XNORM*:XNORM

AVDISP   = staep(1)/FACTOR
WCENTER  = staep(2) - OFFSET
BETA     = staep(3)

ENDIF


SET/FORMAT F12.5
WRITE/OUT "Confidence Level: {CONF} %"
WRITE/OUT "Set values WCENTER = {WCENTER} and AVDISP = {AVDISP} and BETA={BETA}"

! Now Updates column :WAVEC in line.tbl

REGRES/POLY  &l  :WAVEC  :X  2
COPY/KK OUTPUTD/D/1/3  DISPCOE/D/1/3
SAVE/REGRESS {LINTAB}  HREG

OUTPUTR(1) = CONF

RETURN


ENTRY BOUNDS


define/local dim/I/1/1 0
define/local hgs/D/1/1 0.

do dim = 1 3
   hgs = hg_step({dim})
   if hgs .lt. 0. then
      hg_start({dim}) = hg_start({dim}) + (hg_npix({dim})-1.)*hgs
      hg_step({dim}) = hgs*(-1.)
   endif
enddo

return





