! @(#)lnaver.prg	16.1.1.1 (ES0-DMD) 06/19/01 15:38:25
! @(#)lnaver.prg	16.1.1.1  (ESO)  06/19/01  15:38:25
!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!.COPYRIGHT   (C) 1993 European Southern Observatory
!.IDENT       lnaver.prg
!.AUTHORS     Pascal Ballester (ESO/Garching) 
!             Cristian Levin   (ESO/La Silla)
!.KEYWORDS    Spectroscopy, Long-Slit
!.PURPOSE     
!      Extract spectrum from a CCD frame using  row averages
!      Command:
!         EXTRACT/AVERAGE in out  [obj]  [sky]  [mtd]
!
!.VERSION     1.0  Package Creation            17-MAR-1993  
!----------------------------------------------------------------------
!
CROSSREF in  out  obj  sky  mtd 
!
define/param p1 ?                         I "Enter input frame        : "
define/param p2 ?                         I "Enter output frame       : "
define/param p3 {OBJECT(1)},{OBJECT(2)}   NUMB "Enter object coordinates : "
define/param p4 {LOWSKY(1)},{LOWSKY(2)},{UPPSKY(1)},{UPPSKY(2)} NUMB "Sky: "
define/param p5 {EXTMTD}   CHAR  "Extraction method:"
!
DEFINE/MAXPAR  5
!
def/loc cobj/i/1/2 'p3'
def/loc csky/i/1/4 'p4'
def/loc error/I/1/1  0

VERIFY/LONG  {P1} IMA
SET/FORMAT   I1

COPY/KEYW  COBJ/I/1/2  OBJECT/I/1/2
COPY/KEYW  CSKY/I/1/2  LOWSKY/I/1/2
COPY/KEYW  CSKY/I/3/2  UPPSKY/I/1/2
SET/LONG  EXTMTD={P5}

IF EXTMTD(1:1) .NE. "L" .AND. EXTMTD(1:1) .NE. "A" THEN
   WRITE/OUT "Error: Wrong parameter EXTMTD = {EXTMTD}"
   WRITE/OUT "       Possible values are LINEAR and AVERAGE"
   RETURN/EXIT
ENDIF

def/loc np/I/1/1    {{P1},NPIX(2)}

if cobj(1) .lt. 1 .or.  cobj(1) .gt. np  error = 1
if cobj(2) .lt. 1 .or.  cobj(2) .gt. np  error = 1
if csky(1) .lt. 1 .or.  csky(1) .gt. np  error = 1
if csky(2) .lt. 1 .or.  csky(2) .gt. np  error = 1
if csky(3) .lt. 1 .or.  csky(3) .gt. np  error = 1
if csky(4) .lt. 1 .or.  csky(4) .gt. np  error = 1

if error .ne. 0 then
   WRITE/OUT "Error :  Invalid object or sky limits "
   WRITE/OUT "         (session keywords OBJECT, LOWSKY, UPPSKY)"
   WRITE/OUT "  Valid range is     : 1,{np}"
   WRITE/OUT "  Present values are : OBJECT = {OBJECT(1)},{OBJECT(2)}"
   WRITE/OUT "                       LOWSKY = {LOWSKY(1)},{LOWSKY(2)}"
   WRITE/OUT "                       UPPSKY = {UPPSKY(1)},{UPPSKY(2)}"
   RETURN/EXIT
endif

aver/row &a = 'p1' @'csky(1)',@'csky(2)' 
aver/row &b = 'p1' @'csky(3)',@'csky(4)' 
comp/image &s = (&a + &b) / 2.0

aver/row &o   = 'p1' @'cobj(1)',@'cobj(2)' 

comp/image 'p2' = &o - &s

IF EXTMTD(1:1) .EQ. "L"   comp/image {P2} = {P2}*('cobj(2)'-'cobj(1)'+1)

COPY/DD  {P1}  *,3  {P2}

return




