/* @(#)spec_defs.h	16.1.1.1 (ESO-IPG) 06/19/01 15:38:12 */
/* @(#)sp_defs.h    1.0.0.0 (ESO-La Silla) 10/08/91 12:00:00 */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.IDENT        sp_defs.h
.MODULE       header
.LANGUAGE     C
.AUTHOR       Cristian Levin - ESO La Silla
.PURPOSE      definitions for the application side of Spectra.
.KEYWORDS     application definitons.
.COMMENTS     
.VERSION 1.0  1-Mar-1991   Implementation
.ENVIRONMENT  UNIX
------------------------------------------------------------*/

#define MAXION		20	/* max. length of a string in :ION column */
#define COL_WAVE	":WAVE"
#define COL_ION		":ION"
#define COL_INTENSITY	":INTENSITY"
#define COL_STRENGTH	":STRENGTH"

#define MAXDELTA	1000000.0 /* max. diff. between :X values */

#define MAXSTACK	30	/* max.size of stack of spectra */

#define MAXCDESC	20
#define MAXIDENT	20
#define LEFT_BUT	1
#define MID_BUT		32

/* for calibration processes */
#define CALLIN		0
#define CALFIT		1
#define CALRBR		2

typedef struct spec {
	char name[MAXNAME]; 	/* name of file without suffix */
	char ident[MAXIDENT]; 	/* identification of image */
	int id;		    	/* id of file */
	float x[MAXDATA], y[MAXDATA];
	float xmin, ymin, xmax, ymax;
	int row;		/* row of image associated to this spectrum */
	int ahead;		/* rows ahead to be averaged with 'row' */
	int ncols, nrows;
	float start, step;
} SPEC;

typedef struct sp_table {
	long id; 		/* identifier of the table */
	long name[MAXNAME]; 	/* filename */
	float **data;		/* values of the table (matrix form) */
	char **label;		/* labels of columns */
	long ncols;		/* number of columns */
	long nrows;		/* number of rows */
	long naw;		/* number of allocated words by row */
	long nar;		/* number of allocated rows */
} SPTAB;

typedef struct lc_table {
	long id; 		/* identifier of the table */
        int *sel;                /* selection flag */
	long name[MAXNAME]; 	/* filename */
        int *row;               /* effective row number */
	float *wave;		/* values of the WAVE column */
	float *intens;		/* values of the INTENSITY column */
	char **ion;		/* values of the ION column */
	long nrows;		/* number of rows */
} LCTAB;

