! @(#)t2regrlin.prg	16.1.1.1 (ESO-IPG) 06/19/01 15:28:53
!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!
! .IDENTIFICATION
!    MIDAS Command : t2rerglin.prg
!    TABLE Subsystem
!    J.D.Ponz                ESO - Garching    5 AUG 89
!
! .PURPOSE
!    implements
!    REGRESSION/LINEAR table  y[,weights] x1,x2,x3,... [F1]
!
! .MODIFICATIONS
!    N.Rainer, DPG/DMD/ESO, 00/04/28:  - Also only 2 values possible
!                                        (for 1 independent variable) !
!                                      - Also stddev. of zero point !
!    P Nass 01/01/25     some keywords were not updated 
!                        fix problem with outputc and outputi
! .RETURN
!    Q1:  0: successful return
!         1: an error occured
!
!------------------------------------------------------------------------------
!
DEFINE/PARAM P1 ? TABLE "Enter table:"
DEFINE/PARAM P2 ? CHAR  "Enter column with dep. variable:"
DEFINE/PARAM P3 ? CHAR  "Enter column(s) with indep. vars.:"
DEFINE/PARAM P4 2.5 NUMBER
!
define/local tmptab/c/1/20 "midtmptmp{mid$sess(11:12)}.tbl"
define/local wrktab/c/1/20 "midtmp{mid$sess(11:12)}.tbl"
define/local wrkcol/c/1/16 ":midtmp{mid$sess(11:12)}"
define/local presel/i/1/1 0
define/local INDEPNO/i/1/1 0  ! number of independent variables
define/local indloop/i/1/1 0
define/local N/i/1/1 0        ! number of values
define/local ey/r/1/1 0.
define/local Sx/d/1/1 0.
define/local Sx_2/d/1/1 0.
define/local Sy/d/1/1 0.
define/local Sxy/d/1/1 0.
define/local S_x2/d/1/1 0.
define/local D/d/1/1 0.
define/local A/r/1/1 0.
define/local B/r/1/1 0.
define/local eB/r/1/1 0.
define/local eA/r/1/1 0.
define/local colnode/i/1/1 0 ! col. no. of dependent variable
define/local colnoin/i/1/1 0 ! col. no. of independent variable
!
set/format I1 E14.7,E23.15
!
!
! CHECKING "NULL" VALUES:
! ----------------------
if m$index(p1,".tbl") .eq. 0 p1 = p1//".tbl"
define/local table/c/1/80 {P1}
-delete {tmptab}
-copy {p1} {tmptab}
$ chmod u+w {tmptab}
presel = {{tmptab},TBLCONTR(10)}  ! tot.no. of sel.rows
if p3(1:1) .ne. ":" .and. p3(1:1) .ne. "#" p3 = ":"//p3
if p2(1:1) .ne. ":" .and. p2(1:1) .ne. "#" p2 = ":"//p2
INDEPNO = m$parse(p3,"ind")  ! number of indep. var.
select/table {tmptab} sel.and.{p2}.ne.NULL >Null
set/format I2
do indloop = 1 INDEPNO
  select/table {tmptab} sel.and.{ind{indloop}}.ne.NULL >Null
enddo
N = outputi(1)
set/format I1
if N .lt. 2 then
  write/out -
    "ERROR   [regress/linear]:   Too few non-NULL values in {p1} !"
  return 1
elseif N .lt. presel then
  inputi(1) = presel-N
  write/out -
    "WARNING [regress/linear]:   Ignoring {inputi(1)} NULL values !"
endif
copy/table {tmptab} {wrktab}
-delete {tmptab}
!
!
! BRANCHING ACCORDING TO NUMBER OF INDEPENDENT VARIABLES
! (AND NUMBER OF VALUES):
! ------------------------------------------------------
create/column {wrktab} {wrkcol} " " E24.15 R*8
!!! if N .gt. 2 then
if INDEPNO .gt. 1 then
  !
  if N .eq. 2 then
    write/out -
      "ERROR   [regress/linear]:   Only 2 vals. / >1 indep.vars. - no calc. !"
    return 1
  endif
  !
  P1 = wrktab
  WRITE/KEYW HISTORY "REGR/LINE "
  WRITE/KEYW INPUTR/R/1/1   {P4}
  WRITE/KEYW MID$CMND/C/1/4 LINE
  write/keyw outputc " " all
  write/keyw outputi 0 all
  write/keyw outputd 0. all
  write/keyw outputr 0. all
  !
  RUN MID_EXE:topertbl >Null
  !
  ey = outputr(3)
  !
!!! elseif N .eq. 2 .and. INDEPNO .eq. 1 then
elseif INDEPNO .eq. 1 then
  !
  !  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  !  Taylor John R., 1988, "Fehleranalyse"/1.Auflage/S.136-144, VCH,
  !  ISBN 3-527-26878-2 :
  !  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  !  y = A + B*x  =>
  !  ("S"="sum of all"; "N"="total number of values"; "e"="stddev.")
  !
  !  D := (N*S(x^2) - (Sx)^2)
  !  A = (S(x^2)*Sy - Sx*S(xy)) / D
  !  B = (N*S(xy) - Sx*Sy) / D
  !
  !  (ey)^2 = S((y - A - B*x)^2) / (N - 2)  ! if N=2, set to 0.
  !  (eA)^2 = (ey)^2 * S(x^2) / D           ! if N=2, set to 0.
  !  (eB)^2 = N * (ey)^2 / D                ! if N=2, set to 0.
  !  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  !
  statistics/table {wrktab} {p3} >Null
  Sx = N*outputr(3)
  Sx_2 = Sx**2
  statistics/table {wrktab} {p2} >Null
  Sy = N*outputr(3)
  compute/table {wrktab} {wrkcol} = {p3}*{p2}
  statistics/table {wrktab} {wrkcol} >Null
  Sxy = N*outputr(3)
  compute/table {wrktab} {wrkcol} = {p3}**2
  statistics/table {wrktab} {wrkcol} >Null
  S_x2 = N*outputr(3)
  D = N*S_x2 - Sx_2
  !
  A = (S_x2*Sy - Sx*Sxy) / D
  B = (N*Sxy - Sx*Sy) / D
  if N .eq. 2 then
    ey = 0.
    eB = 0.
  elseif N .gt. 2 then
    compute/table {wrktab} {wrkcol} = ({p2}-{A}-{B}*{p3})**2
    statistics/table {wrktab} {wrkcol} >Null
    ey = m$sqrt(N*outputr(3) / (N-2))
    eB = m$sqrt(N * ey**2 / D)
  endif
  !
! keyword outputc is important for SAVE/REGRESS and COMPUTE/REGRESS
  write/keyw outputc/c/9/8 {table} ! outputc contains tablename from 9 to 16
  write/keyw outputc/c/17/4 "LINE" ! outputc contains LINE from 17 to 20
  
! keyword outputi is important for SAVE/REGRESS and COMPUTE/REGRESS
  write/keyw outputi/i/1/1 {N} ! OUTPUTI(1)- N,no.of data
  write/keyw outputi/i/2/1 {INDEPNO} ! OUTPUTI(2)- M,no.of ind.var.
!
! search for the col. no. of the variables:  
! Get column number of P2 (this is the dependent variable)
  colnode = M$EXISTC("{table}","{P2}")
  
  IF colnode .LT. 0 THEN
    WRITE/OUT "Negative result - severe error!"
    RETURN/EXIT
  ENDIF
  
  write/keyw outputi/i/3/1 {colnode} !OUTPUTI(3)- col.no. of dep.var.
! Get column number of P3 (this is the independent variable)
  colnoin = M$EXISTC("{table}","{P3}")
  write/keyw outputi/i/4/1 {colnoin} ! OUTPUTI(4)- col.no. of ind.var.i=4,...,M+3

! these keywords will be filled below:
  write/keyw outputd 0. all ! constant terms
  write/keyw outputr 0. all !
  
  outputd(1) = A
  outputd(2) = B
  outputr(3) = ey
  outputr(4) = eB
!!!   !
!!! else  ! only 2 non-NULL values and more than 1 independent variables
!!!   !
!!!   write/out -
!!!     "ERROR   [regress/linear]:   Only 2 vals. / >1 indep.vars. - no calc. !"
!!!   return 1
  !
endif
!
set/format ,E14.7
write/out " REGRESSION          Input Table: {table}    Type: LINEAR"
write/out " N. Cases:     {N};  N.Ind. Vars.: {INDEPNO}"
write/out " Dependent variable   {P2} column # {colnode} "

write/out " Var. {P3} column # {colnoin}"
write/out "   Slope :  {outputd(2)}"
write/out "   Const.:  {outputd(1)}"
write/out "   R.M.S. Error    :  {outputr(3)}"
write/out "   Std.dev. of Slope :  {outputr(4)}"
set/format ,E23.15
!
!
! CALCULATING STD.DEV. OF ZERO POINT FOR 1 INDEPENDENT VARIABLE:
! -------------------------------------------------------------
if INDEPNO .eq. 1 then
  !
  if N .eq. 2 then
    eA = 0.
  elseif N .gt. 2 then
    !
    !!! copy/keyw outputc savec
    !!! copy/keyw outputi savei
    !!! copy/keyw outputd saved
    !!! copy/keyw outputr saver
    !
    !!! statistics/table {wrktab} {p3} >Null
    !!! Sx_2 = (N*outputr(3))**2
    !!! compute/table {wrktab} {wrkcol} = {p3}**2
    !!! statistics/table {wrktab} {wrkcol} >Null
    !!! S_x2 = N*outputr(3)
    !!! D = N*S_x2 - Sx_2
    eA = m$sqrt(ey**2 * S_x2 / D)
    !
    !!! copy/keyw savec outputc
    !!! copy/keyw savei outputi
    !!! copy/keyw saved outputd
    !!! copy/keyw saver outputr
    !
  endif
  !
  outputr(2) = eA
  write/out -
    "   Std.dev. of Const.:  {outputr(2)}"
  !
endif
!
!
-delete {wrktab}
WRITE/KEYW HISTORY "REGR/LINE "
return 0
!
!------------------------------------------------------------------------------
