! @(#)plothst.prg	16.1.1.1 (ES0-DMD) 06/19/01 15:28:46
!+++++++++++++++++++++++++++++++++++++++++++++++++++++++
!.IDENTIFICATION plothst.prg
!.PURPOSE        Plot a histogram of image pixel or table values
!                execute via
!                PLOT/HISTOGRAM table col-ref [scal_x,scal_y,off_x,off_y] 
!                               [bin,[min,[max]]] [exc] [log] [opt]
!                or 
!                PLOT/HISTOGRAM image [scal_x,scal_y,off_x,off_y] [log] [opt]
!.AUTHOR         830813 J.D.Ponz
!.VERSION        860109, 900409, 910225, 920413   K. Banse
!.VERSION        870601 RHW ??
!.VERSION:       920224 RHW Offset in x and y included
!.VERSION:       931215 RvH other parameters for the new C code
!----------------------------------------------------------------------
define/local cmnd/c/1/20 "{mid$cmnd(1:20)}"          !save initial command
!
!if mid$sess(7:7) .eq. " " .or. mid$sess(7:7) .eq. "-" then
!   create/graphics
!   write/keyw mid$cmnd/c/1/20 "{cmnd(1:20)}"            !reset MID$CMND
!endif
!
BRANCH P2(1:1) :,# TABLES,TABLES	         ! test for column reference
!
! handle images here
DEFINE/PARAM   P1 ? IMA "Enter table or frame name:"
DEFINE/PARAM   P3 "YY" C                             ! excess bin plotted
!
WRITE/KEYW    IN_A {P1}
!
DEFINE/LOCAL  LOLA/I/1/1 0                  !check, if HISTOGRAM descr. there
LOLA = M$EXISTD(IN_A,"HISTOGRAM")
IF LOLA .EQ. 0 THEN
   WRITE/OUT "We have to execute the command STATISTICS/IMAGE first,"
   WRITE/OUT "since the descriptor HISTOGRAM does not exist"
   STATISTICS/IMAGE {IN_A}		         ! build up histogram first
   write/keyw mid$cmnd/c/1/20 "{cmnd(1:20)}" 
ENDIF
!
IF MID$CMND(1:1) .EQ. "P" THEN    
   DEFINE/PARAM P2 0.,0.,-999,-999 NUM
   @ plscoff {P2}
   DATTIM = M$TIME()
ELSE
   DEFINE/PARAM P2 0.0 NUMBER
   WRITE/KEYW INPUTR/R/1/1 {P2}
ENDIF
!
DEFINE/PARAM   P4 "LIN"  C                         ! default scales
DEFINE/PARAM   P5 0.0,-999999.,0.0 N               ! standard layout
WRITE/KEYW     INPUTC/C/1/2 {P3}
WRITE/KEYW     INPUTC/C/3/3 {P4}
WRITE/KEYW     INPUTR/R/2/3 {P5}
!
RUN MID_EXE:PLOTHBDF  
WRITE/KEYW PLCDATA/C/1/60  "{P1},HISTOGRAM"
WRITE/KEYW PLCDATA/C/61/20 "DESCRIPTOR"
@ sendplot
RETURN
!
!
! handle tables
TABLES:
DEFINE/PARAM P1 ? TBL "Enter table or frame name:"
DEFINE/PARAM P4 "?,?,?"
DEFINE/PARAM P5 "YY" C                             ! excess bin plotted
DEFINE/PARAM P6 "LIN" C                            ! linear display
DEFINE/PARAM P7 0.0,-999999.,0.0 N                 ! standard layout
!
WRITE/KEYW  IN_A         {P1}
WRITE/KEYW  INPUTC/C/1/2 {P5}
WRITE/KEYW  INPUTC/C/3/3 {P6}
WRITE/KEYW  INPUTR/R/2/3 {P7}
!
DEFINE/LOCAL K1/I/1/1 0
DEFINE/LOCAL R1/C/1/20 "?"
DEFINE/LOCAL R2/C/1/20 "?"
DEFINE/LOCAL R3/C/1/20 "?"
DEFINE/LOCAL STRIKE/C/1/60 {P4} 
!
K1 = M$INDEX(STRIKE,",")-1
IF K1 .EQ. -1 THEN
   R1 = "{STRIKE}"
ELSE
   R1 = "{STRIKE(1:{K1})}"
   K1 = K1 + 2
   STRIKE = "{STRIKE({K1}:>)}"
   K1 = M$INDEX(STRIKE,",")-1
   IF K1 .EQ. -1 THEN
      R2 = "{STRIKE}"
   ELSE
      R2 = "{STRIKE(1:{K1})}"
      K1 = K1 + 2
      R3 = "{STRIKE({K1}:>)}"
   ENDIF
ENDIF
!
IF MID$CMND(1:1) .EQ. "P" THEN
   DEFINE/PARAM P3 0.,0.,-999,-999 NUM
   @ plscoff {P3}
   DATTIM = M$TIME()
ELSE
   DEFINE/PARAM P3 0.0 NUMBER
   WRITE/KEYW INPUTR/R/1/1 {P3}
ENDIF
!
@ t2stattbl {p1} {p2} {r1} {r2} {r3}
RUN MID_EXE:PLOTHTBL
WRITE/KEYW PLCDATA/C/1/60  "{P1},HISTOGRAM"
WRITE/KEYW PLCDATA/C/61/20 "DESCRIPTOR"
@ sendplot



