! @(#)plotcon.prg	16.1.1.1 (ESO-DMD) 06/19/01 15:28:45
!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!.IDENTIFICATION: PLOTCON.PRG
!.PURPOSE: MIDAS procedure to produce a contour map of a two-dim. image
!          execute by
!          PLOT/CON P1 P2 P3 P4 P5 P6 where:
!          P1: image is the image to be plotted
!          P2: coord_string is the area
!          P3: scal_x,scal_y, off_x and off_y (default device filling)
!          P4: contours are the contour levels
!          P5: contour type 
!          P6: smooth_par is parameter which represents size of smoothing box
!.AUTHOR:  Ch. Ounnas, R.H. Warmels, ESO-Garching
!.VERSION: 860911 RHW creation
!.VERSION: 870327 RHW
!.VERSION: 880922 KB  and 900409,900712 , 920413
!.VERSION: 920224 RHW Offset in x and y included
!-----------------------------------------------------------------------------
DEFINE/PARAM P1 * IMA
define/local cmnd/c/1/20 "{mid$cmnd(1:20)}"            !save MID$CMND
!
IF PLRSTAT(1) .EQ. 0.0 .AND. PLRSTAT(2) .EQ. 0.0 THEN
   IF PLRSTAT(5) .EQ. 0.0 .AND. PLRSTAT(6) .EQ. 0.0 THEN
      DEFINE/PARAM P2 [<,<:>,>] C
      IF P2(1:1) .EQ. "M" THEN
         WRITE/OUT "*** FATAL: axes not properly set; use SET/GRAPHICS"
         RETURN
      ENDIF
   ELSE
      DEFINE/PARAM P2 MANUAL   C
   ENDIF
ELSE
   DEFINE/PARAM P2 MANUAL   C
ENDIF
!
!if mid$sess(7:7) .eq. " " .or. mid$sess(7:7) .eq. "-" then
!   create/graphics
!   write/keyw  mid$cmnd/c/1/20 "{cmnd(1:20)}"
!endif
! 
IF P2 .EQ. "C" THEN
   IF P1 .NE. "?" LOAD/IMAGE {P1}
   GET/CURSOR ? ? NN 1,2		         ! use cursor rectangle once
   write/keyw  mid$cmnd/c/1/20 "{cmnd(1:20)}"
ENDIF
!
WRITE/KEYW IN_A {P1}
WRITE/KEYW IN_B {P2}
!
IF MID$CMND(1:1) .EQ. "P" THEN
   DEFINE/PARAM P3 0.,0.,-999,-999 NUM
   @ plscoff {P3}                                 ! get the scales and offsets
   DEFINE/PARAM P4 1.0 C
   WRITE/KEYW INPUTC/C/1/72  {P4}   
   DEFINE/PARAM P5 ODD C
   WRITE/KEYW INPUTC/C/73/4  {P5}
   DEFINE/PARAM P6 0 N
   WRITE/KEYW INPUTI/I/1/1   {P6}
   DATTIM = M$TIME()
ELSE
   DEFINE/PARAM P3 1.0 C
   WRITE/KEYW INPUTC/C/1/72  {P3}
   DEFINE/PARAM P4 ODD C
   WRITE/KEYW INPUTC/C/73/4  {P4}
   DEFINE/PARAM P5 0 N
   WRITE/KEYW INPUTI/I/1/1   {P5}
ENDIF
!
RUN MID_EXE:PLOTCON                              ! make the bloddy plot
WRITE/KEYW PLCDATA/C/1/60  {P1}                   ! name of data structure
WRITE/KEYW PLCDATA/C/61/20 "FRAME       "         ! type ofdat astructure
@ sendplot
