! @(#)plassign.prg	16.1.1.1 (ES0-DMD) 06/19/01 15:28:45
! +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!.IDENTIFICATION: PLASSIGN.PRG
!.PURPOSE: MIDAS procedute to assign the graphic device
!          All other ASSIGN/... commands are done in ASSIGN.PRG
!.USE:     executed via ASSIGN/PLOT device_name
!.AUTHOR:  R.H. Warmels  ESO - Garching 
!.VERSION: 870211  RHW  data of creation
!.VERSION: 880707  RHW  incl. of postscript laser printer (AGFA 400PS = LASERC)
!.VERSION: 890202  RHW  incl. of postscript laser printer (APPLE = LASERD)
!.VERSION: 890404  RHW  GRAPH_DISP for all display devices 
!.VERSION: 900108  RHW  GRAPH_TERM for non-workstation graphic terminals 
!                       GRAPH_WNDn for workstation graphic windows
!                       IMAGE_DISP for non-workstation display device
!                       IMAGE_WNDn for workstation display windows
!.VERSION: 901206  KB   {', '} business...
!.VERSION: 900213  RHW  changes in device names
!.VERSION: 910322  KB   check IDIDEV(18) against 11 (was 10 before)
!.VERSION: 920709  RHW  rewritten for system independency (all devices from
!.                      agldevs/dat
!.VERSION: 930714  KB   create graph window if none there yet
!.VERSION: 940207  RHW  file and file names implemented; NOSPOOL option removed
!.NOTE:    The procedure either takes the default output device stored in the 
!          keyword MID$PLOT or the input from P1.
!          The input device can either be a graphics window, a MIDAS logical 
!          name or a system device name. 
!          Graphical and display windows as well as simple terminal are taken
!          care of the the first part of this procedure. The second part of 
!          the procedure deals with hardcopy devices.
!
!          All hardcopy device checking is done in the procedure checkdev.prg
!          A fatal message will be issued if the device is unknown or missing.
!          The file agldevs.dat describes the syntax used internally.
!----------------------------------------------------------------------------
DEFINE/PARAM P1 GRAPHICS,0 C
DEFINE/LOCAL NK/I/1/1 0
DEFINE/LOCAL SYMBOL/C/1/20 " " ALL
DEFINE/LOCAL IND/I/1/1/ 0 
DEFINE/LOCAL LEN/I/1/1 0
DEFINE/LOCAL META/C/1/20 " " all
DEFINE/LOCAL TYPE/C/1/1 " " 
SET/FORMAT   I1
!
! *** HERE FORE ALL DISPLAY STUFF
IF P1(1:1) .EQ. "g" THEN                         ! here for graphics windows
   IF IDIDEV(18) .NE. 11 THEN
      WRITE/KEYW MID$PLOT/C/1/20 graph_term
   ELSE
      NK = M$INDEX(P1,",")+1
      IF NK .LE. 1 THEN
         WRITE/KEYW NK/I/1/1 0
      ELSE
         WRITE/KEYW NK/I/1/1 {P1({NK}:{NK})}
      ENDIF
      WRITE/KEYW MID$PLOT/C/1/20 graph_wnd{NK}
!
      if nk .lt. 0 .or. nk .gt. 9 goto error_back            ! graphics window?
      if mid$sess(7:7) .eq. " " .or. mid$sess(7:7) .eq. "-" then
         write/out "*** INFO: Graphics window {nk} created ..."
         create/graph {nk}
      elseif nk .ne. dazdevr(11) then
         @ creagra {nk} -999                            ! former switch/display
      endif
   ENDIF
   write/keyw mid$plot/c/21/10 "NOSPOOL"
!
ELSEIF P1(1:1) .EQ. "t" THEN                    ! here for graphics terminal
   IF IDIDEV(18) .NE. 11 THEN
      WRITE/KEYW MID$PLOT/C/1/20 graph_term
   ELSE
      NK = M$INDEX(P1,",")+1
      IF NK .LE. 1 THEN
         WRITE/KEYW NK/I/1/1 0
      ELSE
         WRITE/KEYW NK/I/1/1 {P1({NK}:{NK})}
      ENDIF
      WRITE/KEYW MID$PLOT/C/1/20 graph_wnd{NK}
!
      if nk .lt. 0 .or. nk .gt. 9 goto error_back            ! graphics window?
      if mid$sess(7:7) .eq. " " .or. mid$sess(7:7) .eq. "-" then
         write/out "*** INFO: Graphics window {nk} created ..."
         create/graph {nk}
      elseif nk .ne. dazdevr(11) then
         @ creagra {nk} -999                            ! former switch/display
      endif
   ENDIF 
   write/keyw mid$plot/c/21/10 "NOSPOOL"
!
ELSEIF P1(1:1) .EQ. "i" THEN                       ! here for display window
   IF IDIDEV(18) .NE. 11 THEN
      WRITE/KEYW MID$PLOT/C/1/20 image_displ
   ELSE
      NK = M$INDEX(P1,",")+1
      IF NK .LE. 1 THEN
         WRITE/KEYW NK/I/1/1 0
      ELSE
         WRITE/KEYW NK/I/1/1 {P1({NK}:{NK})}
      ENDIF
      WRITE/KEYW MID$PLOT/C/1/20 image_wnd{NK}
!
      if nk .lt. 0 .or. nk .gt. 9 goto error_back             ! display window?
      if mid$sess(6:6) .eq. " " .or. mid$sess(6:6) .eq. "-" then
         write/out "*** INFO: Display window {nk} created ..."
         create/display {nk}
      elseif nk .ne. dazdevr(10) then
         @ creadisp {nk} -999                           ! former switch/display
      endif
   ENDIF
   write/keyw mid$plot/c/21/10 "NOSPOOL"
!
ELSEIF P1(1:1) .EQ. "d" THEN                       ! here for display window
   IF IDIDEV(18) .NE. 11 THEN
      WRITE/KEYW MID$PLOT/C/1/20 image_displ
   ELSE
      NK = M$INDEX(P1,",")+1
      IF NK .LE. 1 THEN
         WRITE/KEYW NK/I/1/1 0
      ELSE
         WRITE/KEYW NK/I/1/1 {P1({NK}:{NK})}
      ENDIF
      WRITE/KEYW MID$PLOT/C/1/20 image_wnd{nk}
!
      if nk .lt. 0 .or. nk .gt. 9 goto error_back             ! display window?
      if mid$sess(6:6) .eq. " " .or. mid$sess(6:6) .eq. "-" then
         write/out "*** INFO: Display window {nk} created ..."
         create/display {nk}
      elseif nk .ne. dazdevr(10) then
         @ creadisp {nk} -999                           ! former switch/display
      endif
   ENDIF 
   write/keyw mid$plot/c/21/10 "NOSPOOL"
!
! *** here for hardcopy devices (MIDAS logical names and system names)
ELSE
   @ checkdev {P1}                                      ! check name of device
   IND = M$INDEX(P1,".")
   IF IND .GT. 0 THEN
      WRITE/KEYW MID$PLOT/C/1/20 {Q1}{P1({IND}:>)}      ! write name in keyword
   ELSE
      WRITE/KEYW MID$PLOT/C/1/20 {Q1}                   ! write name in keyword
   ENDIF
   META = M$LOWER("{Q1}{MID$SESS(11:12)}")              ! meta file name
   WRITE/KEYW PLCMETA/C/1/80 "{META}.plt"               
   IF Q1 .eq. "POSTSCRIPT" THEN                         ! spool option
      write/keyw mid$plot/c/21/10 "SPOOL"               ! spool for postscript
   ELSE                                               
      define/parameter P2 S C "Enter spool or nospool option:"
      if p2 .eq. "S" then
         write/keyw mid$plot/c/21/10 "SPOOL"            ! spool
      else
         write/keyw mid$plot/c/21/10 "NOSPOOL"          ! nospool
      endif
   ENDIF
ENDIF 
META = M$LOWER("{MID$PLOT(1:20)}")
WRITE/KEYW PLCMETA/C/1/80 "{META}{MID$SESS(11:12)}.plt"
RETURN
!
ERROR_BACK:
WRITE/OUT "*** FATAL: Invalid input..."






