/* @(#)filedef.h	16.1.1.1 (ESO-IPG) 06/19/01 15:14:01 */
/*+++++++++++++++++++
.TYPE                Header
.LANGUAGE            C
.IDENTIFICATION      filedef.h
.AUTHOR              Francois Ochsenbein [ESO-IPG]
.KEYWORDS            Keywords for Operations on Files
.ENVIRONMENT         Any
.COMMENTS            Definitions related to File Management
.VERSION 1.0	24-Oct-1989  Extracted from osfile.h
.VERSION 1.1	31-Jan-1990  Added filename operations
--------------------------------------------------------------------------*/

#ifndef  FILEDEF_DEF 
#define  FILEDEF_DEF

/*===========================================================================
 *		Basic Definitions
 *===========================================================================*/

#define	 CHMOD        0
#define	 CHOWN        1

#define  READ         0
#define  WRITE        1
#define  READ_WRITE   2
#define  APPEND       3

#define  FILE_START   0
#define  FILE_CURRENT 1
#define  FILE_END     2

#define  PROTECTION   0755     /* Default Protection to create Files	     */
#define  LARGE_BUFFER  0x8000	/* Large Blocking Option	*/
#define  NOATTR	      0x10000	/* VMS only (no record attr) 	*/


#ifndef EOF
#define EOF		(-1)		/* End of File		*/
#endif

/*===========================================================================
 *		Components of a file name
 *===========================================================================*/

#define __NODE_		6	/* To parse file names		*/
#define __PATH_		5	/* To parse file names		*/
#define __FILE_		3
#define __EXTENSION_	2
#define __VERSION_	1

#define _NODE_		(1<<__NODE_)
#define _PATH_		(1<<__PATH_)
#define _FILE_		(1<<__FILE_)
#define _EXTENSION_	(1<<__EXTENSION_)
#define _VERSION_	(1<<__VERSION_)

#define __TYPE_		__EXTENSION_
#define _TYPE_		_EXTENSION_

#ifndef _TEMPLATES_
#include <compiler.h>
#endif
#if _TEMPLATES_
/*===========================================================================
 *			Operations on FileNames
 *===========================================================================*/
char *osfparse	(char *phname, unsigned int components);
char *osfsupply	(char *phname, char *template);
char *osftr	(char *logname);
#else					/* No templates ... */
char *osfparse(), *osfsupply(), *osftr();
#endif

#endif
