/*+++++++++++++++++++++++++++++
.TYPE 		Header
.NAME 		computer.h
.LANGUAGE 	C
.AUTHOR		ESO -- IPG
.CATEGORY	Computer-dependant constants
.COMMENTS 	This module includes constants depending on the computer:
		number of bits per char,
		byte swapping, description of floating-point numbers. 
		Limits also provided for each type of atomic data.
		NULL numbers are also defined via isNULL (test) and
		toNULL
		********* Generated by computer.c program **************
.ENVIRON	UNIX and VAX/VMS
.VERSION 	1.1	18-Jan-1991 (check Floating Pattern)
.VERSION 	2.1	25-Mar-1994 (using values.h if exists)
.VERSION 	3.1	28-Oct-1994 (POSIX definitions if exists)
-----------------------*/

#ifndef COMPUTER_H
#define COMPUTER_H

/*
 * Define _POSIX_SOURCE to indicate
 * that this is a POSIX program
 */
#ifndef _POSIX_SOURCE
#define _POSIX_SOURCE 1
#endif

#include <float.h>
#include <limits.h>
#include <values.h>

#undef BITSPERBYTE
#define BITSPERBYTE	8
#define BITS(type)	(BITSPERBYTE*((int)sizeof(type)))

#define ONES_COMP	1
#define TWOS_COMP	2

#define IEEEFLOAT	0
#define VAXFLOAT	1
#define VAXGFLOAT	2
#define HPFLOAT		3

#define INTFMT		2	/* 2's Complement Integers	*/

#define MAXIO1		(512*90)



#define SWAPSHORT	21
#define SWAPINT		4321
#define SWAPFLOAT	4321
#define SWAPDOUBLE	87654321

#undef  MINCHAR
#define MINCHAR		CHAR_MIN
#undef  MINSHORT
#define MINSHORT	SHRT_MIN
#undef  MININT
#define MININT		INT_MIN
#undef  MINLONG
#define MINLONG		LONG_MIN
#undef  MAXCHAR
#define MAXCHAR		CHAR_MAX
#undef  MAXSHORT
#define MAXSHORT	SHRT_MAX
#undef  MAXINT
#define MAXINT		INT_MAX
#undef  MAXLONG
#define MAXLONG		LONG_MAX
#undef  MAXUCHAR
#define MAXUCHAR	UCHAR_MAX
#undef  MAXUSHORT
#define MAXUSHORT	USHRT_MAX
#undef  MAXUINT
#define MAXUINT		UINT_MAX
#undef  MAXULONG
#define MAXULONG	ULONG_MAX

#define _IEEE		1	/* NULL edited as nan */
#define _HIDDENBIT	1
#define _EXPBASE	2

#define _FEXPLEN	8
#define FMASKSGM	0x80000000
#define FMASKEXP	0x7F800000
#define FMASKMAN	0x007FFFFF

#undef  MAXFLOAT
#define MAXFLOAT	FLT_MAX
#undef  MINFLOAT
#define MINFLOAT	FLT_MIN
#define _DEXPLEN	11
#define DINTEXP	1	/* Exponent is in longword #1	*/
#define DMASKSGM	0x80000000
#define DMASKEXP	0x7FF00000
#define DMASKMAN	0x000FFFFF

#undef  MAXDOUBLE
#define MAXDOUBLE	DBL_MAX
#undef  MINDOUBLE
#define MINDOUBLE	DBL_MIN

/*	 Definition of NULL's 	*/

#define asaUINT(x)	(unsigned int *)(&(x))
#define asaULONG(x)	(unsigned long *)(&(x))

#define NULL1		(MINCHAR)
#define NULL2		(MINSHORT)
#define NULL4		(MININT)

#define isNULLSHORT(x)	((short)(x) == MINSHORT)
#define toNULLSHORT(x)	x = MINSHORT

#define isNULLINT(x)	((int)(x) == MININT)
#define toNULLINT(x)	x = MININT

#define isNULLLONG(x)	((long)(x) == MINLONG)
#define toNULLLONG(x)	x = MINLONG

/*	 Use -Inf as NULL for IEEE fp 	*/

#define NULLF		(FMASKSGM | FMASKEXP)
#define isNULLFLOAT(x)	((*asaUINT(x) & FMASKEXP) == FMASKEXP)
#define toNULLFLOAT(x)	 *asaUINT(x) = NULLF
#define NULLD		(DMASKSGM | DMASKEXP)
#define isNULLDOUBLE(x)	((*(asaUINT(x)+DINTEXP) & DMASKEXP) == DMASKEXP)
#define toNULLDOUBLE(x)	*(asaUINT(x)+DINTEXP) = NULLD, \
			 *(asaUINT(x)+(DINTEXP^1)) = 0

#define FSIGNIF		(BITS(float)  - _FEXPLEN + _HIDDENBIT - 1)
#define DSIGNIF		(BITS(double) - _DEXPLEN + _HIDDENBIT - 1)
#define FLOATFMT	IEEEFLOAT

#endif
