! @(#)outima.prg	16.1.1.1 (ES0-DMD) 06/19/01 14:53:28
! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!
! MIDAS procedure outima.prg  to convert Midas images to other image formats
! K. Banse      941020, 941107
! 
! execute via   @a outima frame format [LUTname] [ITTname] nopix
!   with frame = name of input Midas image
!        format = AVS   AVS X image file.
!                 BMP   Microsoft Windows bitmap image file.
!                 EPS   Adobe Encapsulated PostScript file.
!                 GIF   Compuserve Graphics image file.
!                 JPEG
!                 MIFF  Magick image file format.
!                 PCX   ZSoft IBM PC Paintbrush file.
!                 PICT  Apple Macintosh QuickDraw/PICT file.
!                 PNM   Portable bitmap.
!                 PS    Adobe PostScript
!                 TGA   Truevision Targa image file.
!                 TIFF  Tagged Image File Format.
!                 VIFF  Khoros Visualization image file.
!                 XBM   X11 bitmap file.
!                 XPM   X11 pixmap file.
!                 XWD   X Window System window dump image file.
! 
!        LUT name = name of MIDAS LUT, e.g. heat; defaulted to ramp
!        ITT name = name of MIDAS ITT, e.g. log; defaulted to ramp
!        nopix = xpix,ypix - no. of x-, y-pixels in output image;
!		 defaulted to xpix, ypix of input image
! 
!  The conversion is done via transforming the MIDAS image to PostScript 
!  format and then applying the public domain package `ImageMagick'.
!  I.e. this software must be installed at your site - otherwise this
!  procedure will not work...	
!  (the PostScript conversion is always possible)
! 
!  The output name will be:
!      frame name + format (in lowercase) as file type.
! 
! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!
define/para p1 ? ima "Enter image name: "
define/para p2 GIF c "Enter output format: "
define/para p3 + c "Enter LUT: "
define/para p4 + c "Enter ITT: "
define/para p5 + n "no. of pixels in output image as xpix,ypix: "
! 
define/local savhc/c/1/42 "{hcittlut(1:42)}"
define/local savps/r/1/4 -
   {postscript(3)},{postscript(4)},{postscript(5)},{postscript(6)}
! 
if p3(1:1) .ne. "+" then
   write/keyw hcittlut/c/21/20 "{p3}.lut"        !set LUT and ITT for psbdf.exe
   define/local cf/c/1/5 PC8NZ
else
   define/local cf/c/1/5 PB8NZ
endif
if p4(1:1) .ne. "+" then
   write/keyw hcittlut/c/1/20 "{p4}.itt"
   define/local kf/c/1/1 I
else
   define/local kf/c/1/1 P
endif
if p5(1:1) .ne. "+" then
   define/local size/r/1/2 {p5},{p5}
else
   define/local size/r/1/2 {{p1},npix(1)},{{p1},npix(2)}
endif
size(1) = size(1)*0.03545				!define "paper" size
size(2) = size(2)*0.03545
write/key postscript/r/3/4 {size(1)},{size(2)},0.,0.
! 
define/local nn/i/1/2 0,0
nn(1) = m$indexb(p1,".")
if aux_mode(1) .eq. 1 then
   nn(2) = m$indexb(p1,"]")
else
   nn(2) = m$indexb(p1,"/")
endif
if nn(1) .gt. nn(2) then		!define root of output frame
   nn = nn-1
   define/local outa/c/1/60 {p1(1:{nn})}
else
   define/local outa/c/1/60 {p1}
endif
mid$cmnd(11:14) = "abcd"		!to avoid conflict with COPY/PSCR
@ bdf2ps {p1} {outa}.ps {kf} p6={cf}
! 
write/keyw hcittlut/c/1/42 "{savhc(1:42)}"
write/keyw postscript/r/3/4 {savps(1)},{savps(2)},{savps(3)},{savps(4)}
! 
if p2(1:3) .eq. "AVS" then
   define/local outfile/c/1/60 {outa}.avs
else if p2(1:3) .eq. "BMP" then
   define/local outfile/c/1/60 {outa}.bmp
else if p2(1:1) .eq. "E" then
   define/local outfile/c/1/60 {outa}.eps
else if p2(1:1) .eq. "G" then
   define/local outfile/c/1/60 {outa}.gif
else if p2(1:1) .eq. "J" then
   define/local outfile/c/1/60 {outa}.jpeg
else if p2(1:1) .eq. "M" then
   define/local outfile/c/1/60 {outa}.miff
else if p2(1:3) .eq. "PCX" then
   define/local outfile/c/1/60 {outa}.pcx
else if p2(1:3) .eq. "PIC" then
   define/local outfile/c/1/60 {outa}.pict
else if p2(1:3) .eq. "PNM" then
   define/local outfile/c/1/60 {outa}.pnm
else if p2(1:2) .eq. "PS" then
   define/local outfile/c/1/60 {outa}.ps
   goto end
else if p2(1:2) .eq. "TG" then
   define/local outfile/c/1/60 {outa}.tga
else if p2(1:2) .eq. "TI" then
   define/local outfile/c/1/60 {outa}.tiff
else if p2(1:1) .eq. "V" then
   define/local outfile/c/1/60 {outa}.viff
else if p2(1:3) .eq. "XBM" then
   define/local outfile/c/1/60 {outa}.xbm
else if p2(1:3) .eq. "XPM" then
   define/local outfile/c/1/60 {outa}.xpm
else if p2(1:3) .eq. "XWD" then
   define/local outfile/c/1/60 {outa}.xwd
else
   write/out {p2} is an unknown output format
   return
endif
! 
! use ImageMagick for conversion Postscript -> {p2} format
! 
$convert {outa}.ps {outfile}
end:
define/local format/c/1/8 " " all
format = m$upper(p2)
write/out {format} format file `{outfile}' created...
