! @(#)genran.prg	16.1.1.1 (ES0-DMD) 06/19/01 14:53:25
!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!
!  MIDAS procedure genran.prg to implement CREATE/RANDOM_IMAGE
!
!  execute via @a genran outfr ndim wcoo func_type coeffs seed
!  or          @a genran outfr = refima func_type coeffs seed
!
!  ndim = NAXIS,NPIX(1),NPIX(2),NPIX(3)
!  wcoo = START(1),...,STEP(3)
!  func_type = U(niform)       coeffs = lower,upper limits
!              G(aussian)               mean,sigma
!              E(xponential)
!              L(ognormal)
!              B(inomial)
!              P(oisson)                mean
!              C(auchy)
!
!  seed = seed for the random generators
!  0 yields same result in successive runs
!
!  Consult the NAGLIB manual Vol.5 section G05xxx for details
! 
! 
!  func_type = F(ibonnacci) does not use NAG library
!  coeffs = used as seed for the lagged Fibonacci random generator
!
!.AUTHOR:
!	Rosa, M., ST-ECF, 850825
!	K. Banse   860103, 911203, 970702
!
!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!
define/param p1 ? ima "Enter result frame: "
write/keyw out_a {p1}
! 
if p2(1:1) .ne. "=" then		! dimensions given explicitly
   define/param p2 2,64,64 N  "Enter Naxis,Npix(1),Npix(2),... : "
   if {p2} .eq. 1 then
      define/param p3 0.,1. N "Enter Start(1),Step(1): "
   elseif {p2} .eq. 2 then
      define/param p3 0.,0.,1.,1. N "Enter Start(1),Start(2),Step(1),Step(2): "
   else
      define/param p3 0.,0.,0.,1.,1.,1. N -
      "Enter Start(1),Start(2),Start(3),Step(1),Step(2),Step(3): "
   endif
   define/local id/i/1/4 {p2}
   define/local rd/d/1/6 {p3}
   in_a = "+ "				! make sure, IN_A is set to "+"
else                                    ! REFIMA option
   define/param p3 ? ima "Enter reference frame: "
   write/keyw in_a {p3}
endif
! 
outputi(1) = m$secs()
define/param p4 UNIFORM C "Enter function type: "
!
if p4(1:1) .eq. "F" then		!Fibonacci 
   define/local seed/i/1/1 0
   define/param p5 + N "Enter seed value: "
   define/param p6 + N "Enter seed value: "
   if p5(1:1) .ne. "+" then
      seed = {p5}				!seed entered
   else
      if p6(1:1) .eq. "+" then
         seed = outputi
      else
         seed = {p6}				!seed entered
      endif
   endif
   run APP_EXE:fibrand.exe
else
!
   define/param p5 0.,1. N "Enter coefficients: "
   define/param p6 {outputi(1)} N "Enter seed value: "
   define/local r/r/1/2 {p5}
   define/local i/i/1/1 {p6}
   run MID_EXE:genran.exe
endif
