/** This class defines the slider which allows users to choose
  * any zoom position.
  */

package CamClnt;

import java.awt.*;
import java.awt.event.*;

public class zoomSlider extends Canvas implements MouseListener {

  // define the variables
    private boolean drawing = false;
    private int      boxX = 10, boxY1 = 8, boxY2 = 20;
    private int      rectX1 = 10, rectY = 14, rectX2 = 187;
    private int      zoomSteps = 12;
    private int      maxzoomspeed = 20;
    private CamComm  camcomm;
    private static final boolean DEBUG = false; // set to true to get debugging printouts

  // define the constructor
    zoomSlider ( CamComm comm ) {
        super ();
	addMouseListener( this );
	camcomm = comm;
    }

  /** overriding getMinimumSize assures that this component will be big enough to
      be useable.
      */
  public Dimension getMinimumSize() {
      return new Dimension( 200, 18 );
 }
  /** overriding getPreferredSize assures that this component will be big enough to
      be useable when pack encounters this component.
      */
  public Dimension getPreferredSize() {
      return new Dimension( 200, 22 );
  }

  /** define the method called whenever this object gets drawn or redrawn
    */
    public void paint (Graphics g) {
      // draw the horizontal line of the slider
	g.drawLine( rectX1, rectY, rectX2, rectY );
	// now to draw the tick marks and label the two ends of the scale
	for( int i=0; i < zoomSteps; i++ )
	  {
	    int xpos = rectX1 + i *((rectX2 - rectX1)/(zoomSteps-1) );
	    g.drawLine( xpos, rectY - 4, xpos, rectY + 4 );
	  }
	g.drawString( "1x", 4, 9 );
	g.drawString( "12x", 170, 9 );
	// draw the current zoom value
	if( drawing == true )
	  g.drawLine(boxX, boxY1, boxX, boxY2 );

    }

  /** this method is called when the mouse button is pressed.
    * Turn off drawing of the current zoom position bar.
    */
    public  void mousePressed (MouseEvent e) {
      
	drawing = false;

        repaint ();
    }

  /** this method is called when the mouse button is released.
    * it formats up and sends the requested zoom command.
    */
    public  void mouseReleased (MouseEvent e) {
	drawing = true;
	boxX = e.getX();
	double curzoom = 1.0 + (((double)zoomSteps - 1.0) * 
				(double)(boxX - rectX1)/(double)(rectX2 - rectX1));
	String temp = "zoom A " + curzoom + " " + maxzoomspeed;
	camcomm.writeCamString( temp );
        repaint ();
    }

  // the next three methods are only implemented because they are part of
  // the interface.
  /** not implemented */
    public  void mouseEntered (MouseEvent e) {
      if( DEBUG )
	System.out.println( "Mouse entered" );
    }
  /** not implemented */
    public  void mouseExited (MouseEvent e) {
      if( DEBUG )
	System.out.println( "Mouse exited" );
    }
  /** not implemented */
    public  void mouseClicked (MouseEvent e) {
      if( DEBUG )
	System.out.println( "Mouse clicked" );
    }
     
  /** the method called when the current zoom has changed by some means other
    * than the user clicking on the slider to set the value to the correct
    * new one and redraw the current position.
    */
    public  void modifyZoom( int increment ) {
      // This function is called when a process wants
      // to modify the current zoom value displayed by the slider
      boxX += increment * (rectX2 - rectX1) / (zoomSteps - 1);
      repaint();
    }
}


