/** This class defines the canvas area that represents the
  * current vic image and allows users to request any of the
  * fractional commands (motion relative to the current image.
  */

package CamClnt;

import java.awt.*;
import java.awt.event.*;

public class pictureArea extends Canvas implements MouseListener {

  // define the object variables
    private boolean  drawing = false;
    private boolean  pnp = false;
    private int      boxX, boxY, boxW = 2, boxH = 2;
    private int      pnpboxX, pnpboxY, pnpboxW, pnpboxH;
    private int      firstX, firstY;
    private int      rectX = 2, rectY = 2, rectW = 100, rectH = 100;
    private double   maxpanspeed = 0.95;
    private double   maxtiltspeed = 0.95;
    private CamComm  camcomm;
    private static final boolean DEBUG = false;

  // define the constructor and register the mouse listener
    pictureArea ( CamComm comm ) {
        super ();
	addMouseListener( this );
	camcomm = comm;
    }

  /** overriding getMinimumSize assures that this component will be big enough to
      be useable.
      */
  public Dimension getMinimumSize() {
      return new Dimension( 104, 105 );
  }
  /** overriding getPreferredSize assures that this component will be big enough to
      be useable when pack encounters this component.
      */
  public Dimension getPreferredSize() {
      return new Dimension( 104, 105 );
  }

  /** this method is called to draw or redraw the image area
    */
    public void paint (Graphics g) {
        g.setColor( Color.white );
	g.fill3DRect( rectX, rectY, rectW, rectH, true );
	g.setColor( Color.black );
        g.drawString ("Camera View", 20, 100);
	if( drawing == true )
	  g.drawRect(boxX, boxY, boxW, boxH );
	if( pnp == true )
	  g.drawRect(pnpboxX, pnpboxY, pnpboxW, pnpboxH );

    }

  /** this method is called any time the mouse button is pressed in the image
    * At this point we just draw a little square here and do the real work
    * when the mouse button is released.
    */
    public  void mousePressed (MouseEvent e) {
      
	boxX = e.getX();
        boxY = e.getY();
	boxW = 2;
	boxH = 2;
	drawing = true;

        repaint ();
    }
  /** this method is called when the mouse button is released in the image area.
    * now we need to do the real work of processing the requested action.  If the
    * user simply clicked the mouse button on the image then pan and tilt to center
    * the selected location.  If they moved the mouse while the button was down
    * then the user is either selecting a zoom or a picture-in-picture action
    * depending on which mouse button was pressed.
    */
    public  void mouseReleased (MouseEvent e) {
        drawing = false;

	String temp;
	if( Math.abs(e.getX() - boxX) > 1.0 && Math.abs( e.getY() - boxY ) > 1.0 ) {
	  // the user moved the mouse during the time they had the mouse button pressed
	    if( DEBUG) 
	      System.out.println( "requesting a zoom or a pnp" );
	    if( e.isMetaDown() ){
	        // right mouse button pressed so doing picture in picture
		// if there is already a pnp showing then assume the user wants the
		// pnp image translated on the screen.  If they have specified a move
		// that will take the pnp image off the screen put it at the edge.
	        if( pnp == true ) {
		    // there is already a pnp showing
		    // first to determine how far the user wants the box moved
		    int transX = e.getX() - boxX;
		    int transY = e.getY() - boxY;
		    // now to make sure the translation will keep the box on the image
		    if( (transX + pnpboxX + pnpboxW) > (rectW + rectX) ){
			transX = rectW + rectX - pnpboxW - pnpboxX;
		    }
		    if( (transY + pnpboxY + pnpboxH) > (rectH + rectY) ) {
			transY = rectH + rectY - pnpboxH - pnpboxY;
		    }
		    if( (transX + pnpboxX) < rectX ){
			transX = -pnpboxX;
		    }
		    if( (transY + pnpboxY) < rectY ) {
			transY = -pnpboxY;
		    }
		    // now to calculate the fraction of the image area we want to move
		    double ftransX = (double)transX / (double)rectW;
		    double ftransY = (double)transY / (double)rectH;
		    // create the command requesting the translation of the pnp box
		    temp = "pnp tra R " + ftransX + " " + ftransY;
		    camcomm.writePnpString( temp );
		    pnpboxX += transX;
		    pnpboxY += transY;
		}
		else {
		    // there is not currently a picture-in-picture showing so we
		    // need to put one up.
		    pnp = true;
		    pnpboxX = boxX;
		    pnpboxY = boxY;
		    pnpboxW = e.getX() - boxX;
		    pnpboxH = e.getY() - boxY;

		    // reset the coordinates so that the X,Y pair is the upper
		    // left corner of the box
		    if( pnpboxW < 0 ) {
			pnpboxX = pnpboxX + pnpboxW;
			pnpboxW *= -1;
		    }
		    if( pnpboxH < 0 ) {
			pnpboxY = pnpboxY + pnpboxH;
			pnpboxH *= -1;
		    }
		    // make the box square by averaging the dimensions
		    pnpboxW = (int)(((double)( pnpboxW + pnpboxH ))/2.0);
		    pnpboxH = pnpboxW;
		    if( DEBUG) 
		      System.out.println( "pnpboxW = " + pnpboxW + "pnpboxH = " + pnpboxH);

		    // now to scale the values so that they are in the correct
		    // scale to send to the server and send them to the server (fractional).
		    double fpnpX = (double)(pnpboxX - 
					    rectX ) / (double)rectW;
		    double fpnpY = (double)(pnpboxY - rectY) / (double)rectH;
		    double fpnpW = (double)pnpboxW / (double)rectW;
		    double fpnpH = (double)pnpboxH / (double)rectH;
		    temp = "pnp sta on@pnp tra A " + fpnpX + " " +
		           fpnpY + "@pnp siz A " + fpnpW + " " + fpnpH;
		    camcomm.writePnpString( temp );
		}
	    }
	    else {
	      // user is requesting a fractional zoom
	      drawing = false;
	      // calculate the width and height of the box the user drew
	      // the temp variables will be used to help get the center for the translation
	      int tempW = e.getX() - boxX;
	      int tempH = e.getY() - boxY;
	      boxW = Math.abs( tempW );
	      boxH = Math.abs( tempH );
	      // use the average of the two dimensions to determine the requested zoom
	      double fzoom = (((double) boxW/(double)rectW) + ((double)boxH/(double)rectH))/2.0;
	      // Calculate the translation required to center the area we are zooming in on
	      double ftilt = -1.0 * (double)(e.getY() - (tempH/2.0) - rectY - (rectH / 2.0)) / (double)rectH;
	      double fpan  = (double)(e.getX() - (tempW/2.0) - rectX - (rectW / 2.0 )) / (double)rectW;
	      
	      temp = "tilt F " + ftilt + " " + maxtiltspeed +
	                  "@pan F " + fpan + " " + maxpanspeed + "@zoom F " + fzoom + 
		          " " + maxtiltspeed;
	      camcomm.writeCamString( temp );
	    }
	}
	else if( e.isMetaDown() ){
            // user tapped the right mouse button once so turn off picture-in-picture
	    pnp = false;
	    temp = "off";
	    camcomm.writePnpString( temp );
	}
	else {
	    // user is requesting a fractional pan/tilt so calculate where to
	    // translate the camera (tell the camera to center on the place where
	    // the mouse was when the user hit the left mouse button)
	    double ftilt = -1.0 * (double)(e.getY() - rectY - (rectH / 2.0)) / (double)rectH;
	    double fpan  = (double)(e.getX() - rectX - (rectW / 2.0 )) / (double)rectW;
	    if( ftilt > 0.45 || ftilt < -0.45 )
	        ftilt = ftilt * 2.0;
	    if( fpan > 0.45 || fpan < -0.45 )
	        fpan = fpan * 2.0;
	    temp = "tilt F " + ftilt + " " + maxtiltspeed +
	                  "@pan F " + fpan + " " + maxpanspeed;
	    camcomm.writeCamString( temp );
	}
        repaint ();
    }
    // the rest of these mouse functions are here because they are part of the interface
    // so I have to implement them
  /** empty method */
    public  void mouseEntered (MouseEvent e) {
      if( DEBUG) 
	System.out.println( "Mouse entered" );
    }
  /** empty method */
    public  void mouseExited (MouseEvent e) {
      if( DEBUG) 
	System.out.println( "Mouse exited" );
    }
  /** empty method */
    public  void mouseClicked (MouseEvent e) {
      //System.out.println( "Mouse clicked" );
    }

  /** method which returns the current state of picture-in-picture
    */
    public  boolean pnpIsOn() {
      //Return a boolean indicating whether picture in picture
      // is currently activated
      return pnp;
    }
}


