/** This class creates a set of checkboxes to be used
  * in selecting which camera should be the current one.
  * It is used for the cameras but in fact it is just a general
  * numeric choice object that allows the user to choose a number
  * in the range specified.
  */

package CamClnt;

import java.awt.*;
import java.awt.event.*;
import java.lang.*;

public class camSelect extends Panel implements ItemListener {

  // define the variables in the class
  Choice        select;
  int           numcams;
  int           curcam;
  CamComm       camcomm;
  String        id;  // the name of this selector
  private static final boolean DEBUG = false; // set to true to get debugging printouts
  
  // constructor for the class
  camSelect( int num, String type, CamComm comm ) {
    super();
    numcams = num;
    select = new Choice( );
    add( select );
    camcomm = comm;
    id = type;
    curcam = 1; // default initial selection is camera 1
    // define that the methods for handling selection events are in this class
    select.addItemListener( this );

    // add the actual selections to the menu
    for( int i = 1; i <= num; i++ )
      {
	String x = String.valueOf( i );
	select.addItem( x );
      }
  }

  /** method called any time the selector is to be redrawn.  
    * Currently this method does nothing.
    */
  public void paint( Graphics g ) {
    //g.drawString(id, 5, 7 );
  }

  /** method called any time the user makes a new selection.
    * This routine formats up a videoswitcher command and calls the 
    * appropriate CamComm routine to get it written to the videoswitcher.
    * This code should change in the future to use a passed in object for
    * the event so that the selector is generic.
    */
  public void itemStateChanged( ItemEvent e ) {

    // ItemSelectable ie = e.getItemSelectable();
    // find out which camera was selected and if it is a different one than was
    // previously selected then send the appropriate command to the device server
    int newcam = 1 + select.getSelectedIndex();
    if( newcam != curcam )
    {
	if( DEBUG )
	  System.out.println ( "cam " + newcam + " was selected. for id= " + id );
	curcam = newcam;
	if( id.equalsIgnoreCase( "view" ))
	  {
	    String temp = "cam A " + curcam + " A";
	    camcomm.writeVidString( temp );
	  }
	else if( id.equalsIgnoreCase( "pnp" ))
	  {
	    String temp = "";
	    camcomm.writePnpString( temp );
	  }
    }
  }

  /** this method returns the number of the currently selected camera
    */
  public int getCurrentCamera() {
      return curcam;
  }

  public void setCurrentCamera( int camnum ) {
      if( camnum > numcams ) {
	  System.out.println( "camSelect.setCurrentCamera() Error: Requested camera " +
			      camnum + " doesn't exist");
	  return;
      }
      curcam = camnum;
      select.select( String.valueOf( camnum ));
      return;
  }

  public void changeNumCams( int newnum ) {
      if( curcam > newnum ) 
	  setCurrentCamera( 1 );
      if( newnum > numcams ){
	  if( DEBUG )
	      System.out.println( "Adding cameras to choice " + newnum + " from " + numcams);
	  for( int i = numcams+1; i <= newnum; i++ ) 
	      select.addItem( String.valueOf( i ) );
      }
      else if( newnum < numcams ){
	  if( DEBUG ) {
	      System.out.println( "About to reduce number of cameras to " + newnum + " from " + numcams );
	      System.out.println( "number of items before " + select.getItemCount());
	  }
	  for( int i = numcams - 1; i >= newnum; i-- )
	      select.remove( i );
	  if( DEBUG )
	      System.out.println( "number of items after " + select.getItemCount());	  
      }
      numcams = newnum;
  }
}	    
