/**  This class defines the popup menu that allows the
     user to launch an RTP listener for a video or audio
     stream.  It allows them to set the address to listen
     on and the sources that have been heard from.
     */
package CamClnt;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.net.*;
import javax.media.rtp.session.*;


public class RTPStreamMenu extends PopupMenu implements ActionListener {
    
    String address;
    int    port = -1;
    int    ttl = 1;
    String media;
    RTPPlayer player = null;
    CamComm   comm;
    RTPInfoWin rtpinfo;
    static final boolean DEBUG = true;
    MyEnumPopup sources_pu;
    MenuItem sources_mi;
    String   videohost;

    RTPStreamMenu(String cur_addr, int cur_port, int cur_ttl, String type, CamComm ncomm) 
    {

	super( (String)type );
	media = type;
	comm = ncomm;
	address = cur_addr;
	port = cur_port;
	ttl = cur_ttl;

	MenuItem temp;
	add( temp = new MenuItem( "Address Settings" ));
	temp.setActionCommand( "Address" );
	temp.addActionListener( this );

	if( address != null && port > 0 ) {
	    System.out.println("RTPStreamMenu constructor--instantiating player for address " + address + ", port " + port + ", ttl " + ttl + ", media " + media); 
	    player = new RTPPlayer(address, port, ttl, media, comm);
	}

	add( temp = new MenuItem( "Player Settings" ));
	temp.setActionCommand( "Player" );
	temp.addActionListener( this );
	addSeparator( );

	add( sources_pu = new MyEnumPopup((Enumeration)null));
	sources_pu.addActionListener( this );
	sources_pu.setActionCommand( "Source" );
	sources_pu.setLabel( "Choose Source");
	System.out.println("RTPStreamMenu--creating RTPInfoWin with cur_addr = " + cur_addr + " cur_port = " + cur_port + " cur_ttl = " + cur_ttl);
	rtpinfo = new RTPInfoWin( cur_addr, cur_port, cur_ttl );
	if( player != null ){
	    System.out.println("RTPStreamMenu constructor--player is not null");
	    player.regSessionListener( sources_pu );
	    player.regRecvListener( sources_pu );
	}
    }

    public void actionPerformed( ActionEvent e ) {

	if( e.getActionCommand().equals( "Address" )) {
	    // user wants to change the address, port, or ttl that we are using for this
	    // videoconferencing component.  Pop a window that allows the user to set them.
	    // and get the new info from him
	    rtpinfo.setVisible( true );
	    // the window will when closed relaunch the RTP Player if the parameters have
	    // changed.
	}
	if( e.getActionCommand().equals( "Player" )) {
	    // user wishes to set the properties of the player
	    System.out.println( "User has requested a change in RTPPlayer settings" );
	}
	else /*if( e.getActionCommand().equals( "Source" ))*/ {
	    // user wants to pick a source to display
	    // this list is rebuilt each time the user clicks on update.
	    if( player != null ) {
		this.add(new MyEnumPopup(player.getSources()));
		//this.add(sources_pu = new MyEnumPopup(player.getSources()));
		//sources_pu.show();
		System.out.println("Got an action on sources");
	    }
	    else {
		if( DEBUG )
		    System.out.println( "RTPStreamMenu: No player currently launched" );
	    }
	}
    }
    
    public void setMediaInfo( String in_addr, int in_port, int in_ttl ) {
	rtpinfo.setAddress( in_addr );
	rtpinfo.setPort( in_port );
	rtpinfo.setTTL( in_ttl );
	System.out.println("RTPStreamMenu::setMediaInfo--in_addr is " + in_addr + " in_port is " + in_port + " in_ttl is " + in_ttl); 
    }
    
    protected class RTPInfoWin extends Frame implements ActionListener {
	TextField addressField, portField, ttlField;
        String last_addr = null;
        int last_port = 0, last_ttl = 0;
        boolean rtpInfoChanged = false;

	public RTPInfoWin( String in_addr, int in_port, int in_ttl ) {
	    System.out.println("RTPInfoWin constructor--in_addr is " + in_addr + " in_port is " + in_port + " in_ttl is " + in_ttl);
	    setLayout( new GridLayout( 4, 1) );
	    add( new Label( "Address" ));
	    addressField = new TextField(27);
	    addressField.setText( in_addr );
	    addressField.setBackground( Color.white );
	    addressField.setBounds( 228, 168, 156, 28 );
	    addressField.setFont(new Font("Dialog", Font.BOLD, 12));
	    add( addressField );
	    last_addr = in_addr;

	    add( new Label( "Port" ));
	    portField = new TextField(27);
	    portField.setText( String.valueOf(in_port) );
	    portField.setBackground( Color.white );
	    portField.setBounds( 228, 168, 156, 28 );
	    portField.setFont(new Font("Dialog", Font.BOLD, 12));
	    add( portField );
	    last_port = in_port;

	    add( new Label( "TTL" ));
	    ttlField = new TextField(27);
	    ttlField.setText( String.valueOf(in_ttl) );
	    ttlField.setBackground( Color.white );
	    ttlField.setBounds( 228, 168, 156, 28 );
	    ttlField.setFont(new Font("Dialog", Font.BOLD, 12));
	    add( ttlField );
	    last_ttl = in_ttl;
	    
	    Button temp;
	    add( temp = new Button( "Apply" ));
	    temp.addActionListener( this );
	    add( temp = new Button( "Cancel" ));
	    temp.addActionListener( this );
	    pack();
	    setLocation( 60, 100 );
	    setVisible( false );
	}

	public String getAddress() {
	    return addressField.getText();
	}

	public void setAddress( String in_addr ) {
	    addressField.setText( in_addr );
	    System.out.println("RTPStreamMenu::setAddress--setting addressField to " + in_addr);
	}

	public int getPort() {
	    String temp = portField.getText();
	    return Integer.parseInt( temp );
	}

	public void setPort( int port ) {
	    portField.setText( String.valueOf( port ));
	    System.out.println("RTPStreamMenu::setPort--setting portField to " + String.valueOf(port));
	}

	public int getTTL() {
	    String temp = ttlField.getText();
	    return Integer.parseInt( temp );
	}

	public void setTTL( int ttl ) {
	    ttlField.setText( String.valueOf( ttl ));
	    System.out.println("RTPStreamMenu::setTTL--setting ttlField to " + String.valueOf(ttl));
	}

	public void actionPerformed( ActionEvent e ) {
	    if( e.getActionCommand().equalsIgnoreCase( "Apply" )) {
	        //System.out.println( "received an apply" );
		setVisible( false );
		if( DEBUG )
		    System.out.println( "RTPStreamMenu: about to relaunch rtp stream");
		reLaunchRTP();
	    }
	    if( e.getActionCommand().equalsIgnoreCase( "Cancel" )) {
		addressField.setText( last_addr );
		portField.setText( String.valueOf( last_port ));
		ttlField.setText( String.valueOf( last_ttl ));
		setVisible( false );
	    }
	}
    }

    public void reLaunchRTP( ) {
	this.reLaunchRTP( "localhost" );
    }

    public void reLaunchRTP( String hostname ) {
	videohost = hostname;
	if( rtpinfo.getAddress().equalsIgnoreCase( rtpinfo.last_addr ) && 
	    rtpinfo.getPort() == rtpinfo.last_port &&
	       rtpinfo.getTTL() == rtpinfo.last_ttl ) 
	    return;
	rtpinfo.last_addr = rtpinfo.getAddress();
	rtpinfo.last_port = rtpinfo.getPort();
	rtpinfo.last_ttl  = rtpinfo.getTTL();

	if( player != null ) {
	    // need to stop the current RTP player
	    player.closeRTP( "changing streams" );
	    player = null;
	}
	// now to launch the new player with the new values
	address = rtpinfo.getAddress();
	port = rtpinfo.getPort();
	ttl = rtpinfo.getTTL();
	if( address != null && port > 0 ) {
	    if( DEBUG )
		System.out.println( "Launching new RTP " + media + " player on address " + 
				     address + " port " + port + " ttl " + ttl);
	    player = new RTPPlayer( address, port, ttl, media, comm );
	    player.regSessionListener( sources_pu );
	    player.regRecvListener( sources_pu );
	}
    }

    protected class MyEnumPopup extends PopupMenu 
	implements ActionListener, RTPSessionListener, RTPRecvStreamListener {

	MyEnumPopup() {
	}

	MyEnumPopup(Enumeration list) {
	    System.out.println("MyEnumPopup constructor, calling rePopulate");
	    rePopulate(list);
	}
	
	public void actionPerformed( ActionEvent e ) {
	    choiceAction( e.getActionCommand() );
	}

	protected void choiceAction( String cname ) {
	    // the user has selected a cname whose stream they wanted played
	    // so we need to start the player
	    if( DEBUG )
	      System.out.println( "starting player for " + cname + "media " + media );
	    player.startPlayer( cname );
	}
	

    /** Since this class implements the RTPSessionListener interface,
      * it must implement the RTPSessionUpdate() method
      */
    public void update(RTPRecvStreamEvent event){
	

	// find the sourceRTPSM for this event
	RTPSessionManager source =
	    (RTPSessionManager)event.getSource();
	RTPParticipant part = event.getParticipant();

	// add source to list of sources if a new recvstream is detected
	if (event instanceof NewRecvStreamEvent){
	    if( part != null )
		addParticipant( part.getCNAME() );
	    if( DEBUG )
		System.out.println("RTPStream: update - NewRecvStreamEvent of media " + media );
	}// instanceof newRecvStreamEvent
	else if (event instanceof RecvStreamMappedEvent){
	    System.out.println( "Received a stream mapped event for stream media " + media );
	    if( part != null ){
		addParticipant( part.getCNAME() );
		System.out.println( "participant " + part.getCNAME() + " videohost " + videohost );
		if( compareRTPSource( part.getCNAME(), videohost )) 
		    player.startPlayer( part.getCNAME() );
	    }
	}// instanceof RecvStreamMappedEvent

	else if (event instanceof ActiveRecvStreamEvent){
	    System.out.println( "RTPStream: Received a stream active event for stream media " + media );
	    if( part != null )
		addParticipant( part.getCNAME() );
	}// instanceof ActiveRecvStreamEvent

	else if (event instanceof InactiveRecvStreamEvent){
	    System.out.println( "RTPStream: Received a stream inactive event for stream media " + media );
	    for( int i = 0; i < getItemCount(); i++ ) {
		if( (part.getCNAME()).equals( getItem( i ))) {
		    remove( i );
		    break;
		}
	    }
	}// instanceof InactiveRecvStreamEvent

	else if (event instanceof PayloadChangeEvent){
	    System.out.println( "RTPStream: Received a stream payload change event for stream media " + media );
	}// instanceof PayloadChangeEvent
	else
	  System.out.println(" RTPStream: Received an uncaught RTPevent for stream " + media );
	//	if( media.equals( "video" )) {
	//	  System.out.println("About to repopulate popup menu of sources . . . calling" );
	//	  rePopulate((source.getActiveParticipants()).elements());
	//	}
	//	else {
	//	  rePopulate((source.getAllParticipants()).elements());
	//	}

	printParticipants( source );
	
    }// end of update( RTPRecvStreamEvent )



	public void update( RTPSessionEvent event ) {

	  // Trap the newparticipant events so we can populate the choice list
	  if( event instanceof NewParticipantEvent ) {
	    if( DEBUG )
	      System.out.println( "MyEnumPopup: Received a new participant event for " + media );
	    RTPSessionManager source = (RTPSessionManager)event.getSource();
	    System.out.println("Checking to see if this is the host we are looking for ");
	    if( media.equals( "video" )) {
	      rePopulate((source.getActiveParticipants()).elements());
	    }
	    else {
	      rePopulate((source.getAllParticipants()).elements());
	    }
	    printParticipants( source );
	  }
	}// end of update( RTPSessionEvent )

      public void printParticipants( RTPSessionManager source ) {
	  Vector list = source.getAllParticipants();
	  System.out.println( "Participants = " + media );
	  for( int i = 0; i < list.size(); i++ ) {
	      RTPParticipant cur = (RTPParticipant)(list.elementAt( i ));
	      System.out.println( "element " + i + " : " + (String)(cur.getCNAME()));
	  }

      }

	public void rePopulate( Enumeration list ) {
	    removeAll();
	    if( list == null || !(list.hasMoreElements()) ){
		add( new MenuItem("No sources/participants"));
	    }
	    else {
		MenuItem temp;
		if( DEBUG )
		  System.out.println( "RTPStreamMenu: Creating source list popup" );
		while( list.hasMoreElements()) {
		    RTPParticipant part = (RTPParticipant)list.nextElement();
		    add( temp = new MenuItem( (String)part.getCNAME() ));
		    System.out.println( "rePopulate: Added participant " + part.getCNAME());
		    temp.addActionListener( this );
		}
	    }
	}
	
        public void addParticipant( String cname ) {
	    for( int i = 0; i < getItemCount(); i++ ) {
		if( cname.equals( getItem( i ))){
		    remove( i );
		    break;
		}
	    }
	    MenuItem temp;
	    add( temp = new MenuItem( cname ));
	    if( DEBUG )
		System.out.println( "addParticipant: Added to the source list " + cname );
	}
    }

  protected class PlayerSettingMenu extends Frame {//implements ActionListener {

	int  size;
	boolean saveCPU = false;
	boolean seperateInterface = false;

	// define the constructor
	PlayerSettingMenu() {
	    setLayout( new GridLayout( 3, 1) );
	    add( new Label( "Size" ));
	    
	}
    }
   
    public boolean compareRTPSource( String cname, String host ) {
	try {
	    String chost = cname.substring( cname.indexOf( "@" ) + 1);
	    if( chost == null )
		return false;
	    System.out.println( "cname host is " + chost + " host " + host);
	    InetAddress temp1 = InetAddress.getByName( chost );
	    InetAddress temp2 = InetAddress.getByName( host );
	    System.out.println( "got both inet addresses " + temp1.getHostAddress() + 
				" second " + temp2.getHostAddress());
	    if( (temp1.getHostAddress()).equals( temp2.getHostAddress()) ){
		System.out.println("they match");
		return true;
	    }
	    else
		return false;
	}
	catch ( UnknownHostException e ) {
	    System.out.println( "Caught an unknown host exception");
	    return false;
	}
    }
}


   
