/*
 *  This class creates the window that plays out the RTP
 *  video or audio.  It provides a generic way to
 *  add an RTP display to an application.
 */
package CamClnt;

//import GUI.*;
import java.util.Hashtable;
import java.util.Enumeration;
import com.sun.media.ui.*;
import java.lang.String;
import java.awt.*;
import java.awt.event.*;
import java.io.IOException;
import java.net.*;
import javax.media.*;
import javax.media.protocol.DataSource;
import javax.media.rtp.session.*;
import com.sun.media.rtp.RTPPSM.*;


public class RTPPlayer extends Panel 
  implements RTPRecvStreamListener, RTPSessionListener{

    RTPSessionManager mymgr = null;
    String  textAddress;
    InetAddress address;
    int     port;
    int     ttl;
    Hashtable  sourceList;
    Player vidplayer = null;
    PlayerWindow  vidPlayerWindow = null;
    static final boolean DEBUG = true;
    int    numunknown=0;
    CamComm camcomm = null;
    String   type;
    ParticipantList participantGUI;

    /** RTP player constructor which instantiates the RTP
      * player
      */
    public RTPPlayer(String destaddress, int destport, int destttl, String media, CamComm commtemp) 
    {
	if(DEBUG)
	    System.out.println( "RTPPlayer: starting constructor");
	
	System.out.println("RTPPlayer--destaddress is " + destaddress + " destport is " + destport + "destttl is " + destttl);
	// create the sourceList hashtable
	sourceList = new Hashtable(5);

	// remember where the camera communication object is
	camcomm = commtemp;

	// remember what type of media stream this player is for
	type = media;

	// create the new RTPSessionManager
	System.out.println("RTPPlayer constructor--creating new RTPSessionMgr");
	mymgr = new RTPSessionMgr();
	if (mymgr == null) {
	    if( DEBUG )
		System.out.println("RTPPlayer: Unable to get a new RTPSessionMgr");
	    return;
	}
	System.out.println("mymgr is not a null RTPSessionMgr");
	// add this object as a RecvStreamListener to listen to
	// RecvStreamEvents for RTPRecvStreams of this session
	System.out.println("RTPPlayer--calling mymgr.addRecvStreamListener");
	mymgr.addRecvStreamListener(this);
	System.out.println("RTPPlayer--calling mymgr.addSessionListener");
	mymgr.addSessionListener( this );

	// ask RTPSM to generate the local participants CNAME
	String cname = mymgr.generateCNAME();
	if (cname != null)
		System.out.println("RTPPlayer--cname is " + cname);
	else
		System.out.println("mymgr.generateCNAME returned null");

	// add dynamic payload information to the RTPSM.
	if (media.equals("audio")) {
	    System.out.println( "Setting audio encoding" );
	    EncodingUtil.Init((RTPSessionManager)mymgr);
	}

	// create our local RTPSession Address
	System.out.println("RTPPlayer--creating localaddr = new RTPSessionAddress");
	RTPSessionAddress localaddr = new RTPSessionAddress();

	if (localaddr == null)
		System.out.println("localaddr is null");
	else
		System.out.println("localaddr is not null");
	
	try{
	    address = InetAddress.getByName(destaddress);
	}catch (UnknownHostException e){
	    System.err.println("inetaddress " + e.getMessage());
	    e.printStackTrace();
	}    
	
	if (address != null)
		System.out.println("RTPPlayer--InetAddress.getByName returned an address");
	else
		System.out.println("InetAddress.getByName returned null");
	textAddress = destaddress;
	port = destport;
	ttl  = destttl;

	System.out.println("RTPPlayer--textAddress = destaddress = " + textAddress);
	System.out.println("RTPPlayer--port = destport = " + port);
	System.out.println("RTPPlayer--ttl = destttl = " + destttl);
	RTPSessionAddress sessionaddress = new RTPSessionAddress(address,
								 port,
								 address,
								 port +1);
	if (sessionaddress != null)
	   System.out.println("RTPPlayer--sessionaddress is " + sessionaddress);
	else
	   System.out.println("RTPPlayer--sessionaddress is null");
	if( sessionaddress == null && DEBUG )
	    System.out.println( "RTPPlayer: Unable to get RTPSessionAddress addr " + address +
				" port " + port );
	
	System.out.println("RTPPlayer--making 4 userdesclists");
	// we send the email, name, cname and tool in the SDES items
	RTCPSourceDescription[] userdesclist = new RTCPSourceDescription[4];
	userdesclist[0] = new
	    RTCPSourceDescription(RTCPSourceDescription.SOURCE_DESC_EMAIL,
				  "unknown@camclnt", 1, false);
	userdesclist[1] = new
	    RTCPSourceDescription(RTCPSourceDescription.SOURCE_DESC_NAME,
				  System.getProperty("user.name"), 1, false);
	userdesclist[2] = new 
	    RTCPSourceDescription(RTCPSourceDescription.SOURCE_DESC_CNAME,
				  cname, 1, false);
	userdesclist[3] = new
	    RTCPSourceDescription(RTCPSourceDescription.SOURCE_DESC_TOOL,
				  "CamClnt using JMF RTP Player v1.0", 1,
				  false);

	// call initSession() and startSession() on the RTPSM.
	try{
	    if( DEBUG )
		System.out.println("RTPPlayer: Initializing and starting session");
	    System.out.println("RTPPlayer--calling mymgr.initSession");
	    mymgr.initSession(localaddr,
			      userdesclist,
			      0.05,
			      0.25);
	    System.out.println("RTPPlayer--mymgr.initSession returned--calling mymgr.startSession");
	    mymgr.startSession(sessionaddress, ttl, null);
	    System.out.println("RTPPlayer--mymgr.startSession() returned");
	}catch (RTPSessionManagerException e){
	    System.err.println("InitSession(): StartSession():Exception " +
			       e.getMessage());
	    e.printStackTrace();
	    return;
	}catch (IOException e){
	    System.err.println("StartSession : IOException " + e.getMessage());
	    e.printStackTrace();
	    return;
	}

	// Now to create the participant list
	// start the RTPMonitoring GUI, it will be made visible by
	// the Show() method on a user clicking the button

	System.out.println("RTPPlayer--getting a new ParticipantList for destaddr " + destaddress);
	participantGUI = new ParticipantList(destaddress, destport, destttl, media);
	participantGUI.updateList((mymgr.getActiveParticipants()).elements());
	participantGUI.show();
	System.out.println("RTPPlayer--after participantGUI.show()--we're outta here");
    }

    /** Since this class implements the RTPSessionListener interface,
      * it must implement the RTPSessionUpdate() method
      */
    public void update(RTPRecvStreamEvent event){
	System.out.println("update starting");
	// find the sourceRTPSM for this event
	RTPSessionManager source =
	    (RTPSessionManager)event.getSource();
	RTPRecvStream stream = null;
	RTPParticipant part = null;
	try{
	  // get a handle over the RTPRecvStream
	  stream =((RTPRecvStreamEvent)event).getRecvStream();
	  if( stream == null ) {
	    if( DEBUG )
		System.out.println( "RTPPlayer: New stream null" );
	    return;
	  }
	  part = stream.getParticipant();
	  if( part != null && DEBUG )
	      System.out.println( "RTPPlayer: RTPRecvStreamEvent received participant cname = " +
				  part.getCNAME());
	} catch (Exception e){
	    System.err.println("newRecvStreamEvent exception " +
				   e.getMessage());
		e.printStackTrace();
		return;
	}
	String cname;
	if( part != null ) {
	    cname = part.getCNAME();
	}
	else {
	    numunknown++;
	    cname = "unknown" + numunknown;
	}

	// add source to list of sources if a new recvstream is detected
	if (event instanceof NewRecvStreamEvent){
	    if( DEBUG )
		System.out.println("RTPPlayer: update - NewRecvStreamEvent of type " + type );
	    // we will wait to put this stream into the hash table until it is mapped

	}// instanceof newRecvStreamEvent
	else if (event instanceof RecvStreamMappedEvent){
	    System.out.println( "Received a stream mapped event for stream type " + type );
	    // If this is a valid participant then save the stream into a hash
	    // table so we can retrieve and display it later if the user requests.
	    if (part != null) {
		if( cname != null)
		    System.out.println( "RTPPlayer adding list item to participant GUI for " + cname);
		else 
		    System.out.println( "RTPPlayer: something wrong cname is null" );
		participantGUI.addListItem( cname );
	    } else {
		System.out.println( "just got a mapped unknown stream ????" );
	    }
	    
	    if( DEBUG )
		System.out.println( "Adding " + cname + " to the hash table");
	    sourceList.put( cname, stream );

	}// instanceof RecvStreamMappedEvent

	else if (event instanceof ActiveRecvStreamEvent){
	    System.out.println( "Received a stream active event for stream type " + type );
	    sourceList.put( cname, stream );
	}// instanceof ActiveRecvStreamEvent

	else if (event instanceof InactiveRecvStreamEvent){
	    System.out.println( "Received a stream inactive event for stream type " + type );
	    if( part != null ) {
	      participantGUI.removeListItem( cname );
		sourceList.remove( cname );
	    }
	}// instanceof InactiveRecvStreamEvent

	else if (event instanceof PayloadChangeEvent){
	    System.out.println( "Received a stream payload change event for stream type " + type );
	}// instanceof PayloadChangeEvent
	else
	  System.out.println(" Received an uncaught RTPevent for stream " + type );

    }// end of update( RTPRecvStreamEvent )

    public void update( RTPSessionEvent event ) {
	System.out.println("update starting");
	// Trap the newparticipant events so we can give a membership list
	if( event instanceof NewParticipantEvent ) {
	    System.out.println( "Received a new participant event for stream type " + type );
	    RTPSessionManager source = (RTPSessionManager)event.getSource();
	    Enumeration participants = (source.getActiveParticipants()).elements();
	    while (participants.hasMoreElements()) {
		RTPParticipant cur = (RTPParticipant)participants.nextElement();
		System.out.println( "Active Participant: " + cur.getCNAME());
	    }
	    participants = (source.getPassiveParticipants()).elements();
	    while( participants.hasMoreElements() ) {
		RTPParticipant cur = (RTPParticipant)participants.nextElement();
		System.out.println( "Passive Participant: " + cur.getCNAME());
	    }
	}
	if( event instanceof LocalCollisionEvent ) {
	    System.out.println( "Received a local collision event for stream " + type );
	}
    }// end of update( RTPSessionEvent )

    /** Method to allow people to get a list of the
      * cnames of all the video sources we know of for this RTP session.
      */
    public Enumeration getSources() {
	if( DEBUG )
	    System.out.println( "RTPPlayer: returning a list of the sources" );
	return sourceList.keys();
    }

    /**  Start a player for the designated source.
      */
    public void startPlayer(String cname) {

	System.out.println("startPlayer method starting for cname " + cname);
	int temp = cname.indexOf("unknown");
	if (DEBUG)
	    System.out.println("RTPPlayer: Starting a " + type + " player for cname = " + cname);

	RTPRecvStream stream = (RTPRecvStream)sourceList.get( cname );
	if( stream == null )
	    System.out.println( "Something wrong could not retrieve stream " +
				"from hash table cname:" + cname );
	if( temp != -1 ){
	    RTPParticipant part = stream.getParticipant();
	    if( part != null && DEBUG )
		System.out.println( "RTPPlayer: New stream received participant cname = " +
				    part.getCNAME());
	    if (part != null) {
		String cname2 = part.getCNAME();
		sourceList.remove( cname );
		sourceList.put( cname2, stream );
	    }
	}	    

	try{
	  // get a handle over the RecvStream datasource
	  DataSource dsource = stream.getDataSource();

	  if( dsource == null )
	    System.out.println( "RTPPlayer:  No data source for this stream" );
	  
	  // create a player by passing datasource to the Media Manager
	  vidplayer = Manager.createPlayer(dsource);
	}catch (Exception e){
	  System.err.println("newRecvStreamEvent exception " +
			     e.getMessage());
	  e.printStackTrace();
	  return;
	}
	if (vidplayer == null)
	    return;
	// send this player to player GUI
	if( vidPlayerWindow != null )
	    vidPlayerWindow.killThePlayer();
	System.out.println("startPlayer--creating new PlayerWindow");
	vidPlayerWindow = new PlayerWindow( vidplayer );
	vidPlayerWindow.setTitle( cname );
	if( type.equals( "video" ))
	    vidPlayerWindow.regMyMouseListener( new mouseComms() );
	//vidPlayerWindow.addMouseListener( new mouseComms() );
    }

    /** Close down the session manager
      */
    public void closeRTP( String reason ) {
	if( DEBUG )
	    System.out.println( "RTPPlayer: Close of session initiated");
	mymgr.closeSession( reason );
	return;
    }

    public void regSessionListener( RTPSessionListener listener ) {
	mymgr.addSessionListener( listener );
    }

    public void regRecvListener( RTPRecvStreamListener listener ) {
	mymgr.addRecvStreamListener( listener );
    }

    protected class mouseComms extends MouseAdapter {
      private boolean  pnp = false;
      private int      boxX, boxY, boxW = 2, boxH = 2;
      private int      pnpboxX, pnpboxY, pnpboxW, pnpboxH;
      private int      firstX, firstY;
      private int      rectX = 2, rectY = 2, rectW = 100, rectH = 100;
      private double   maxpanspeed = 0.95;
      private double   maxtiltspeed = 0.95;

      
  /** this method is called any time the mouse button is pressed in the image
    * At this point we just draw a little square here and do the real work
    * when the mouse button is released.
    */
    public  void mousePressed (MouseEvent e) {
      
	boxX = e.getX();
        boxY = e.getY();
	boxW = 2;
	boxH = 2;
    }
  /** this method is called when the mouse button is released in the image area.
    * now we need to do the real work of processing the requested action.  If the
    * user simply clicked the mouse button on the image then pan and tilt to center
    * the selected location.  If they moved the mouse while the button was down
    * then the user is either selecting a zoom or a picture-in-picture action
    * depending on which mouse button was pressed.
    */
    public  void mouseReleased (MouseEvent e) {

	String temp;

	Dimension size = vidPlayerWindow.getPlayerSize();
	rectH = (int)size.height;
	rectW = (int)size.width;
	if( DEBUG )
	  System.out.println( "RTP window height = " + rectH + " width = " + rectW);
	if( Math.abs(e.getX() - boxX) > 1.0 && Math.abs( e.getY() - boxY ) > 1.0 ) {
	  // the user moved the mouse during the time they had the mouse button pressed
	    if( DEBUG) 
	      System.out.println( "requesting a zoom or a pnp" );
	    if( e.isMetaDown() ){
	        // right mouse button pressed so doing picture in picture
		// if there is already a pnp showing then assume the user wants the
		// pnp image translated on the screen.  If they have specified a move
		// that will take the pnp image off the screen put it at the edge.
	        if( pnp == true ) {
		    // there is already a pnp showing
		    // first to determine how far the user wants the box moved
		    int transX = e.getX() - boxX;
		    int transY = e.getY() - boxY;
		    // now to make sure the translation will keep the box on the image
		    if( (transX + pnpboxX + pnpboxW) > (rectW + rectX) ){
			transX = rectW + rectX - pnpboxW - pnpboxX;
		    }
		    if( (transY + pnpboxY + pnpboxH) > (rectH + rectY) ) {
			transY = rectH + rectY - pnpboxH - pnpboxY;
		    }
		    if( (transX + pnpboxX) < rectX ){
			transX = -pnpboxX;
		    }
		    if( (transY + pnpboxY) < rectY ) {
			transY = -pnpboxY;
		    }
		    // now to calculate the fraction of the image area we want to move
		    double ftransX = (double)transX / (double)rectW;
		    double ftransY = (double)transY / (double)rectH;
		    // create the command requesting the translation of the pnp box
		    temp = "pnp tra R " + ftransX + " " + ftransY;
		    camcomm.writePnpString( temp );
		    pnpboxX += transX;
		    pnpboxY += transY;
		}
		else {
		    // there is not currently a picture-in-picture showing so we
		    // need to put one up.
		    pnp = true;
		    pnpboxX = boxX;
		    pnpboxY = boxY;
		    pnpboxW = e.getX() - boxX;
		    pnpboxH = e.getY() - boxY;

		    // reset the coordinates so that the X,Y pair is the upper
		    // left corner of the box
		    if( pnpboxW < 0 ) {
			pnpboxX = pnpboxX + pnpboxW;
			pnpboxW *= -1;
		    }
		    if( pnpboxH < 0 ) {
			pnpboxY = pnpboxY + pnpboxH;
			pnpboxH *= -1;
		    }
		    // make the box square by averaging the dimensions
		    pnpboxW = (int)(((double)( pnpboxW + pnpboxH ))/2.0);
		    pnpboxH = pnpboxW;
		    if( DEBUG) 
		      System.out.println( "pnpboxW = " + pnpboxW + "pnpboxH = " + pnpboxH);

		    // now to scale the values so that they are in the correct
		    // scale to send to the server and send them to the server (fractional).
		    double fpnpX = (double)(pnpboxX - 
					    rectX ) / (double)rectW;
		    double fpnpY = (double)(pnpboxY - rectY) / (double)rectH;
		    double fpnpW = (double)pnpboxW / (double)rectW;
		    double fpnpH = (double)pnpboxH / (double)rectH;
		    temp = "pnp sta on@pnp tra A " + fpnpX + " " +
		           fpnpY + "@pnp siz A " + fpnpW + " " + fpnpH;
		    camcomm.writePnpString( temp );
		}
	    }
	    else {
	      // user is requesting a fractional zoom
	      // calculate the width and height of the box the user drew
	      // the temp variables will be used to help get the center for the translation
	      int tempW = e.getX() - boxX;
	      int tempH = e.getY() - boxY;
	      boxW = Math.abs( tempW );
	      boxH = Math.abs( tempH );
	      // use the average of the two dimensions to determine the requested zoom
	      double fzoom = (((double) boxW/(double)rectW) + ((double)boxH/(double)rectH))/2.0;
	      // Calculate the translation required to center the area we are zooming in on
	      double ftilt = -1.0 * (double)(e.getY() - (tempH/2.0) - rectY - (rectH / 2.0)) / (double)rectH;
	      double fpan  = (double)(e.getX() - (tempW/2.0) - rectX - (rectW / 2.0 )) / (double)rectW;
	      
	      temp = "tilt F " + ftilt + " " + maxtiltspeed +
	                  "@pan F " + fpan + " " + maxpanspeed + "@zoom F " + fzoom + 
		          " " + maxtiltspeed;
	      camcomm.writeCamString( temp );
	    }
	}
	else if( e.isMetaDown() ){
            // user tapped the right mouse button once so turn off picture-in-picture
	    pnp = false;
	    temp = "off";
	    camcomm.writePnpString( temp );
	}
	else {
	    // user is requesting a fractional pan/tilt so calculate where to
	    // translate the camera (tell the camera to center on the place where
	    // the mouse was when the user hit the left mouse button)
	    double ftilt = -1.0 * (double)(e.getY() - rectY - (rectH / 2.0)) / (double)rectH;
	    double fpan  = (double)(e.getX() - rectX - (rectW / 2.0 )) / (double)rectW;
	    if( ftilt > 0.45 || ftilt < -0.45 )
	        ftilt = ftilt * 2.0;
	    if( fpan > 0.45 || fpan < -0.45 )
	        fpan = fpan * 2.0;
	    temp = "tilt F " + ftilt + " " + maxtiltspeed +
	                  "@pan F " + fpan + " " + maxpanspeed;
	    camcomm.writeCamString( temp );
	}
    }
    }
}
