/*
 * @(#)PlayerWindow.java	1.26 98/03/28
 *
 * Copyright 1996-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */


package CamClnt;

import javax.media.*;
import java.awt.*;
import java.awt.event.*;
import com.sun.media.*;
import com.sun.media.controls.*;

public class PlayerWindow extends Frame implements ControllerListener {

    Player player;
    Panel framePanel;
    ComponentListener cl;
    ComponentListener fcl;
    WindowListener wl;
    MouseListener ml;
    
    Component controlComp = null;
    Component visualComp = null;
    Insets insets;
    PopupMenu zoomMenu = null;
    boolean windowCreated = false;
    boolean newVideo = true;
    boolean panelResized = false;
    Component progressBar = null;
    
    public PlayerWindow(Player player) {
	super("Java Media Player");
	this.player = player;
	setLayout( new BorderLayout() );

	framePanel = new Panel();
	framePanel.setLayout( null );
	add(framePanel, "Center");
	
	insets = getInsets();
	setSize(insets.left + insets.right + 320,
		insets.top + insets.bottom + 30);

	setVisible(true);
	
	// Anonymous class
	addWindowListener( wl = new WindowAdapter() {
	    public void windowClosing(WindowEvent we) {
		killThePlayer();
	    }
	});

	framePanel.addComponentListener( fcl = new ComponentAdapter() {
	    public void componentResized(ComponentEvent ce) {
		panelResized = true;
		doResize();
	    }
	});

	addComponentListener( fcl = new ComponentAdapter() {
	    public void componentResized(ComponentEvent ce) {
		insets = getInsets();
		Dimension dim = getSize();
		framePanel.setSize(dim.width - insets.left - insets.right,
				   dim.height - insets.top - insets.bottom);
	    }
	});

	/*
	addComponentListener( cl = new ComponentAdapter() {
	    public void componentResized(ComponentEvent ce) {
		framePanel.invalidate();
		doResize();
	    }
	});
	*/

	player.addControllerListener( this );
	player.realize();
	//player.start();
    }

    void sleep(long time) {
    	try {
            Thread.currentThread().sleep(time);
        } catch (Exception e) {
        }
    }

    public void addNotify() {
	super.addNotify();
	windowCreated = true;
	invalidate();
    }

    public void doResize() {
	Dimension d = framePanel.getSize();
	int videoHeight = d.height;
	if (controlComp != null) {
	    videoHeight -= controlComp.getPreferredSize().height;
	    if (videoHeight < 2)
		videoHeight = 2;
	    if (d.width < 80)
		d.width = 80;
	    controlComp.setBounds(0, videoHeight,
				  d.width, controlComp.getPreferredSize().height);
	    controlComp.invalidate();
	}

	if (visualComp != null) {
	    visualComp.setBounds(0, 0, d.width, videoHeight);
	}
	framePanel.validate();
    }

    public synchronized void killThePlayer() {
	/*
	player.stop();
	player.deallocate();
	*/
	// in order to avoid deadlock problems, remove visual and
	// control component if they are present, before closing the
	// player
	if (visualComp != null)
	    framePanel.remove(visualComp);
	if (controlComp != null)
	    framePanel.remove(controlComp);
	player.close();
    }

    public synchronized void controllerUpdate(ControllerEvent ce) {
	if (ce instanceof RealizeCompleteEvent) {
	    int width = 320;
	    int height = 0;
	    insets = getInsets();
	    
	    if (progressBar != null)
		framePanel.remove(progressBar);

	    if (( visualComp = player.getVisualComponent()) != null) {
		width = visualComp.getPreferredSize().width;
		height = visualComp.getPreferredSize().height;
		framePanel.add(visualComp);
		visualComp.setBounds(0, 0, width, height);
		addPopupMenu(visualComp);
	    }
	    
	    if ((controlComp = player.getControlPanelComponent()) != null) {
		int prefHeight = controlComp.getPreferredSize().height;
		framePanel.add(controlComp);
		controlComp.setBounds(0, height, width, prefHeight);
		height += prefHeight;
	    }
	    setSize(width + insets.left + insets.right,
		    height + insets.top + insets.bottom);
	    player.prefetch();

	} else if (ce instanceof PrefetchCompleteEvent) {
	    if (player.getTargetState() != Controller.Started) {
		player.start();
	    }
	} else if (ce instanceof EndOfMediaEvent) {
	    player.setMediaTime(new Time(0));
	    if (player.getMediaNanoseconds() == 0)
		player.start();
	    else
		System.err.println("Failed to loop back: the player is not seekable.");
	} else if (ce instanceof ControllerErrorEvent) {
	    System.err.println("Received controller error");
	    killThePlayer();
	    dispose();
	    player.close();
	} else if (ce instanceof SizeChangeEvent) {
	    // The video size has changed, resize the panel
	    if (framePanel != null) {
		SizeChangeEvent sce = (SizeChangeEvent) ce;
		int nooWidth = sce.getWidth();
		int nooHeight = sce.getHeight();
		// Add the height of the default control component
		if (controlComp != null)
		    nooHeight += controlComp.getPreferredSize().height;
		if (  framePanel.getSize().width != nooWidth ||
		      framePanel.getSize().height != nooHeight) {
		    setSize(nooWidth + insets.left + insets.right,
			    nooHeight + insets.top + insets.bottom);
		    //validate();
		} else
		    doResize();

		if (controlComp != null)
		    controlComp.invalidate();
	    }
	} else if (ce instanceof ControllerClosedEvent) {
	    if (visualComp != null) {
		visualComp.remove(zoomMenu);
		visualComp.removeMouseListener(ml);
	    }
	    removeWindowListener(wl);
	    removeComponentListener(cl);

	    if (framePanel != null)
		framePanel.removeAll();
	    player = null;
	    visualComp = null;
	    controlComp = null;
	    sleep(200);
	    dispose();
	} else if (ce instanceof CachingControlEvent) {
	    CachingControl cc = ((CachingControlEvent)ce).getCachingControl();
	    if (cc != null && progressBar == null) {
		progressBar = cc.getControlComponent();
		if (progressBar == null)
		    progressBar = cc.getProgressBarComponent();
		if (progressBar != null) {
		    framePanel.add(progressBar);
		    Dimension prefSize = progressBar.getPreferredSize();
		    progressBar.setBounds(0, 0, prefSize.width, prefSize.height);
		    insets = getInsets();
		    framePanel.setSize(prefSize.width, prefSize.height);
		    setSize(insets.left + insets.right + prefSize.width,
			    insets.top + insets.bottom + prefSize.height);
		}
	    }
	}
    }

    public void zoomTo(float z) {
	if (visualComp != null) {
	    insets = getInsets();
	    Dimension d = visualComp.getPreferredSize();
	    d.width = (int) (d.width * z);
	    d.height = (int) (d.height * z);
	    if (controlComp != null)
		d.height += controlComp.getPreferredSize().height;
	    
	    setSize(d.width + insets.left + insets.right,
		    d.height + insets.top + insets.bottom);
	}
    }

    private void addPopupMenu(Component visual) {
	MenuItem mi;
	ActionListener zoomSelect;
	
	zoomMenu = new PopupMenu("Zoom");

	zoomSelect = new ActionListener() {
	    public void actionPerformed(ActionEvent ae) {
		String action = ae.getActionCommand();
		if (action.indexOf("1:2") >= 0)
		    zoomTo(0.5f);
		else if (action.indexOf("1:1") >= 0)
		    zoomTo(1.0f);
		else if (action.indexOf("2:1") >= 0)
		    zoomTo(2.0f);
		else if (action.indexOf("4:1") >= 0)
		    zoomTo(4.0f);
	    }
	};
	visual.add(zoomMenu);
	mi = new MenuItem("Scale 1:2");
	zoomMenu.add(mi);
	mi.addActionListener(zoomSelect);
	mi = new MenuItem("Scale 1:1");
	zoomMenu.add(mi);
	mi.addActionListener(zoomSelect);
	mi = new MenuItem("Scale 2:1");
	zoomMenu.add(mi);
	mi.addActionListener(zoomSelect);
	mi = new MenuItem("Scale 4:1");
	zoomMenu.add(mi);
	mi.addActionListener(zoomSelect);
	
       	visual.addMouseListener( ml = new MouseAdapter() {
       	    public void mousePressed(MouseEvent me) {
       		if (me.isShiftDown())
       		    zoomMenu.show(visualComp, me.getX(), me.getY());
	    }

       	    public void mouseReleased(MouseEvent me) {
	      //if (me.isPopupTrigger())
	      //zoomMenu.show(visualComp, me.getX(), me.getY());
	    }
	
       	    public void mouseClicked(MouseEvent me) {
	      //if (me.isPopupTrigger())
	      //zoomMenu.show(visualComp, me.getX(), me.getY());
       	    }
       	} );
    }
  
    /** Register a mouse listener for this player
      */
    public void regMyMouseListener( MouseAdapter ma ) {
	if( ma == null )
	  System.out.println( "Null mouse adapter passed to player");
	while( visualComp == null )
	  System.out.println("Waiting" );
	visualComp.addMouseListener( ma );
	return;
    }

    /** Return the current size of the player window
      */
    public Dimension getPlayerSize() {
        return visualComp.getPreferredSize();
    }
}
    
    
